/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.web.internal.portlet.action;

import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.service.DDLRecordSetService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.PortletPreferencesException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.service.WorkflowDefinitionLinkLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.StrictPortletPreferencesImpl;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_dynamic_data_lists_web_portlet_DDLPortlet", "mvc.command.name=addRecordSet"}, service={MVCActionCommand.class})
public class AddRecordSetMVCActionCommand
extends BaseMVCActionCommand {
    protected DDLRecordSetService ddlRecordSetService;
    protected WorkflowDefinitionLinkLocalService workflowDefinitionLinkLocalService;

    protected DDLRecordSet addRecordSet(ActionRequest actionRequest) throws PortalException {
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        long ddmStructureId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"ddmStructureId");
        Map nameMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"name");
        Map descriptionMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"description");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DDLRecordSet.class.getName(), (PortletRequest)actionRequest);
        return this.ddlRecordSetService.addRecordSet(groupId, ddmStructureId, null, nameMap, descriptionMap, 10, 0, serviceContext);
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        DDLRecordSet recordSet = this.addRecordSet(actionRequest);
        this.updateWorkflowDefinitionLink(actionRequest, recordSet);
        this.updatePortletPreferences(actionRequest, recordSet);
    }

    protected PortletPreferences getStrictPortletSetup(ActionRequest actionRequest) throws PortalException {
        String portletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletResource");
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return this.getStrictPortletSetup(themeDisplay.getLayout(), portletResource);
    }

    protected PortletPreferences getStrictPortletSetup(Layout layout, String portletId) throws PortalException {
        if (Validator.isNull((String)portletId)) {
            return null;
        }
        PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.getStrictPortletSetup((Layout)layout, (String)portletId);
        if (portletPreferences instanceof StrictPortletPreferencesImpl) {
            throw new PortletPreferencesException.MustBeStrict(portletId);
        }
        return portletPreferences;
    }

    @Reference(unbind="-")
    protected void setDDLRecordSetService(DDLRecordSetService ddlRecordSetService) {
        this.ddlRecordSetService = ddlRecordSetService;
    }

    @Reference(unbind="-")
    protected void setWorkflowDefinitionLinkLocalService(WorkflowDefinitionLinkLocalService workflowDefinitionLinkLocalService) {
        this.workflowDefinitionLinkLocalService = workflowDefinitionLinkLocalService;
    }

    protected void updatePortletPreferences(ActionRequest actionRequest, DDLRecordSet recordSet) throws Exception {
        PortletPreferences portletPreferences = this.getStrictPortletSetup(actionRequest);
        if (portletPreferences == null) {
            return;
        }
        portletPreferences.reset("displayDDMTemplateId");
        portletPreferences.reset("editable");
        portletPreferences.reset("formDDMTemplateId");
        portletPreferences.reset("spreadsheet");
        portletPreferences.setValue("recordSetId", String.valueOf(recordSet.getRecordSetId()));
        portletPreferences.store();
    }

    protected void updateWorkflowDefinitionLink(ActionRequest actionRequest, DDLRecordSet recordSet) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        String workflowDefinition = ParamUtil.getString((PortletRequest)actionRequest, (String)"workflowDefinition");
        this.workflowDefinitionLinkLocalService.updateWorkflowDefinitionLink(themeDisplay.getUserId(), themeDisplay.getCompanyId(), groupId, DDLRecordSet.class.getName(), recordSet.getRecordSetId(), 0L, workflowDefinition);
    }
}

