/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.web.internal.portlet;

import com.liferay.dynamic.data.lists.exception.NoSuchRecordException;
import com.liferay.dynamic.data.lists.exception.NoSuchRecordSetException;
import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.service.DDLRecordService;
import com.liferay.dynamic.data.lists.service.DDLRecordSetLocalService;
import com.liferay.dynamic.data.lists.service.DDLRecordSetService;
import com.liferay.dynamic.data.lists.util.DDL;
import com.liferay.dynamic.data.lists.web.configuration.DDLWebConfiguration;
import com.liferay.dynamic.data.lists.web.internal.display.context.DDLDisplayContext;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.dynamic.data.mapping.storage.StorageEngine;
import com.liferay.dynamic.data.mapping.util.DDMDisplayRegistry;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.PortletPreferencesException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCPortlet;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.dynamic.data.lists.web.configuration.DDLWebConfiguration"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, immediate=true, property={"com.liferay.portlet.add-default-resource=true", "com.liferay.portlet.css-class-wrapper=portlet-dynamic-data-lists", "com.liferay.portlet.display-category=category.hidden", "com.liferay.portlet.header-portal-javascript=/o/dynamic-data-mapping-web/js/custom_fields.js", "com.liferay.portlet.header-portal-javascript=/o/dynamic-data-mapping-web/js/main.js", "com.liferay.portlet.header-portlet-css=/css/main.css", "com.liferay.portlet.header-portlet-javascript=/js/main.js", "com.liferay.portlet.icon=/icons/dynamic_data_lists.png", "com.liferay.portlet.preferences-owned-by-group=true", "com.liferay.portlet.private-request-attributes=false", "com.liferay.portlet.private-session-attributes=false", "com.liferay.portlet.render-weight=50", "com.liferay.portlet.scopeable=true", "com.liferay.portlet.use-default-template=true", "com.liferay.portlet.webdav-storage-token=dynamic_data_lists", "javax.portlet.display-name=Dynamic Data Lists", "javax.portlet.expiration-cache=0", "javax.portlet.init-param.copy-request-parameters=true", "javax.portlet.init-param.template-path=/META-INF/resources/", "javax.portlet.init-param.view-template=/view.jsp", "javax.portlet.name=com_liferay_dynamic_data_lists_web_portlet_DDLPortlet", "javax.portlet.resource-bundle=content.Language", "javax.portlet.security-role-ref=power-user,user", "javax.portlet.supports.mime-type=text/html"}, service={Portlet.class})
public class DDLPortlet
extends MVCPortlet {
    private static final Log _log = LogFactoryUtil.getLog(DDLPortlet.class);
    private DDL _ddl;
    private DDLRecordService _ddlRecordService;
    private DDLRecordSetLocalService _ddlRecordSetLocalService;
    private DDLRecordSetService _ddlRecordSetService;
    private volatile DDLWebConfiguration _ddlWebConfiguration;
    private DDMDisplayRegistry _ddmDisplayRegistry;
    private DDMTemplateLocalService _ddmTemplateLocalService;
    @Reference
    private Portal _portal;
    private StorageEngine _storageEngine;

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException, PortletException {
        super.processAction(actionRequest, actionResponse);
        this.setCloseRedirect(actionRequest);
    }

    public void render(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        try {
            this.setDDLRecordRequestAttribute(renderRequest);
            this.setDDLRecordSetRequestAttribute(renderRequest);
            HttpServletRequest request = this._portal.getHttpServletRequest((PortletRequest)renderRequest);
            DDLDisplayContext ddlDisplayContext = new DDLDisplayContext(request, this._ddl, this._ddlRecordSetLocalService, this._ddlWebConfiguration, this._ddmDisplayRegistry, this._ddmTemplateLocalService, this._storageEngine);
            renderRequest.setAttribute("PORTLET_DISPLAY_CONTEXT", (Object)ddlDisplayContext);
        }
        catch (NoSuchRecordException | NoSuchRecordSetException e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)e, e);
            }
        }
        catch (PortalException pe) {
            SessionErrors.add((PortletRequest)renderRequest, ((Object)((Object)pe)).getClass());
        }
        super.render(renderRequest, renderResponse);
    }

    @Reference(unbind="-")
    public void setDDL(DDL ddl) {
        this._ddl = ddl;
    }

    @Reference(unbind="-")
    public void setDDLRecordService(DDLRecordService ddlRecordService) {
        this._ddlRecordService = ddlRecordService;
    }

    @Reference(unbind="-")
    public void setDDLRecordSetLocalService(DDLRecordSetLocalService ddlRecordSetLocalService) {
        this._ddlRecordSetLocalService = ddlRecordSetLocalService;
    }

    @Reference(unbind="-")
    public void setDDLRecordSetService(DDLRecordSetService ddlRecordSetService) {
        this._ddlRecordSetService = ddlRecordSetService;
    }

    @Reference(unbind="-")
    public void setDDMDisplayRegistry(DDMDisplayRegistry ddmDisplayRegistry) {
        this._ddmDisplayRegistry = ddmDisplayRegistry;
    }

    @Reference(unbind="-")
    public void setDDMTemplateLocalService(DDMTemplateLocalService ddmTemplateLocalService) {
        this._ddmTemplateLocalService = ddmTemplateLocalService;
    }

    @Reference(unbind="-")
    public void setStorageEngine(StorageEngine storageEngine) {
        this._storageEngine = storageEngine;
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._ddlWebConfiguration = (DDLWebConfiguration)ConfigurableUtil.createConfigurable(DDLWebConfiguration.class, properties);
    }

    protected void doDispatch(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        if (SessionErrors.contains((PortletRequest)renderRequest, (String)NoSuchRecordException.class.getName()) || SessionErrors.contains((PortletRequest)renderRequest, (String)NoSuchRecordSetException.class.getName()) || SessionErrors.contains((PortletRequest)renderRequest, (String)PortletPreferencesException.MustBeStrict.class.getName()) || SessionErrors.contains((PortletRequest)renderRequest, (Class[])PrincipalException.getNestedClasses())) {
            this.include("/error.jsp", renderRequest, renderResponse);
        } else {
            super.doDispatch(renderRequest, renderResponse);
        }
    }

    protected void setCloseRedirect(ActionRequest actionRequest) {
        String closeRedirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"closeRedirect");
        if (Validator.isNull((String)closeRedirect)) {
            return;
        }
        SessionMessages.add((PortletRequest)actionRequest, (String)(this._portal.getPortletId((PortletRequest)actionRequest) + ".closeRedirect"), (Object)closeRedirect);
    }

    protected void setDDLRecordRequestAttribute(RenderRequest renderRequest) throws PortalException {
        long recordId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"recordId");
        DDLRecord record = null;
        if (recordId > 0L) {
            record = this._ddlRecordService.getRecord(recordId);
        }
        renderRequest.setAttribute("DYNAMIC_DATA_LISTS_RECORD", record);
    }

    protected void setDDLRecordSetRequestAttribute(RenderRequest renderRequest) throws PortalException {
        long recordSetId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"recordSetId");
        DDLRecordSet recordSet = null;
        if (recordSetId > 0L) {
            recordSet = this._ddlRecordSetService.getRecordSet(recordSetId);
        }
        DDLRecord record = (DDLRecord)renderRequest.getAttribute("DYNAMIC_DATA_LISTS_RECORD");
        if (recordSet == null && record != null) {
            recordSet = record.getRecordSet();
        }
        renderRequest.setAttribute("DYNAMIC_DATA_LISTS_RECORD_SET", (Object)recordSet);
    }
}

