/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.web.internal.display.context;

import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.model.DDLRecordVersion;
import com.liferay.dynamic.data.lists.util.comparator.DDLRecordCreateDateComparator;
import com.liferay.dynamic.data.lists.util.comparator.DDLRecordModifiedDateComparator;
import com.liferay.dynamic.data.mapping.exception.StorageException;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletRequest;

public class DDLViewRecordsDisplayContext {
    private static final int _TOTAL_COLUMNS = 5;
    private final DDLRecordSet _ddlRecordSet;
    private List<DDMFormField> _ddmFormFields;
    private final DDMStructure _ddmStructure;
    private final LiferayPortletRequest _liferayPortletRequest;

    public DDLViewRecordsDisplayContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, long formDDMTemplateId) throws PortalException {
        this._liferayPortletRequest = liferayPortletRequest;
        this._ddlRecordSet = (DDLRecordSet)this._liferayPortletRequest.getAttribute("DYNAMIC_DATA_LISTS_RECORD_SET");
        this._ddmStructure = this._ddlRecordSet.getDDMStructure(formDDMTemplateId);
    }

    public OrderByComparator<DDLRecord> getDDLRecordOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        Object orderByComparator = null;
        orderByComparator = orderByCol.equals("modified-date") ? new DDLRecordModifiedDateComparator(orderByAsc) : new DDLRecordCreateDateComparator(orderByAsc);
        return orderByComparator;
    }

    public DDLRecordSet getDDLRecordSet() {
        return this._ddlRecordSet;
    }

    public List<DDMFormField> getDDMFormFields() {
        if (this._ddmFormFields == null) {
            DDMForm ddmForm = this._ddmStructure.getDDMForm();
            ArrayList<DDMFormField> ddmFormFields = new ArrayList<DDMFormField>();
            for (DDMFormField ddmFormField : ddmForm.getDDMFormFields()) {
                this.addDDMFormField(ddmFormFields, ddmFormField);
            }
            int totalColumns = 5;
            if (ddmFormFields.size() < totalColumns) {
                totalColumns = ddmFormFields.size();
            }
            this._ddmFormFields = ddmFormFields.subList(0, totalColumns);
        }
        return this._ddmFormFields;
    }

    public Map<String, List<DDMFormFieldValue>> getDDMFormFieldValuesMap(DDLRecordVersion recordVersion) throws StorageException {
        DDMFormValues ddmFormValues = recordVersion.getDDMFormValues();
        List ddmFormFieldValues = ddmFormValues.getDDMFormFieldValues();
        LinkedHashMap<String, List<DDMFormFieldValue>> ddmFormFieldValuesMap = new LinkedHashMap<String, List<DDMFormFieldValue>>();
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
            this.putDDMFormFieldValue(ddmFormFieldValuesMap, ddmFormFieldValue);
        }
        return ddmFormFieldValuesMap;
    }

    public DDMStructure getDDMStructure() {
        return this._ddmStructure;
    }

    public String getDisplayStyle() {
        return "list";
    }

    public String getOrderByCol() {
        String orderByCol = ParamUtil.getString((PortletRequest)this._liferayPortletRequest, (String)"orderByCol", (String)"modified-date");
        return orderByCol;
    }

    public String getOrderByType() {
        String orderByType = ParamUtil.getString((PortletRequest)this._liferayPortletRequest, (String)"orderByType", (String)"asc");
        return orderByType;
    }

    protected void addDDMFormField(List<DDMFormField> ddmFormFields, DDMFormField ddmFormField) {
        if (!this.isDDMFormFieldTransient(ddmFormField)) {
            ddmFormFields.add(ddmFormField);
            return;
        }
        for (DDMFormField nestedDDMFormField : ddmFormField.getNestedDDMFormFields()) {
            this.addDDMFormField(ddmFormFields, nestedDDMFormField);
        }
    }

    protected boolean isDDMFormFieldTransient(DDMFormField ddmFormField) {
        return Validator.isNull((String)ddmFormField.getDataType());
    }

    protected void putDDMFormFieldValue(Map<String, List<DDMFormFieldValue>> ddmFormFieldValuesMap, DDMFormFieldValue ddmFormFieldValue) {
        List<DDMFormFieldValue> ddmFormFieldValues = ddmFormFieldValuesMap.get(ddmFormFieldValue.getName());
        if (ddmFormFieldValues == null) {
            ddmFormFieldValues = new ArrayList<DDMFormFieldValue>();
            ddmFormFieldValuesMap.put(ddmFormFieldValue.getName(), ddmFormFieldValues);
        }
        ddmFormFieldValues.add(ddmFormFieldValue);
        for (DDMFormFieldValue nestedDDMFormFieldValue : ddmFormFieldValue.getNestedDDMFormFieldValues()) {
            this.putDDMFormFieldValue(ddmFormFieldValuesMap, nestedDDMFormFieldValue);
        }
    }
}

