/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.web.internal.display.context;

import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.service.DDLRecordSetLocalService;
import com.liferay.dynamic.data.lists.service.permission.DDLPermission;
import com.liferay.dynamic.data.lists.service.permission.DDLRecordSetPermission;
import com.liferay.dynamic.data.lists.util.DDL;
import com.liferay.dynamic.data.lists.util.comparator.DDLRecordSetCreateDateComparator;
import com.liferay.dynamic.data.lists.util.comparator.DDLRecordSetModifiedDateComparator;
import com.liferay.dynamic.data.lists.util.comparator.DDLRecordSetNameComparator;
import com.liferay.dynamic.data.lists.web.configuration.DDLWebConfiguration;
import com.liferay.dynamic.data.lists.web.internal.display.context.util.DDLRequestHelper;
import com.liferay.dynamic.data.lists.web.internal.search.RecordSetSearch;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.dynamic.data.mapping.service.permission.DDMTemplatePermission;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.StorageEngine;
import com.liferay.dynamic.data.mapping.util.DDMDisplay;
import com.liferay.dynamic.data.mapping.util.DDMDisplayRegistry;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PrefsParamUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.servlet.http.HttpServletRequest;

public class DDLDisplayContext {
    private static final String[] _DISPLAY_VIEWS = new String[]{"descriptive", "list"};
    private final DDL _ddl;
    private String _ddlRecordDisplayStyle;
    private final DDLRecordSetLocalService _ddlRecordSetLocalService;
    private final DDLRequestHelper _ddlRequestHelper;
    private final DDLWebConfiguration _ddlWebConfiguration;
    private final DDMDisplayRegistry _ddmDisplayRegistry;
    private final DDMTemplateLocalService _ddmTemplateLocalService;
    private DDMTemplate _displayDDMTemplate;
    private DDMTemplate _formDDMTemplate;
    private Boolean _hasAddDDMTemplatePermission;
    private Boolean _hasAddRecordPermission;
    private Boolean _hasAddRecordSetPermission;
    private Boolean _hasEditDisplayDDMTemplatePermission;
    private Boolean _hasEditFormDDMTemplatePermission;
    private Boolean _hasShowIconsActionPermission;
    private Boolean _hasViewPermission;
    private DDLRecordSet _recordSet;
    private Boolean _showConfigurationIcon;
    private final StorageEngine _storageEngine;

    public DDLDisplayContext(HttpServletRequest request, DDL ddl, DDLRecordSetLocalService ddlRecordSetLocalService, DDLWebConfiguration ddlWebConfiguration, DDMDisplayRegistry ddmDisplayRegistry, DDMTemplateLocalService ddmTemplateLocalService, StorageEngine storageEngine) {
        this._ddl = ddl;
        this._ddlRecordSetLocalService = ddlRecordSetLocalService;
        this._ddlWebConfiguration = ddlWebConfiguration;
        this._ddmDisplayRegistry = ddmDisplayRegistry;
        this._ddmTemplateLocalService = ddmTemplateLocalService;
        this._storageEngine = storageEngine;
        this._ddlRequestHelper = new DDLRequestHelper(request);
        if (Validator.isNotNull((String)this.getPortletResource())) {
            return;
        }
        DDLRecordSet recordSet = this.getRecordSet();
        if (recordSet == null || !this.hasViewPermission()) {
            RenderRequest renderRequest = this._ddlRequestHelper.getRenderRequest();
            renderRequest.setAttribute("PORTLET_CONFIGURATOR_VISIBILITY", (Object)Boolean.TRUE);
        }
    }

    public boolean changeableDefaultLanguage() {
        return this._ddlWebConfiguration.changeableDefaultLanguage();
    }

    public String getAddDDMTemplateTitle() throws PortalException {
        DDMDisplay ddmDisplay = this.getDDMDisplay();
        return ddmDisplay.getEditTemplateTitle(this._recordSet.getDDMStructure(), null, this.getLocale());
    }

    public String getAddRecordLabel() throws PortalException {
        DDLRecordSet recordSet = this.getRecordSet();
        String structureName = "";
        if (recordSet != null) {
            DDMStructure ddmStructure = recordSet.getDDMStructure();
            structureName = ddmStructure.getName(this._ddlRequestHelper.getLocale());
        }
        return LanguageUtil.format((HttpServletRequest)this._ddlRequestHelper.getRequest(), (String)"add-x", (Object)HtmlUtil.escape((String)structureName), (boolean)false);
    }

    public String getCSVExport() {
        return this._ddlWebConfiguration.csvExport();
    }

    public String getDDLRecordSetDisplayStyle() {
        if (this._ddlRecordDisplayStyle == null) {
            PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((PortletRequest)this._ddlRequestHelper.getRenderRequest());
            this._ddlRecordDisplayStyle = ParamUtil.getString((PortletRequest)this._ddlRequestHelper.getRenderRequest(), (String)"displayStyle");
            if (Validator.isNull((String)this._ddlRecordDisplayStyle)) {
                this._ddlRecordDisplayStyle = portalPreferences.getValue("com_liferay_dynamic_data_lists_web_portlet_DDLPortlet", "display-style", this._ddlWebConfiguration.defaultDisplayView());
            } else if (ArrayUtil.contains((Object[])this.getDDLRecordSetDisplayViews(), (Object)this._ddlRecordDisplayStyle)) {
                portalPreferences.setValue("com_liferay_dynamic_data_lists_web_portlet_DDLPortlet", "display-style", this._ddlRecordDisplayStyle);
            }
            if (!ArrayUtil.contains((Object[])this.getDDLRecordSetDisplayViews(), (Object)this._ddlRecordDisplayStyle)) {
                this._ddlRecordDisplayStyle = this.getDDLRecordSetDisplayViews()[0];
            }
        }
        return this._ddlRecordDisplayStyle;
    }

    public String[] getDDLRecordSetDisplayViews() {
        return _DISPLAY_VIEWS;
    }

    public OrderByComparator<DDLRecordSet> getDDLRecordSetOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        DDLRecordSetCreateDateComparator orderByComparator = null;
        if (orderByCol.equals("create-date")) {
            orderByComparator = new DDLRecordSetCreateDateComparator(orderByAsc);
        } else if (orderByCol.equals("modified-date")) {
            orderByComparator = new DDLRecordSetModifiedDateComparator(orderByAsc);
        } else if (orderByCol.equals("name")) {
            orderByComparator = new DDLRecordSetNameComparator(orderByAsc);
        }
        return orderByComparator;
    }

    public DDMFormValues getDDMFormValues(long classPK) throws PortalException {
        return this._storageEngine.getDDMFormValues(classPK);
    }

    public long getDisplayDDMTemplateId() {
        return PrefsParamUtil.getLong((PortletPreferences)this._ddlRequestHelper.getPortletPreferences(), (PortletRequest)this._ddlRequestHelper.getRenderRequest(), (String)"displayDDMTemplateId");
    }

    public String getEditDisplayDDMTemplateTitle() throws PortalException {
        DDLRecordSet recordSet = this.getRecordSet();
        if (recordSet == null) {
            return "";
        }
        DDMDisplay ddmDisplay = this.getDDMDisplay();
        return ddmDisplay.getEditTemplateTitle(recordSet.getDDMStructure(), this.fetchDisplayDDMTemplate(), this.getLocale());
    }

    public String getEditFormDDMTemplateTitle() throws PortalException {
        DDLRecordSet recordSet = this.getRecordSet();
        if (recordSet == null) {
            return LanguageUtil.get((Locale)this.getLocale(), (String)"add-list");
        }
        DDMDisplay ddmDisplay = this.getDDMDisplay();
        return ddmDisplay.getEditTemplateTitle(recordSet.getDDMStructure(), this.fetchFormDDMTemplate(), this.getLocale());
    }

    public long getFormDDMTemplateId() {
        return PrefsParamUtil.getLong((PortletPreferences)this._ddlRequestHelper.getPortletPreferences(), (PortletRequest)this._ddlRequestHelper.getRenderRequest(), (String)"formDDMTemplateId");
    }

    public String getOrderByCol() {
        String orderByCol = ParamUtil.getString((PortletRequest)this._ddlRequestHelper.getRenderRequest(), (String)"orderByCol", (String)"modified-date");
        return orderByCol;
    }

    public String getOrderByType() {
        String orderByType = ParamUtil.getString((PortletRequest)this._ddlRequestHelper.getRenderRequest(), (String)"orderByType", (String)"asc");
        return orderByType;
    }

    public DDLRecordSet getRecordSet() {
        if (this._recordSet != null) {
            return this._recordSet;
        }
        RenderRequest renderRequest = this._ddlRequestHelper.getRenderRequest();
        this._recordSet = (DDLRecordSet)renderRequest.getAttribute("DYNAMIC_DATA_LISTS_RECORD_SET");
        if (this._recordSet != null) {
            return this._recordSet;
        }
        this._recordSet = this._ddlRecordSetLocalService.fetchDDLRecordSet(this.getRecordSetId());
        return this._recordSet;
    }

    public long getRecordSetId() {
        return PrefsParamUtil.getLong((PortletPreferences)this._ddlRequestHelper.getPortletPreferences(), (PortletRequest)this._ddlRequestHelper.getRenderRequest(), (String)"recordSetId");
    }

    public JSONArray getRecordSetJSONArray(DDLRecordSet recordSet, Locale locale) throws Exception {
        return this._ddl.getRecordSetJSONArray(recordSet, locale);
    }

    public RecordSetSearch getRecordSetSearch(PortletURL portletURL) {
        RecordSetSearch recordSetSearch = new RecordSetSearch((PortletRequest)this._ddlRequestHelper.getRenderRequest(), portletURL);
        String orderByCol = this.getOrderByCol();
        String orderByType = this.getOrderByType();
        OrderByComparator<DDLRecordSet> orderByComparator = this.getDDLRecordSetOrderByComparator(orderByCol, orderByType);
        recordSetSearch.setOrderByCol(orderByCol);
        recordSetSearch.setOrderByComparator(orderByComparator);
        recordSetSearch.setOrderByType(orderByType);
        return recordSetSearch;
    }

    public JSONArray getRecordsJSONArray(List<DDLRecord> records, boolean latestRecordVersion, Locale locale) throws Exception {
        return this._ddl.getRecordsJSONArray(records, latestRecordVersion, locale);
    }

    public boolean isAdminPortlet() {
        String portletName = this.getPortletName();
        return portletName.equals("com_liferay_dynamic_data_lists_web_portlet_DDLPortlet");
    }

    public boolean isDisplayPortlet() {
        return !this.isAdminPortlet();
    }

    public boolean isEditable() {
        if (this.isAdminPortlet()) {
            return true;
        }
        return PrefsParamUtil.getBoolean((PortletPreferences)this._ddlRequestHelper.getPortletPreferences(), (PortletRequest)this._ddlRequestHelper.getRenderRequest(), (String)"editable", (boolean)true);
    }

    public boolean isFormView() {
        return PrefsParamUtil.getBoolean((PortletPreferences)this._ddlRequestHelper.getPortletPreferences(), (PortletRequest)this._ddlRequestHelper.getRenderRequest(), (String)"formView");
    }

    public boolean isShowAddDDMDisplayTemplateIcon() throws PortalException {
        return this.isShowAddDDMTemplateIcon() && !this.isFormView();
    }

    public boolean isShowAddDDMFormTemplateIcon() throws PortalException {
        return this.isShowAddDDMTemplateIcon();
    }

    public boolean isShowAddRecordButton() {
        if (this.isFormView() || this.isSpreadsheet()) {
            return false;
        }
        return this.isEditable() && this.hasAddRecordPermission();
    }

    public boolean isShowAddRecordSetIcon() {
        if (this._hasAddRecordSetPermission != null) {
            return this._hasAddRecordSetPermission;
        }
        this._hasAddRecordSetPermission = DDLPermission.contains((PermissionChecker)this.getPermissionChecker(), (long)this.getScopeGroupId(), (String)this.getPortletId(), (String)"ADD_RECORD_SET");
        return this._hasAddRecordSetPermission;
    }

    public boolean isShowCancelButton() {
        return !this.isFormView();
    }

    public boolean isShowConfigurationIcon() throws PortalException {
        if (this._showConfigurationIcon != null) {
            return this._showConfigurationIcon;
        }
        this._showConfigurationIcon = PortletPermissionUtil.contains((PermissionChecker)this.getPermissionChecker(), (Layout)this.getLayout(), (String)this.getPortletId(), (String)"CONFIGURATION");
        return this._showConfigurationIcon;
    }

    public boolean isShowEditDisplayDDMTemplateIcon() throws PortalException {
        if (this._hasEditDisplayDDMTemplatePermission != null) {
            return this._hasEditDisplayDDMTemplatePermission;
        }
        this._hasEditDisplayDDMTemplatePermission = Boolean.FALSE;
        DDMTemplate displayDDMTemplate = this.fetchDisplayDDMTemplate();
        if (displayDDMTemplate == null) {
            return this._hasEditDisplayDDMTemplatePermission;
        }
        this._hasEditDisplayDDMTemplatePermission = DDMTemplatePermission.contains((PermissionChecker)this.getPermissionChecker(), (long)this.getScopeGroupId(), (long)this.getDisplayDDMTemplateId(), (String)"com_liferay_dynamic_data_lists_web_portlet_DDLPortlet", (String)"UPDATE");
        return this._hasEditDisplayDDMTemplatePermission;
    }

    public boolean isShowEditFormDDMTemplateIcon() throws PortalException {
        if (this._hasEditFormDDMTemplatePermission != null) {
            return this._hasEditFormDDMTemplatePermission;
        }
        this._hasEditFormDDMTemplatePermission = Boolean.FALSE;
        if (this.getFormDDMTemplateId() == 0L) {
            return this._hasEditFormDDMTemplatePermission;
        }
        this._hasEditFormDDMTemplatePermission = DDMTemplatePermission.contains((PermissionChecker)this.getPermissionChecker(), (long)this.getScopeGroupId(), (long)this.getFormDDMTemplateId(), (String)"com_liferay_dynamic_data_lists_web_portlet_DDLPortlet", (String)"UPDATE");
        return this._hasEditFormDDMTemplatePermission;
    }

    public boolean isShowEditRecordSetIcon() {
        DDLRecordSet recordSet = this.getRecordSet();
        if (recordSet == null) {
            return false;
        }
        return DDLRecordSetPermission.contains((PermissionChecker)this.getPermissionChecker(), (DDLRecordSet)recordSet, (String)"UPDATE");
    }

    public boolean isShowIconsActions() throws PortalException {
        if (this.isSpreadsheet()) {
            return false;
        }
        if (this._hasShowIconsActionPermission != null) {
            return this._hasShowIconsActionPermission;
        }
        this._hasShowIconsActionPermission = Boolean.FALSE;
        ThemeDisplay themeDisplay = this.getThemeDisplay();
        if (!themeDisplay.isSignedIn()) {
            return this._hasShowIconsActionPermission;
        }
        Layout layout = themeDisplay.getLayout();
        if (layout.isLayoutPrototypeLinkActive()) {
            return this._hasShowIconsActionPermission;
        }
        if (this.isShowConfigurationIcon() || this.isShowAddDDMDisplayTemplateIcon() || this.isShowAddDDMFormTemplateIcon() || this.isShowEditDisplayDDMTemplateIcon() || this.isShowEditFormDDMTemplateIcon()) {
            this._hasShowIconsActionPermission = Boolean.TRUE;
        }
        return this._hasShowIconsActionPermission;
    }

    public boolean isShowPublishRecordButton() {
        return this.isEditable() && this.hasAddRecordPermission();
    }

    public boolean isShowSaveRecordButton() {
        if (this.isFormView()) {
            return false;
        }
        return this.isEditable() && this.hasAddRecordPermission();
    }

    public boolean isSpreadsheet() {
        return PrefsParamUtil.getBoolean((PortletPreferences)this._ddlRequestHelper.getPortletPreferences(), (PortletRequest)this._ddlRequestHelper.getRenderRequest(), (String)"spreadsheet");
    }

    protected DDMTemplate fetchDisplayDDMTemplate() {
        if (this._displayDDMTemplate != null) {
            return this._displayDDMTemplate;
        }
        this._displayDDMTemplate = this._ddmTemplateLocalService.fetchDDMTemplate(this.getDisplayDDMTemplateId());
        return this._displayDDMTemplate;
    }

    protected DDMTemplate fetchFormDDMTemplate() {
        if (this._formDDMTemplate != null) {
            return this._formDDMTemplate;
        }
        this._formDDMTemplate = this._ddmTemplateLocalService.fetchDDMTemplate(this.getFormDDMTemplateId());
        return this._formDDMTemplate;
    }

    protected DDMDisplay getDDMDisplay() {
        return this._ddmDisplayRegistry.getDDMDisplay("com_liferay_dynamic_data_lists_web_portlet_DDLPortlet");
    }

    protected Layout getLayout() {
        return this._ddlRequestHelper.getLayout();
    }

    protected Locale getLocale() {
        return this._ddlRequestHelper.getLocale();
    }

    protected PermissionChecker getPermissionChecker() {
        return this._ddlRequestHelper.getPermissionChecker();
    }

    protected String getPortletId() {
        return this._ddlRequestHelper.getPortletId();
    }

    protected String getPortletName() {
        return this._ddlRequestHelper.getPortletName();
    }

    protected String getPortletResource() {
        return this._ddlRequestHelper.getPortletResource();
    }

    protected long getScopeGroupId() {
        return this._ddlRequestHelper.getScopeGroupId();
    }

    protected long getStructureTypeClassNameId() {
        DDMDisplay ddmDisplay = this.getDDMDisplay();
        return PortalUtil.getClassNameId((String)ddmDisplay.getStructureType());
    }

    protected ThemeDisplay getThemeDisplay() {
        return this._ddlRequestHelper.getThemeDisplay();
    }

    protected boolean hasAddRecordPermission() {
        if (this._hasAddRecordPermission != null) {
            return this._hasAddRecordPermission;
        }
        this._hasAddRecordPermission = false;
        if (this._recordSet != null) {
            this._hasAddRecordPermission = DDLRecordSetPermission.contains((PermissionChecker)this.getPermissionChecker(), (DDLRecordSet)this._recordSet, (String)"ADD_RECORD");
        }
        return this._hasAddRecordPermission;
    }

    protected boolean hasViewPermission() {
        if (this._hasViewPermission != null) {
            return this._hasViewPermission;
        }
        this._hasViewPermission = true;
        if (this._recordSet != null) {
            this._hasViewPermission = DDLRecordSetPermission.contains((PermissionChecker)this.getPermissionChecker(), (DDLRecordSet)this._recordSet, (String)"VIEW");
        }
        return this._hasViewPermission;
    }

    protected boolean isShowAddDDMTemplateIcon() throws PortalException {
        if (this._hasAddDDMTemplatePermission != null) {
            return this._hasAddDDMTemplatePermission;
        }
        this._hasAddDDMTemplatePermission = Boolean.FALSE;
        DDLRecordSet recordSet = this.getRecordSet();
        if (recordSet == null) {
            return this._hasAddDDMTemplatePermission;
        }
        this._hasAddDDMTemplatePermission = DDMTemplatePermission.containsAddTemplatePermission((PermissionChecker)this.getPermissionChecker(), (long)this.getScopeGroupId(), (long)this.getStructureTypeClassNameId(), (long)this.getStructureTypeClassNameId());
        return this._hasAddDDMTemplatePermission;
    }
}

