/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.web.internal.asset;

import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.BaseJSPAssetRenderer;
import com.liferay.asset.kernel.model.DDMFormValuesReader;
import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.model.DDLRecordVersion;
import com.liferay.dynamic.data.lists.service.permission.DDLRecordSetPermission;
import com.liferay.dynamic.data.lists.web.internal.asset.DDLRecordAssetRendererFactory;
import com.liferay.dynamic.data.lists.web.internal.asset.DDLRecordDDMFormValuesReader;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DDLRecordAssetRenderer
extends BaseJSPAssetRenderer<DDLRecord> {
    private static final Log _log = LogFactoryUtil.getLog(DDLRecordAssetRenderer.class);
    private final DDMStructure _ddmStructure;
    private final DDLRecord _record;
    private final DDLRecordSet _recordSet;
    private final DDLRecordVersion _recordVersion;

    public DDLRecordAssetRenderer(DDLRecord record, DDLRecordVersion recordVersion) {
        DDLRecordSet recordSet;
        DDMStructure ddmStructure;
        block2: {
            this._record = record;
            this._recordVersion = recordVersion;
            ddmStructure = null;
            recordSet = null;
            try {
                recordSet = record.getRecordSet();
                ddmStructure = recordSet.getDDMStructure();
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)e, (Throwable)e);
            }
        }
        this._ddmStructure = ddmStructure;
        this._recordSet = recordSet;
    }

    public DDLRecord getAssetObject() {
        return this._record;
    }

    public AssetRendererFactory<DDLRecord> getAssetRendererFactory() {
        return new DDLRecordAssetRendererFactory();
    }

    public String getClassName() {
        return DDLRecord.class.getName();
    }

    public long getClassPK() {
        return this._record.getRecordId();
    }

    public DDMFormValuesReader getDDMFormValuesReader() {
        return new DDLRecordDDMFormValuesReader(this._record);
    }

    public long getGroupId() {
        return this._record.getGroupId();
    }

    public String getJspPath(HttpServletRequest request, String template) {
        if (template.equals("abstract") || template.equals("full_content")) {
            return "/asset/full_content.jsp";
        }
        return null;
    }

    public int getStatus() {
        return this._recordVersion.getStatus();
    }

    public String getSummary(PortletRequest portletRequest, PortletResponse portletResponse) {
        return "";
    }

    public String getTitle(Locale locale) {
        String ddmStructureName = this._ddmStructure.getName(locale);
        String recordSetName = this._recordSet.getName(locale);
        return LanguageUtil.format((Locale)locale, (String)"new-x-for-list-x", (Object[])new Object[]{ddmStructureName, recordSetName}, (boolean)false);
    }

    public PortletURL getURLEdit(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws Exception {
        Group group = GroupLocalServiceUtil.fetchGroup((long)this._record.getGroupId());
        if (group.isCompany()) {
            ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            group = themeDisplay.getScopeGroup();
        }
        PortletURL portletURL = PortalUtil.getControlPanelPortletURL((PortletRequest)liferayPortletRequest, (Group)group, (String)"com_liferay_dynamic_data_lists_web_portlet_DDLPortlet", (long)0L, (long)0L, (String)"RENDER_PHASE");
        portletURL.setParameter("mvcPath", "/edit_record.jsp");
        portletURL.setParameter("recordId", String.valueOf(this._record.getRecordId()));
        portletURL.setParameter("version", this._recordVersion.getVersion());
        return portletURL;
    }

    public String getURLViewInContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, String noSuchEntryRedirect) throws Exception {
        return noSuchEntryRedirect;
    }

    public long getUserId() {
        return this._recordVersion.getUserId();
    }

    public String getUserName() {
        return this._recordVersion.getUserName();
    }

    public String getUuid() {
        return this._record.getUuid();
    }

    public boolean hasEditPermission(PermissionChecker permissionChecker) {
        return DDLRecordSetPermission.contains((PermissionChecker)permissionChecker, (DDLRecordSet)this._recordSet, (String)"UPDATE");
    }

    public boolean hasViewPermission(PermissionChecker permissionChecker) {
        return DDLRecordSetPermission.contains((PermissionChecker)permissionChecker, (DDLRecordSet)this._recordSet, (String)"VIEW");
    }

    public boolean include(HttpServletRequest request, HttpServletResponse response, String template) throws Exception {
        request.setAttribute("DYNAMIC_DATA_LISTS_RECORD", (Object)this._record);
        request.setAttribute("DYNAMIC_DATA_LISTS_RECORD_VERSION", (Object)this._recordVersion);
        return super.include(request, response, template);
    }
}

