/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.dynamic.data.lists.model.DDLRecordVersion;
import com.liferay.dynamic.data.lists.service.DDLRecordVersionLocalService;
import com.liferay.dynamic.data.lists.uad.constants.DDLUADConstants;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseDDLRecordVersionUADAnonymizer
extends DynamicQueryUADAnonymizer<DDLRecordVersion> {
    @Reference
    protected AssetEntryLocalService assetEntryLocalService;
    @Reference
    protected DDLRecordVersionLocalService ddlRecordVersionLocalService;

    public void autoAnonymize(DDLRecordVersion ddlRecordVersion, long userId, User anonymousUser) throws PortalException {
        if (ddlRecordVersion.getUserId() == userId) {
            ddlRecordVersion.setUserId(anonymousUser.getUserId());
            ddlRecordVersion.setUserName(anonymousUser.getFullName());
            this.autoAnonymizeAssetEntry(ddlRecordVersion, anonymousUser);
        }
        if (ddlRecordVersion.getStatusByUserId() == userId) {
            ddlRecordVersion.setStatusByUserId(anonymousUser.getUserId());
            ddlRecordVersion.setStatusByUserName(anonymousUser.getFullName());
        }
        this.ddlRecordVersionLocalService.updateDDLRecordVersion(ddlRecordVersion);
    }

    public void delete(DDLRecordVersion ddlRecordVersion) throws PortalException {
        this.ddlRecordVersionLocalService.deleteDDLRecordVersion(ddlRecordVersion);
    }

    public Class<DDLRecordVersion> getTypeClass() {
        return DDLRecordVersion.class;
    }

    protected void autoAnonymizeAssetEntry(DDLRecordVersion ddlRecordVersion, User anonymousUser) {
        AssetEntry assetEntry = this.fetchAssetEntry(ddlRecordVersion);
        if (assetEntry != null) {
            assetEntry.setUserId(anonymousUser.getUserId());
            assetEntry.setUserName(anonymousUser.getFullName());
            this.assetEntryLocalService.updateAssetEntry(assetEntry);
        }
    }

    protected ActionableDynamicQuery doGetActionableDynamicQuery() {
        return this.ddlRecordVersionLocalService.getActionableDynamicQuery();
    }

    protected String[] doGetUserIdFieldNames() {
        return DDLUADConstants.USER_ID_FIELD_NAMES_DDL_RECORD_VERSION;
    }

    protected AssetEntry fetchAssetEntry(DDLRecordVersion ddlRecordVersion) {
        return this.assetEntryLocalService.fetchEntry(DDLRecordVersion.class.getName(), ddlRecordVersion.getRecordVersionId());
    }
}

