/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.service.DDLRecordLocalService;
import com.liferay.dynamic.data.lists.uad.constants.DDLUADConstants;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseDDLRecordUADAnonymizer
extends DynamicQueryUADAnonymizer<DDLRecord> {
    @Reference
    protected AssetEntryLocalService assetEntryLocalService;
    @Reference
    protected DDLRecordLocalService ddlRecordLocalService;

    public void autoAnonymize(DDLRecord ddlRecord, long userId, User anonymousUser) throws PortalException {
        if (ddlRecord.getUserId() == userId) {
            ddlRecord.setUserId(anonymousUser.getUserId());
            ddlRecord.setUserName(anonymousUser.getFullName());
            this.autoAnonymizeAssetEntry(ddlRecord, anonymousUser);
        }
        if (ddlRecord.getVersionUserId() == userId) {
            ddlRecord.setVersionUserId(anonymousUser.getUserId());
            ddlRecord.setVersionUserName(anonymousUser.getFullName());
        }
        this.ddlRecordLocalService.updateDDLRecord(ddlRecord);
    }

    public void delete(DDLRecord ddlRecord) throws PortalException {
        this.ddlRecordLocalService.deleteRecord(ddlRecord);
    }

    public Class<DDLRecord> getTypeClass() {
        return DDLRecord.class;
    }

    protected void autoAnonymizeAssetEntry(DDLRecord ddlRecord, User anonymousUser) {
        AssetEntry assetEntry = this.fetchAssetEntry(ddlRecord);
        if (assetEntry != null) {
            assetEntry.setUserId(anonymousUser.getUserId());
            assetEntry.setUserName(anonymousUser.getFullName());
            this.assetEntryLocalService.updateAssetEntry(assetEntry);
        }
    }

    protected ActionableDynamicQuery doGetActionableDynamicQuery() {
        return this.ddlRecordLocalService.getActionableDynamicQuery();
    }

    protected String[] doGetUserIdFieldNames() {
        return DDLUADConstants.USER_ID_FIELD_NAMES_DDL_RECORD;
    }

    protected AssetEntry fetchAssetEntry(DDLRecord ddlRecord) {
        return this.assetEntryLocalService.fetchEntry(DDLRecord.class.getName(), ddlRecord.getRecordId());
    }
}

