/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.service.impl;

import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.model.DDLRecordSetVersion;
import com.liferay.dynamic.data.lists.service.base.DDLRecordSetVersionServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=ddl", "json.web.service.context.path=DDLRecordSetVersion"}, service={AopService.class})
public class DDLRecordSetVersionServiceImpl
extends DDLRecordSetVersionServiceBaseImpl {
    @Reference(target="(model.class.name=com.liferay.dynamic.data.lists.model.DDLRecordSet)")
    private ModelResourcePermission<DDLRecordSet> _ddlRecordSetModelResourcePermission;

    public DDLRecordSetVersion getLatestRecordSetVersion(long recordSetId) throws PortalException {
        this._ddlRecordSetModelResourcePermission.check(this.getPermissionChecker(), recordSetId, "VIEW");
        return this.ddlRecordSetVersionLocalService.getLatestRecordSetVersion(recordSetId);
    }

    public DDLRecordSetVersion getRecordSetVersion(long recordSetVersionId) throws PortalException {
        DDLRecordSetVersion recordSetVersion = this.ddlRecordSetVersionLocalService.getRecordSetVersion(recordSetVersionId);
        this._ddlRecordSetModelResourcePermission.check(this.getPermissionChecker(), recordSetVersion.getRecordSetId(), "VIEW");
        return recordSetVersion;
    }

    public List<DDLRecordSetVersion> getRecordSetVersions(long recordSetId, int start, int end, OrderByComparator<DDLRecordSetVersion> orderByComparator) throws PortalException {
        this._ddlRecordSetModelResourcePermission.check(this.getPermissionChecker(), recordSetId, "VIEW");
        return this.ddlRecordSetVersionLocalService.getRecordSetVersions(recordSetId, start, end, orderByComparator);
    }

    public int getRecordSetVersionsCount(long recordSetId) throws PortalException {
        this._ddlRecordSetModelResourcePermission.check(this.getPermissionChecker(), recordSetId, "VIEW");
        return this.ddlRecordSetVersionLocalService.getRecordSetVersionsCount(recordSetId);
    }
}

