/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.internal.search;

import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.service.DDLRecordSetLocalService;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.Collection;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={Indexer.class})
public class DDLRecordSetIndexer
extends BaseIndexer<DDLRecordSet> {
    public static final String CLASS_NAME = DDLRecordSet.class.getName();
    @Reference
    protected DDLRecordSetLocalService ddlRecordSetLocalService;
    @Reference
    protected IndexerRegistry indexerRegistry;
    @Reference
    protected IndexWriterHelper indexWriterHelper;
    private static final Log _log = LogFactoryUtil.getLog(DDLRecordSetIndexer.class);

    public DDLRecordSetIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"companyId", "entryClassName", "entryClassPK", "uid"});
        this.setPermissionAware(true);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    protected void doDelete(DDLRecordSet recordSet) throws Exception {
        this.deleteDocument(recordSet.getCompanyId(), recordSet.getRecordSetId());
    }

    protected Document doGetDocument(DDLRecordSet ddlRecordSet) throws Exception {
        return this.getBaseModelDocument(CLASS_NAME, (BaseModel)ddlRecordSet);
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) throws Exception {
        return this.createSummary(document, "title", "description");
    }

    protected void doReindex(DDLRecordSet recordSet) throws Exception {
        Document document = this.getDocument(recordSet);
        this.indexWriterHelper.updateDocument(this.getSearchEngineId(), recordSet.getCompanyId(), document, this.isCommitImmediately());
        this.reindexRecords(recordSet);
    }

    protected void doReindex(String className, long classPK) throws Exception {
        DDLRecordSet recordSet = this.ddlRecordSetLocalService.getRecordSet(classPK);
        this.doReindex(recordSet);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexRecordSets(companyId);
    }

    protected void reindexRecords(DDLRecordSet recordSet) throws Exception {
        Indexer indexer = this.indexerRegistry.nullSafeGetIndexer(DDLRecord.class);
        indexer.reindex((Collection)recordSet.getRecords());
    }

    protected void reindexRecordSets(long companyId) throws Exception {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this.ddlRecordSetLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(recordSet -> {
            block3: {
                try {
                    Document document = this.getDocument(recordSet);
                    if (document != null) {
                        indexableActionableDynamicQuery.addDocuments(new Document[]{document});
                    }
                }
                catch (PortalException pe) {
                    if (!_log.isWarnEnabled()) break block3;
                    _log.warn((Object)("Unable to index dynamic data lists record " + recordSet.getRecordSetId()), (Throwable)pe);
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }
}

