/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.service.impl;

import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.model.DDLRecordVersion;
import com.liferay.dynamic.data.lists.service.base.DDLRecordVersionServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;

public class DDLRecordVersionServiceImpl
extends DDLRecordVersionServiceBaseImpl {
    private static volatile ModelResourcePermission<DDLRecordSet> _ddlRecordSetModelResourcePermission = ModelResourcePermissionFactory.getInstance(DDLRecordVersionServiceImpl.class, (String)"_ddlRecordSetModelResourcePermission", DDLRecordSet.class);

    public DDLRecordVersion getRecordVersion(long recordVersionId) throws PortalException {
        DDLRecordVersion recordVersion = this.ddlRecordVersionLocalService.getRecordVersion(recordVersionId);
        _ddlRecordSetModelResourcePermission.check(this.getPermissionChecker(), recordVersion.getRecordSetId(), "VIEW");
        return recordVersion;
    }

    public DDLRecordVersion getRecordVersion(long recordId, String version) throws PortalException {
        DDLRecordVersion recordVersion = this.ddlRecordVersionPersistence.findByR_V(recordId, version);
        _ddlRecordSetModelResourcePermission.check(this.getPermissionChecker(), recordVersion.getRecordSetId(), "VIEW");
        return recordVersion;
    }

    public List<DDLRecordVersion> getRecordVersions(long recordId) throws PortalException {
        DDLRecord record = this.ddlRecordPersistence.findByPrimaryKey(recordId);
        _ddlRecordSetModelResourcePermission.check(this.getPermissionChecker(), record.getRecordSetId(), "VIEW");
        return this.ddlRecordVersionPersistence.findByRecordId(recordId);
    }

    public List<DDLRecordVersion> getRecordVersions(long recordId, int start, int end, OrderByComparator<DDLRecordVersion> orderByComparator) throws PortalException {
        DDLRecord record = this.ddlRecordPersistence.findByPrimaryKey(recordId);
        _ddlRecordSetModelResourcePermission.check(this.getPermissionChecker(), record.getRecordSetId(), "VIEW");
        return this.ddlRecordVersionPersistence.findByRecordId(recordId, start, end, orderByComparator);
    }

    public int getRecordVersionsCount(long recordId) throws PortalException {
        DDLRecord record = this.ddlRecordPersistence.findByPrimaryKey(recordId);
        _ddlRecordSetModelResourcePermission.check(this.getPermissionChecker(), record.getRecordSetId(), "VIEW");
        return this.ddlRecordVersionPersistence.countByRecordId(recordId);
    }
}

