/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.form.web.internal.portlet.action;

import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.service.DDLRecordSetService;
import com.liferay.dynamic.data.mapping.form.values.query.DDMFormValuesQuery;
import com.liferay.dynamic.data.mapping.form.values.query.DDMFormValuesQueryFactory;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCResourceCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCResourceCommand;
import com.liferay.portal.kernel.util.ParamUtil;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_dynamic_data_lists_form_web_portlet_DDLFormAdminPortlet", "mvc.command.name=publishRecordSet"}, service={MVCResourceCommand.class})
public class PublishRecordSetMVCResourceCommand
extends BaseMVCResourceCommand {
    private DDLRecordSetService _ddlRecordSetService;
    private DDMFormValuesQueryFactory _ddmFormValuesQueryFactory;

    protected void doServeResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        long recordSetId = ParamUtil.getLong((PortletRequest)resourceRequest, (String)"recordSetId");
        boolean published = ParamUtil.getBoolean((PortletRequest)resourceRequest, (String)"published");
        DDLRecordSet recordSet = this._ddlRecordSetService.getRecordSet(recordSetId);
        DDMFormValues settingsDDMFormValues = recordSet.getSettingsDDMFormValues();
        this.updatePublishedDDMFormFieldValue(settingsDDMFormValues, published);
        this._ddlRecordSetService.updateRecordSet(recordSetId, settingsDDMFormValues);
    }

    protected DDMForm getDDMForm(DDLRecordSet recordSet) throws PortalException {
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        return ddmStructure.getDDMForm();
    }

    @Reference(unbind="-")
    protected void setDDLRecordSetService(DDLRecordSetService ddlRecordSetService) {
        this._ddlRecordSetService = ddlRecordSetService;
    }

    @Reference(unbind="-")
    protected void setDDMFormValuesQueryFactory(DDMFormValuesQueryFactory ddmFormValuesQueryFactory) {
        this._ddmFormValuesQueryFactory = ddmFormValuesQueryFactory;
    }

    protected void updatePublishedDDMFormFieldValue(DDMFormValues ddmFormValues, boolean published) throws PortalException {
        DDMFormValuesQuery ddmFormValuesQuery = this._ddmFormValuesQueryFactory.create(ddmFormValues, "/published");
        DDMFormFieldValue ddmFormFieldValue = ddmFormValuesQuery.selectSingleDDMFormFieldValue();
        Value value = ddmFormFieldValue.getValue();
        value.addString(ddmFormValues.getDefaultLocale(), Boolean.toString(published));
    }
}

