/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.form.web.internal.portlet.action;

import com.liferay.dynamic.data.lists.exporter.DDLExporter;
import com.liferay.dynamic.data.lists.exporter.DDLExporterFactory;
import com.liferay.dynamic.data.lists.form.web.configuration.DDLFormWebConfiguration;
import com.liferay.dynamic.data.lists.form.web.configuration.DDLFormWebConfigurationActivator;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.service.DDLRecordSetService;
import com.liferay.portal.kernel.portlet.PortletResponseUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCResourceCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCResourceCommand;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import javax.portlet.MimeResponse;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_dynamic_data_lists_form_web_portlet_DDLFormAdminPortlet", "mvc.command.name=exportRecordSet"}, service={MVCResourceCommand.class})
public class ExportRecordSetMVCResourceCommand
extends BaseMVCResourceCommand {
    private DDLExporterFactory _ddlExporterFactory;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, unbind="unsetDDLFormWebConfigurationActivator")
    private volatile DDLFormWebConfigurationActivator _ddlFormWebConfigurationActivator;
    private DDLRecordSetService _ddlRecordSetService;

    protected void doServeResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)resourceRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long recordSetId = ParamUtil.getLong((PortletRequest)resourceRequest, (String)"recordSetId");
        DDLRecordSet recordSet = this._ddlRecordSetService.getRecordSet(recordSetId);
        String fileExtension = ParamUtil.getString((PortletRequest)resourceRequest, (String)"fileExtension");
        DDLFormWebConfiguration ddlFormWebConfiguration = this._ddlFormWebConfigurationActivator.getDDLFormWebConfiguration();
        if (StringUtil.equals((String)fileExtension, (String)"csv") && StringUtil.equals((String)ddlFormWebConfiguration.csvExport(), (String)"disabled")) {
            return;
        }
        String fileName = recordSet.getName(themeDisplay.getLocale()) + '.' + fileExtension;
        DDLExporter exporter = this._ddlExporterFactory.getDDLExporter(fileExtension);
        exporter.setLocale(themeDisplay.getLocale());
        byte[] bytes = exporter.export(recordSetId, 0);
        String contentType = MimeTypesUtil.getContentType((String)fileName);
        PortletResponseUtil.sendFile((PortletRequest)resourceRequest, (MimeResponse)resourceResponse, (String)fileName, (byte[])bytes, (String)contentType);
    }

    @Reference(unbind="-")
    protected void setDDLExporterFactory(DDLExporterFactory ddlExporterFactory) {
        this._ddlExporterFactory = ddlExporterFactory;
    }

    @Reference(unbind="-")
    protected void setDDLRecordSetService(DDLRecordSetService ddlRecordSetService) {
        this._ddlRecordSetService = ddlRecordSetService;
    }

    protected void unsetDDLFormWebConfigurationActivator(DDLFormWebConfigurationActivator ddlFormWebConfigurationActivator) {
        this._ddlFormWebConfigurationActivator = null;
    }
}

