/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.form.web.internal.portlet.action;

import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.service.DDLRecordSetService;
import com.liferay.dynamic.data.mapping.service.DDMStructureService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseTransactionalMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_dynamic_data_lists_form_web_portlet_DDLFormAdminPortlet", "mvc.command.name=deleteRecordSet"}, service={MVCActionCommand.class})
public class DeleteRecordSetMVCActionCommand
extends BaseTransactionalMVCActionCommand {
    private DDLRecordSetService _ddlRecordSetService;
    private DDMStructureService _ddmStructureService;

    protected void doDeleteRecordSet(long recordSetId) throws PortalException {
        DDLRecordSet recordSet = this._ddlRecordSetService.getRecordSet(recordSetId);
        this._ddlRecordSetService.deleteRecordSet(recordSetId);
        this._ddmStructureService.deleteStructure(recordSet.getDDMStructureId());
    }

    protected void doTransactionalCommand(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long[] deleteRecordSetIds = null;
        long recordSetId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"recordSetId");
        deleteRecordSetIds = recordSetId > 0L ? new long[]{recordSetId} : StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"deleteRecordSetIds"), (long)0L);
        for (long deleteRecordSetId : deleteRecordSetIds) {
            this.doDeleteRecordSet(deleteRecordSetId);
        }
    }

    @Reference(unbind="-")
    protected void setDDLRecordSetService(DDLRecordSetService ddlRecordSetService) {
        this._ddlRecordSetService = ddlRecordSetService;
    }

    @Reference(unbind="-")
    protected void setDDMStructureService(DDMStructureService ddmStructureService) {
        this._ddmStructureService = ddmStructureService;
    }
}

