/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.form.web.internal.portlet.action;

import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormEvaluationResult;
import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormEvaluator;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.portal.kernel.util.Portal;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={AddRecordMVCCommandHelper.class})
public class AddRecordMVCCommandHelper {
    @Reference
    private DDMFormEvaluator _ddmFormEvaluator;
    @Reference
    private Portal _portal;

    public void updateRequiredFieldsAccordingToVisibility(DDMForm ddmForm, DDMFormValues ddmFormValues, Locale locale) throws Exception {
        List<DDMFormField> requiredFields = this.getRequiredFields(ddmForm);
        if (requiredFields.isEmpty()) {
            return;
        }
        DDMFormEvaluationResult ddmFormEvaluationResult = this.evaluate(ddmForm, ddmFormValues, locale);
        Set<String> invisibleFields = this.getInvisibleFields(ddmFormEvaluationResult);
        if (invisibleFields.isEmpty()) {
            return;
        }
        this.removeRequiredProperty(invisibleFields, requiredFields);
    }

    protected DDMFormEvaluationResult evaluate(DDMForm ddmForm, DDMFormValues ddmFormValues, Locale locale) throws Exception {
        return this._ddmFormEvaluator.evaluate(ddmForm, ddmFormValues, locale);
    }

    protected Set<String> getInvisibleFields(DDMFormEvaluationResult ddmFormEvaluationResult) {
        List ddmFormFieldEvaluationResults = ddmFormEvaluationResult.getDDMFormFieldEvaluationResults();
        Stream<Object> stream = ddmFormFieldEvaluationResults.stream();
        stream = stream.filter(result -> !result.isVisible());
        Stream<String> fieldNameStream = stream.map(result -> result.getName());
        return fieldNameStream.collect(Collectors.toSet());
    }

    protected List<DDMFormField> getRequiredFields(DDMForm ddmForm) {
        Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        Collection ddmFormFields = ddmFormFieldsMap.values();
        Stream<Object> stream = ddmFormFields.stream();
        stream = stream.filter(ddmFormField -> ddmFormField.isRequired());
        return stream.collect(Collectors.toList());
    }

    protected void removeRequiredProperty(DDMFormField ddmFormField) {
        ddmFormField.setRequired(false);
    }

    protected void removeRequiredProperty(Set<String> invisibleFields, List<DDMFormField> requiredFields) {
        Stream<Object> stream = requiredFields.stream();
        stream = stream.filter(field -> invisibleFields.contains(field.getName()));
        stream.forEach(this::removeRequiredProperty);
    }
}

