/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.form.web.internal.portlet.action;

import com.liferay.captcha.util.CaptchaUtil;
import com.liferay.dynamic.data.lists.form.web.internal.notification.DDLFormEmailNotificationSender;
import com.liferay.dynamic.data.lists.form.web.internal.portlet.action.AddRecordMVCCommandHelper;
import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.model.DDLRecordSetSettings;
import com.liferay.dynamic.data.lists.service.DDLRecordService;
import com.liferay.dynamic.data.lists.service.DDLRecordSetService;
import com.liferay.dynamic.data.mapping.form.values.factory.DDMFormValuesFactory;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.portal.kernel.captcha.CaptchaTextException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_dynamic_data_lists_form_web_portlet_DDLFormPortlet", "mvc.command.name=addRecord"}, service={MVCActionCommand.class})
public class AddRecordMVCActionCommand
extends BaseMVCActionCommand {
    @Reference
    private AddRecordMVCCommandHelper _addRecordMVCCommandHelper;
    private DDLFormEmailNotificationSender _ddlFormEmailNotificationSender;
    private DDLRecordService _ddlRecordService;
    private DDLRecordSetService _ddlRecordSetService;
    private DDMFormValuesFactory _ddmFormValuesFactory;
    @Reference
    private Portal _portal;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long recordSetId;
        PortletSession portletSession = actionRequest.getPortletSession();
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        if (groupId == 0L) {
            groupId = GetterUtil.getLong((Object)portletSession.getAttribute("GROUP_ID"));
        }
        if ((recordSetId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"recordSetId")) == 0L) {
            recordSetId = GetterUtil.getLong((Object)portletSession.getAttribute("DYNAMIC_DATA_LISTS_RECORD_SET_ID"));
        }
        DDLRecordSet recordSet = this._ddlRecordSetService.getRecordSet(recordSetId);
        this.validateCaptcha(actionRequest, recordSet);
        DDMForm ddmForm = this.getDDMForm(recordSet);
        DDMFormValues ddmFormValues = this._ddmFormValuesFactory.create((PortletRequest)actionRequest, ddmForm);
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._addRecordMVCCommandHelper.updateRequiredFieldsAccordingToVisibility(ddmForm, ddmFormValues, themeDisplay.getLocale());
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DDLRecord.class.getName(), (PortletRequest)actionRequest);
        DDLRecord ddlRecord = this._ddlRecordService.addRecord(groupId, recordSetId, 0, ddmFormValues, serviceContext);
        if (this.isEmailNotificationEnabled(recordSet)) {
            this._ddlFormEmailNotificationSender.sendEmailNotification((PortletRequest)actionRequest, ddlRecord);
        }
        DDLRecordSetSettings recordSetSettings = recordSet.getSettingsModel();
        String redirectURL = recordSetSettings.redirectURL();
        if (SessionErrors.isEmpty((PortletRequest)actionRequest) && Validator.isNotNull((String)redirectURL)) {
            String portletId = this._portal.getPortletId((PortletRequest)actionRequest);
            SessionMessages.add((PortletRequest)actionRequest, (String)portletId, (Object)".hideDefaultSuccessMessage");
            portletSession.setAttribute("DYNAMIC_DATA_LISTS_RECORD_SET_ID", (Object)recordSetId);
            portletSession.setAttribute("GROUP_ID", (Object)groupId);
            actionResponse.sendRedirect(redirectURL);
        }
    }

    protected DDMForm getDDMForm(DDLRecordSet recordSet) throws PortalException {
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        return ddmStructure.getDDMForm();
    }

    protected boolean isEmailNotificationEnabled(DDLRecordSet recordSet) throws PortalException {
        DDLRecordSetSettings recordSettings = recordSet.getSettingsModel();
        return recordSettings.sendEmailNotification();
    }

    @Reference(unbind="-")
    protected void setDDLFormEmailNotificationSender(DDLFormEmailNotificationSender ddlFormEmailNotificationSender) {
        this._ddlFormEmailNotificationSender = ddlFormEmailNotificationSender;
    }

    @Reference(unbind="-")
    protected void setDDLRecordService(DDLRecordService ddlRecordService) {
        this._ddlRecordService = ddlRecordService;
    }

    @Reference(unbind="-")
    protected void setDDLRecordSetService(DDLRecordSetService ddlRecordSetService) {
        this._ddlRecordSetService = ddlRecordSetService;
    }

    @Reference(unbind="-")
    protected void setDDMFormValuesFactory(DDMFormValuesFactory ddmFormValuesFactory) {
        this._ddmFormValuesFactory = ddmFormValuesFactory;
    }

    protected void validateCaptcha(ActionRequest actionRequest, DDLRecordSet recordSet) throws Exception {
        DDLRecordSetSettings recordSetSettings = recordSet.getSettingsModel();
        if (recordSetSettings.requireCaptcha()) {
            try {
                CaptchaUtil.check((PortletRequest)actionRequest);
            }
            catch (CaptchaTextException cte) {
                SessionErrors.add((PortletRequest)actionRequest, (String)CaptchaTextException.class.getName());
                throw cte;
            }
        }
    }
}

