/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.form.web.internal.notification;

import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.model.DDLRecordSetSettings;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldValueRenderer;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutColumn;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutPage;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutRow;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.mail.kernel.model.MailMessage;
import com.liferay.mail.kernel.service.MailService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.URLTemplateResource;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.template.soy.utils.SoyHTMLContextValue;
import com.liferay.portal.util.PrefsPropsUtil;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.mail.internet.InternetAddress;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DDLFormEmailNotificationSender.class})
public class DDLFormEmailNotificationSender {
    private static final String _NAMESPACE = "form.form_entry";
    private static final String _TEMPLATE_PATH = "/META-INF/resources/notification/form_entry_add_body.soy";
    private static final Log _log = LogFactoryUtil.getLog(DDLFormEmailNotificationSender.class);
    private DDMFormFieldTypeServicesTracker _ddmFormFieldTypeServicesTracker;
    private MailService _mailService;
    @Reference
    private Portal _portal;
    private UserLocalService _userLocalService;

    public void sendEmailNotification(PortletRequest portletRequest, DDLRecord record) {
        try {
            MailMessage mailMessage = this.createMailMessage(portletRequest, record);
            this._mailService.sendEmail(mailMessage);
        }
        catch (Exception e) {
            _log.error((Object)"Unable to send form email", (Throwable)e);
        }
    }

    protected MailMessage createMailMessage(PortletRequest portletRequest, DDLRecord record) throws Exception {
        DDLRecordSet recordSet = record.getRecordSet();
        String emailFromAddress = this.getEmailFromAddress(recordSet);
        String emailFromName = this.getEmailFromName(recordSet);
        InternetAddress fromInternetAddress = new InternetAddress(emailFromAddress, emailFromName);
        String subject = this.getEmailSubject(recordSet);
        String body = this.getEmailBody(portletRequest, recordSet, record);
        MailMessage mailMessage = new MailMessage(fromInternetAddress, subject, body, true);
        String emailToAddress = this.getEmailToAddress(recordSet);
        InternetAddress[] toAddresses = InternetAddress.parse((String)emailToAddress);
        mailMessage.setTo(toAddresses);
        return mailMessage;
    }

    protected Template createTemplate(PortletRequest portletRequest, DDLRecordSet recordSet, DDLRecord record) throws PortalException {
        Template template = TemplateManagerUtil.getTemplate((String)"soy", (TemplateResource)this.getTemplateResource(_TEMPLATE_PATH), (boolean)false);
        this.populateParameters(template, portletRequest, recordSet, record);
        return template;
    }

    protected DDMForm getDDMForm(DDLRecordSet recordSet) throws PortalException {
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        return ddmStructure.getDDMForm();
    }

    protected Map<String, List<DDMFormFieldValue>> getDDMFormFieldValuesMap(DDLRecord record) throws PortalException {
        DDMFormValues ddmFormValues = record.getDDMFormValues();
        return ddmFormValues.getDDMFormFieldValuesMap();
    }

    protected DDMFormLayout getDDMFormLayout(DDLRecordSet recordSet) throws PortalException {
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        return ddmStructure.getDDMFormLayout();
    }

    protected String getEmailBody(PortletRequest portletRequest, DDLRecordSet recordSet, DDLRecord record) throws PortalException {
        Template template = this.createTemplate(portletRequest, recordSet, record);
        return this.render(template);
    }

    protected String getEmailFromAddress(DDLRecordSet recordSet) throws PortalException {
        DDLRecordSetSettings recordSettings = recordSet.getSettingsModel();
        String defaultEmailFromAddress = PrefsPropsUtil.getString((long)recordSet.getCompanyId(), (String)"admin.email.from.address");
        return GetterUtil.getString((String)recordSettings.emailFromAddress(), (String)defaultEmailFromAddress);
    }

    protected String getEmailFromName(DDLRecordSet recordSet) throws PortalException {
        DDLRecordSetSettings recordSettings = recordSet.getSettingsModel();
        String defaultEmailFromName = PrefsPropsUtil.getString((long)recordSet.getCompanyId(), (String)"admin.email.from.name");
        return GetterUtil.getString((String)recordSettings.emailFromName(), (String)defaultEmailFromName);
    }

    protected String getEmailSubject(DDLRecordSet recordSet) throws PortalException {
        DDLRecordSetSettings recordSettings = recordSet.getSettingsModel();
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        DDMForm ddmForm = ddmStructure.getDDMForm();
        Locale locale = ddmForm.getDefaultLocale();
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
        String defaultEmailSubject = LanguageUtil.format((ResourceBundle)resourceBundle, (String)"new-x-form-submitted", (Object)recordSet.getName(locale), (boolean)false);
        return GetterUtil.getString((String)recordSettings.emailSubject(), (String)defaultEmailSubject);
    }

    protected String getEmailToAddress(DDLRecordSet recordSet) throws PortalException {
        String defaultEmailToAddress = "";
        DDLRecordSetSettings recordSettings = recordSet.getSettingsModel();
        User user = this._userLocalService.fetchUser(recordSet.getUserId());
        if (user != null) {
            defaultEmailToAddress = user.getEmailAddress();
        }
        return GetterUtil.getString((String)recordSettings.emailToAddress(), (String)defaultEmailToAddress);
    }

    protected Map<String, Object> getField(List<DDMFormFieldValue> ddmFormFieldValues, Locale locale) {
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        String labelString = null;
        StringBundler sb = new StringBundler(ddmFormFieldValues.size() * 2 - 1);
        for (int i = 0; i < ddmFormFieldValues.size(); ++i) {
            DDMFormFieldValue ddmFormFieldValue = ddmFormFieldValues.get(i);
            DDMFormField ddmFormField = ddmFormFieldValue.getDDMFormField();
            if (labelString == null) {
                LocalizedValue label = ddmFormField.getLabel();
                labelString = label.getString(locale);
                if (ddmFormField.isRequired()) {
                    labelString = labelString.concat("*");
                }
            }
            sb.append(this.renderDDMFormFieldValue(ddmFormFieldValue, locale));
            if (i >= ddmFormFieldValues.size() - 1) continue;
            sb.append(", ");
        }
        fieldMap.put("label", labelString);
        fieldMap.put("value", new SoyHTMLContextValue(sb.toString()));
        return fieldMap;
    }

    protected List<String> getFieldNames(DDMFormLayoutPage ddmFormLayoutPage) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (DDMFormLayoutRow ddmFormLayoutRow : ddmFormLayoutPage.getDDMFormLayoutRows()) {
            for (DDMFormLayoutColumn ddmFormLayoutColumn : ddmFormLayoutRow.getDDMFormLayoutColumns()) {
                fieldNames.addAll(ddmFormLayoutColumn.getDDMFormFieldNames());
            }
        }
        return fieldNames;
    }

    protected List<Object> getFields(List<String> fieldNames, Map<String, List<DDMFormFieldValue>> ddmFormFieldValuesMap, Locale locale) {
        ArrayList<Object> fields = new ArrayList<Object>();
        for (String fieldName : fieldNames) {
            List<DDMFormFieldValue> ddmFormFieldValues = ddmFormFieldValuesMap.get(fieldName);
            if (ddmFormFieldValues == null) continue;
            Map<String, Object> field = this.getField(ddmFormFieldValues, locale);
            fields.add(field);
        }
        return fields;
    }

    protected Locale getLocale(DDLRecordSet recordSet) throws PortalException {
        DDMForm ddmForm = this.getDDMForm(recordSet);
        return ddmForm.getDefaultLocale();
    }

    protected Map<String, Object> getPage(DDMFormLayoutPage ddmFormLayoutPage, Map<String, List<DDMFormFieldValue>> ddmFormFieldValuesMap, Locale locale) {
        HashMap<String, Object> pageMap = new HashMap<String, Object>();
        List<String> fieldNames = this.getFieldNames(ddmFormLayoutPage);
        pageMap.put("fields", this.getFields(fieldNames, ddmFormFieldValuesMap, locale));
        LocalizedValue title = ddmFormLayoutPage.getTitle();
        pageMap.put("title", title.getString(locale));
        return pageMap;
    }

    protected List<Object> getPages(DDLRecordSet recordSet, DDLRecord record) throws PortalException {
        ArrayList<Object> pages = new ArrayList<Object>();
        DDMFormLayout ddmFormLayout = this.getDDMFormLayout(recordSet);
        for (DDMFormLayoutPage ddmFormLayoutPage : ddmFormLayout.getDDMFormLayoutPages()) {
            Map<String, Object> page = this.getPage(ddmFormLayoutPage, this.getDDMFormFieldValuesMap(record), this.getLocale(recordSet));
            pages.add(page);
        }
        return pages;
    }

    protected String getSiteName(PortletRequest portletRequest, Locale locale) {
        ThemeDisplay themeDisplay = this.getThemeDisplay(portletRequest);
        Group siteGroup = themeDisplay.getSiteGroup();
        return siteGroup.getName(locale);
    }

    protected TemplateResource getTemplateResource(String templatePath) {
        Class<?> clazz = this.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        URL templateURL = classLoader.getResource(templatePath);
        return new URLTemplateResource(templateURL.getPath(), templateURL);
    }

    protected ThemeDisplay getThemeDisplay(PortletRequest portletRequest) {
        return (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    protected String getViewFormEntriesURL(PortletRequest portletRequest, DDLRecordSet recordSet) throws PortalException {
        ThemeDisplay themeDisplay = this.getThemeDisplay(portletRequest);
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        String portletNamespace = this._portal.getPortletNamespace("com_liferay_dynamic_data_lists_form_web_portlet_DDLFormAdminPortlet");
        params.put(portletNamespace.concat("mvcPath"), new String[]{"/admin/view_records.jsp"});
        params.put(portletNamespace.concat("recordSetId"), new String[]{String.valueOf(recordSet.getRecordSetId())});
        return this._portal.getSiteAdminURL(themeDisplay, "com_liferay_dynamic_data_lists_form_web_portlet_DDLFormAdminPortlet", params);
    }

    protected String getViewFormURL(PortletRequest portletRequest, DDLRecordSet recordSet, DDLRecord record) throws PortalException {
        ThemeDisplay themeDisplay = this.getThemeDisplay(portletRequest);
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        String portletNamespace = this._portal.getPortletNamespace("com_liferay_dynamic_data_lists_form_web_portlet_DDLFormAdminPortlet");
        params.put(portletNamespace.concat("mvcPath"), new String[]{"/admin/view_record.jsp"});
        params.put(portletNamespace.concat("recordId"), new String[]{String.valueOf(record.getRecordId())});
        params.put(portletNamespace.concat("recordSetId"), new String[]{String.valueOf(recordSet.getRecordSetId())});
        return this._portal.getSiteAdminURL(themeDisplay, "com_liferay_dynamic_data_lists_form_web_portlet_DDLFormAdminPortlet", params);
    }

    protected void populateParameters(Template template, PortletRequest portletRequest, DDLRecordSet recordSet, DDLRecord record) throws PortalException {
        Locale locale = this.getLocale(recordSet);
        template.put((Object)"authorName", (Object)recordSet.getUserName());
        template.put((Object)"formName", (Object)recordSet.getName(locale));
        template.put((Object)"pages", this.getPages(recordSet, record));
        template.put((Object)"siteName", (Object)this.getSiteName(portletRequest, locale));
        template.put((Object)"userName", (Object)record.getUserName());
        template.put((Object)"viewFormEntriesURL", (Object)this.getViewFormEntriesURL(portletRequest, recordSet));
        template.put((Object)"viewFormURL", (Object)this.getViewFormURL(portletRequest, recordSet, record));
    }

    protected String render(Template template) throws TemplateException {
        UnsyncStringWriter writer = new UnsyncStringWriter();
        template.put((Object)"namespace", (Object)_NAMESPACE);
        template.processTemplate((Writer)writer);
        return writer.toString();
    }

    protected String renderDDMFormFieldValue(DDMFormFieldValue ddmFormFieldValue, Locale locale) {
        if (ddmFormFieldValue.getValue() == null) {
            return "";
        }
        DDMFormFieldValueRenderer ddmFormFieldValueRenderer = this._ddmFormFieldTypeServicesTracker.getDDMFormFieldValueRenderer(ddmFormFieldValue.getType());
        return HtmlUtil.unescape((String)ddmFormFieldValueRenderer.render(ddmFormFieldValue, locale));
    }

    @Reference(unbind="-")
    protected void setDDMFormFieldTypeServicesTracker(DDMFormFieldTypeServicesTracker ddmFormFieldTypeServicesTracker) {
        this._ddmFormFieldTypeServicesTracker = ddmFormFieldTypeServicesTracker;
    }

    @Reference(unbind="-")
    protected void setMailService(MailService mailService) {
        this._mailService = mailService;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }
}

