/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.form.web.internal.exportimport.portlet.preferences.processor;

import com.liferay.dynamic.data.lists.exportimport.staged.model.repository.DDLRecordStagedModelRepository;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.service.DDLRecordSetLocalService;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.portlet.preferences.processor.Capability;
import com.liferay.exportimport.portlet.preferences.processor.ExportImportPortletPreferencesProcessor;
import com.liferay.exportimport.portlet.preferences.processor.capability.ReferencedStagedModelImporterCapability;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.ReadOnlyException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_dynamic_data_lists_form_web_portlet_DDLFormPortlet"}, service={ExportImportPortletPreferencesProcessor.class})
public class DDLFormExportImportPortletPreferencesProcessor
implements ExportImportPortletPreferencesProcessor {
    private static final Log _log = LogFactoryUtil.getLog(DDLFormExportImportPortletPreferencesProcessor.class);
    @Reference
    private DDLRecordSetLocalService _ddlRecordSetLocalService;
    private DDLRecordStagedModelRepository _ddlRecordStagedModelRepository;
    @Reference
    private ReferencedStagedModelImporterCapability _referencedStagedModelImporterCapability;

    public List<Capability> getExportCapabilities() {
        return null;
    }

    public List<Capability> getImportCapabilities() {
        return ListUtil.toList((Object[])new Capability[]{this._referencedStagedModelImporterCapability});
    }

    public PortletPreferences processExportPortletPreferences(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws PortletDataException {
        try {
            portletDataContext.addPortletPermissions("com.liferay.dynamic.data.lists");
        }
        catch (PortalException pe) {
            throw new PortletDataException("Unable to export portlet permissions", (Throwable)pe);
        }
        String portletId = portletDataContext.getPortletId();
        final long recordSetId = GetterUtil.getLong((String)portletPreferences.getValue("recordSetId", null));
        if (recordSetId == 0L) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Record set ID is not set for preferences of portlet " + portletId));
            }
            return portletPreferences;
        }
        DDLRecordSet recordSet = this._ddlRecordSetLocalService.fetchRecordSet(recordSetId);
        if (recordSet != null) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (String)portletId, (StagedModel)recordSet);
            ExportActionableDynamicQuery recordActionableDynamicQuery = this._ddlRecordStagedModelRepository.getExportActionableDynamicQuery(portletDataContext, 2);
            final ActionableDynamicQuery.AddCriteriaMethod addCriteriaMethod = recordActionableDynamicQuery.getAddCriteriaMethod();
            recordActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

                public void addCriteria(DynamicQuery dynamicQuery) {
                    addCriteriaMethod.addCriteria(dynamicQuery);
                    Property property = PropertyFactoryUtil.forName((String)"recordSetId");
                    dynamicQuery.add(property.eq((Object)recordSetId));
                }
            });
            try {
                recordActionableDynamicQuery.performActions();
            }
            catch (PortalException pe) {
                throw new PortletDataException("Unable to export referenced records", (Throwable)pe);
            }
        }
        return portletPreferences;
    }

    public PortletPreferences processImportPortletPreferences(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws PortletDataException {
        try {
            portletDataContext.importPortletPermissions("com.liferay.dynamic.data.lists");
        }
        catch (PortalException pe) {
            throw new PortletDataException("Unable to export portlet permissions", (Throwable)pe);
        }
        long importedRecordSetId = GetterUtil.getLong((String)portletPreferences.getValue("recordSetId", null));
        Map recordSetIds = portletDataContext.getNewPrimaryKeysMap(DDLRecordSet.class);
        long recordSetId = MapUtil.getLong((Map)recordSetIds, (long)importedRecordSetId, (long)importedRecordSetId);
        try {
            portletPreferences.setValue("recordSetId", String.valueOf(recordSetId));
        }
        catch (ReadOnlyException roe) {
            throw new PortletDataException("Unable to update portlet preferences during import", (Throwable)roe);
        }
        return portletPreferences;
    }

    @Reference(target="(model.class.name=com.liferay.dynamic.data.lists.model.DDLRecord)", unbind="-")
    protected void setDDLRecordStagedModelRepository(DDLRecordStagedModelRepository ddlRecordStagedModelRepository) {
        this._ddlRecordStagedModelRepository = ddlRecordStagedModelRepository;
    }
}

