/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.form.web.internal.display.context;

import com.liferay.dynamic.data.lists.form.web.internal.search.RecordSearch;
import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.model.DDLRecordVersion;
import com.liferay.dynamic.data.lists.service.DDLRecordLocalService;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldValueRenderer;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.StorageEngine;
import com.liferay.portal.kernel.dao.search.DisplayTerms;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchContextFactory;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Function;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.portlet.MimeResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class DDLFormViewRecordsDisplayContext {
    private static final int _MAX_COLUMNS = 5;
    private final DDLRecordLocalService _ddlRecordLocalService;
    private final DDLRecordSet _ddlRecordSet;
    private final List<DDMFormField> _ddmFormFields = new ArrayList<DDMFormField>();
    private final DDMFormFieldTypeServicesTracker _ddmFormFieldTypeServicesTracker;
    private RecordSearch _recordSearchContainer;
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;
    private final StorageEngine _storageEngine;

    public DDLFormViewRecordsDisplayContext(RenderRequest renderRequest, RenderResponse renderResponse, DDLRecordSet ddlRecordSet, DDLRecordLocalService ddlRecordLocalService, DDMFormFieldTypeServicesTracker ddmFormFieldTypeServicesTracker, StorageEngine storageEngine) throws PortalException {
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
        this._ddlRecordSet = ddlRecordSet;
        this._ddlRecordLocalService = ddlRecordLocalService;
        this._ddmFormFieldTypeServicesTracker = ddmFormFieldTypeServicesTracker;
        this._storageEngine = storageEngine;
        ThemeDisplay themeDisplay = (ThemeDisplay)this._renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        portletDisplay.setShowBackIcon(true);
        portletDisplay.setURLBack(ParamUtil.getString((PortletRequest)this._renderRequest, (String)"redirect"));
        this.createRecordSearchContainer(ddlRecordSet.getDDMStructure());
    }

    public String getColumnName(DDMFormField ddmFormField) {
        LocalizedValue label = ddmFormField.getLabel();
        return label.getString(this._renderRequest.getLocale());
    }

    public String getColumnValue(DDMFormField ddmFormField, List<DDMFormFieldValue> ddmFormFieldValues) {
        if (ddmFormFieldValues == null) {
            return "";
        }
        final DDMFormFieldValueRenderer ddmFieldValueRenderer = this._ddmFormFieldTypeServicesTracker.getDDMFormFieldValueRenderer(ddmFormField.getType());
        List renderedDDMFormFielValues = ListUtil.toList(ddmFormFieldValues, (Function)new Function<DDMFormFieldValue, String>(){

            public String apply(DDMFormFieldValue ddmFormFieldValue) {
                return ddmFieldValueRenderer.render(ddmFormFieldValue, DDLFormViewRecordsDisplayContext.this._renderRequest.getLocale());
            }
        });
        return StringUtil.merge((Collection)renderedDDMFormFielValues, (String)", ");
    }

    public DDLRecordSet getDDLRecordSet() {
        return this._ddlRecordSet;
    }

    public List<DDMFormField> getDDMFormFields() {
        return this._ddmFormFields;
    }

    public DDMFormValues getDDMFormValues(DDLRecord ddlRecord) throws PortalException {
        DDLRecordVersion recordVersion = ddlRecord.getRecordVersion();
        return this._storageEngine.getDDMFormValues(recordVersion.getDDMStorageId());
    }

    public String getDisplayStyle() {
        return "list";
    }

    public String getOrderByCol() {
        PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((PortletRequest)this._renderRequest);
        String orderByCol = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"orderByCol");
        if (Validator.isNull((String)orderByCol)) {
            orderByCol = portalPreferences.getValue("com_liferay_dynamic_data_lists_form_web_portlet_DDLFormAdminPortlet", "view-entries-order-by-col", "modified-date");
        } else {
            portalPreferences.setValue("com_liferay_dynamic_data_lists_form_web_portlet_DDLFormAdminPortlet", "view-entries-order-by-col", orderByCol);
        }
        return orderByCol;
    }

    public String getOrderByType() {
        PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((PortletRequest)this._renderRequest);
        String orderByType = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"orderByType");
        if (Validator.isNull((String)orderByType)) {
            orderByType = portalPreferences.getValue("com_liferay_dynamic_data_lists_form_web_portlet_DDLFormAdminPortlet", "view-entries-order-by-type", "asc");
        } else {
            portalPreferences.setValue("com_liferay_dynamic_data_lists_form_web_portlet_DDLFormAdminPortlet", "view-entries-order-by-type", orderByType);
        }
        return orderByType;
    }

    public RecordSearch getRecordSearchContainer() {
        return this._recordSearchContainer;
    }

    public int getStatus(DDLRecord ddlRecord) throws PortalException {
        DDLRecordVersion recordVersion = ddlRecord.getRecordVersion();
        return recordVersion.getStatus();
    }

    protected void createRecordSearchContainer(DDMStructure ddmStructure) {
        ArrayList<String> headerNames = new ArrayList<String>();
        List<DDMFormField> ddmFormfields = this.getNontransientDDMFormFields(ddmStructure.getDDMForm());
        int totalColumns = 5;
        if (ddmFormfields.size() < totalColumns) {
            totalColumns = ddmFormfields.size();
        }
        for (int i = 0; i < totalColumns; ++i) {
            DDMFormField ddmFormField = ddmFormfields.get(i);
            this._ddmFormFields.add(ddmFormField);
            LocalizedValue label = ddmFormField.getLabel();
            headerNames.add(label.getString(this._renderRequest.getLocale()));
        }
        PortletURL portletURL = PortletURLUtil.getCurrent((PortletRequest)this._renderRequest, (MimeResponse)this._renderResponse);
        this._recordSearchContainer = new RecordSearch((PortletRequest)this._renderRequest, portletURL, headerNames);
        OrderByComparator<DDLRecord> orderByComparator = RecordSearch.getRecordOrderByComparator(this.getOrderByCol(), this.getOrderByType());
        this._recordSearchContainer.setOrderByCol(this.getOrderByCol());
        this._recordSearchContainer.setOrderByComparator(orderByComparator);
        this._recordSearchContainer.setOrderByType(this.getOrderByType());
        this.updateSearchContainerResults();
    }

    protected List<DDMFormField> getNontransientDDMFormFields(DDMForm ddmForm) {
        ArrayList<DDMFormField> ddmFormfields = new ArrayList<DDMFormField>();
        for (DDMFormField ddmFormField : ddmForm.getDDMFormFields()) {
            if (ddmFormField.isTransient()) continue;
            ddmFormfields.add(ddmFormField);
        }
        return ddmFormfields;
    }

    protected void updateSearchContainerResults() {
        List results = null;
        int total = 0;
        DisplayTerms displayTerms = this._recordSearchContainer.getDisplayTerms();
        int status = -1;
        if (Validator.isNull((String)displayTerms.getKeywords())) {
            results = this._ddlRecordLocalService.getRecords(this._ddlRecordSet.getRecordSetId(), status, this._recordSearchContainer.getStart(), this._recordSearchContainer.getEnd(), this._recordSearchContainer.getOrderByComparator());
            total = this._ddlRecordLocalService.getRecordsCount(this._ddlRecordSet.getRecordSetId(), status);
        } else {
            SearchContext searchContext = SearchContextFactory.getInstance((HttpServletRequest)PortalUtil.getHttpServletRequest((PortletRequest)this._renderRequest));
            searchContext.setAttribute("status", (Serializable)Integer.valueOf(status));
            searchContext.setAttribute("recordSetId", (Serializable)Long.valueOf(this._ddlRecordSet.getRecordSetId()));
            searchContext.setAttribute("recordSetScope", (Serializable)Integer.valueOf(this._ddlRecordSet.getScope()));
            searchContext.setEnd(this._recordSearchContainer.getEnd());
            searchContext.setKeywords(displayTerms.getKeywords());
            searchContext.setStart(this._recordSearchContainer.getStart());
            BaseModelSearchResult baseModelSearchResult = this._ddlRecordLocalService.searchDDLRecords(searchContext);
            results = baseModelSearchResult.getBaseModels();
            total = baseModelSearchResult.getLength();
        }
        this._recordSearchContainer.setResults(results);
        this._recordSearchContainer.setTotal(total);
    }
}

