/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.form.web.internal.display.context;

import com.liferay.dynamic.data.lists.form.web.internal.display.context.util.DDLFormAdminRequestHelper;
import com.liferay.dynamic.data.lists.model.DDLFormRecord;
import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.service.DDLRecordLocalService;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderer;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderingContext;
import com.liferay.dynamic.data.mapping.form.values.factory.DDMFormValuesFactory;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesMerger;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DDLFormViewRecordDisplayContext {
    private final DDLFormAdminRequestHelper _ddlFormAdminRequestHelper;
    private final DDLRecordLocalService _ddlRecordLocalService;
    private final DDMFormRenderer _ddmFormRenderer;
    private final DDMFormValuesFactory _ddmFormValuesFactory;
    private final DDMFormValuesMerger _ddmFormValuesMerger;
    private DDMStructure _ddmStructure;
    private final DDMStructureLocalService _ddmStructureLocalService;
    private final HttpServletResponse _httpServletResponse;

    public DDLFormViewRecordDisplayContext(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, DDLRecordLocalService ddlRecordLocalService, DDMFormRenderer ddmFormRenderer, DDMFormValuesFactory ddmFormValuesFactory, DDMFormValuesMerger ddmFormValuesMerger, DDMStructureLocalService ddmStructureLocalService) {
        this._httpServletResponse = httpServletResponse;
        this._ddlRecordLocalService = ddlRecordLocalService;
        this._ddmFormRenderer = ddmFormRenderer;
        this._ddmFormValuesFactory = ddmFormValuesFactory;
        this._ddmFormValuesMerger = ddmFormValuesMerger;
        this._ddmStructureLocalService = ddmStructureLocalService;
        this._ddlFormAdminRequestHelper = new DDLFormAdminRequestHelper(httpServletRequest);
    }

    public String getDDMFormHTML(RenderRequest renderRequest) throws PortalException {
        DDLRecord record = this.getRecord();
        DDMStructure ddmStructure = this.getDDMStructure();
        DDMForm ddmForm = ddmStructure.getDDMForm();
        DDMFormValues ddmFormValues = this._ddmFormValuesFactory.create((PortletRequest)renderRequest, ddmForm);
        ddmFormValues = this._ddmFormValuesMerger.merge(record.getDDMFormValues(), ddmFormValues);
        DDMFormRenderingContext ddmFormRenderingContext = this.createDDMFormRenderingContext();
        ddmFormRenderingContext.setDDMFormValues(ddmFormValues);
        for (DDMFormField ddmFormField : ddmForm.getDDMFormFields()) {
            this.setDDMFormFieldReadOnly(ddmFormField);
        }
        DDMFormLayout ddmFormLayout = ddmStructure.getDDMFormLayout();
        return this._ddmFormRenderer.render(ddmForm, ddmFormLayout, ddmFormRenderingContext);
    }

    protected DDMFormRenderingContext createDDMFormRenderingContext() {
        DDMFormRenderingContext ddmFormRenderingContext = new DDMFormRenderingContext();
        ddmFormRenderingContext.setHttpServletRequest(this._ddlFormAdminRequestHelper.getRequest());
        ddmFormRenderingContext.setHttpServletResponse(this._httpServletResponse);
        ddmFormRenderingContext.setLocale(this._ddlFormAdminRequestHelper.getLocale());
        ddmFormRenderingContext.setPortletNamespace(PortalUtil.getPortletNamespace((String)"com_liferay_dynamic_data_lists_form_web_portlet_DDLFormAdminPortlet"));
        ddmFormRenderingContext.setReadOnly(true);
        return ddmFormRenderingContext;
    }

    protected DDMStructure getDDMStructure() throws PortalException {
        if (this._ddmStructure != null) {
            return this._ddmStructure;
        }
        DDLRecordSet recordSet = this.getRecordSet();
        if (recordSet == null) {
            return null;
        }
        this._ddmStructure = this._ddmStructureLocalService.getStructure(recordSet.getDDMStructureId());
        return this._ddmStructure;
    }

    protected DDLRecord getRecord() throws PortalException {
        HttpServletRequest httpServletRequest = this._ddlFormAdminRequestHelper.getRequest();
        long recordId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"recordId");
        if (recordId > 0L) {
            return this._ddlRecordLocalService.fetchRecord(recordId);
        }
        Object record = httpServletRequest.getAttribute("DYNAMIC_DATA_LISTS_RECORD");
        if (record instanceof DDLFormRecord) {
            DDLFormRecord formRecord = (DDLFormRecord)record;
            return formRecord.getDDLRecord();
        }
        return (DDLRecord)record;
    }

    protected DDLRecordSet getRecordSet() throws PortalException {
        DDLRecord record = this.getRecord();
        if (record == null) {
            return null;
        }
        return record.getRecordSet();
    }

    protected void setDDMFormFieldReadOnly(DDMFormField ddmFormField) {
        ddmFormField.setReadOnly(true);
        for (DDMFormField nestedDDMFormField : ddmFormField.getNestedDDMFormFields()) {
            this.setDDMFormFieldReadOnly(nestedDDMFormField);
        }
    }
}

