/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.form.web.internal.display.context;

import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.model.DDLRecordSetSettings;
import com.liferay.dynamic.data.lists.service.DDLRecordSetService;
import com.liferay.dynamic.data.lists.service.permission.DDLRecordSetPermission;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderer;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderingContext;
import com.liferay.dynamic.data.mapping.form.values.factory.DDMFormValuesFactory;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutColumn;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutPage;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutRow;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.WorkflowDefinitionLinkLocalService;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PrefsParamUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceURL;
import javax.servlet.http.HttpServletRequest;

public class DDLFormDisplayContext {
    private static final String _DDM_FORM_FIELD_NAME_CAPTCHA = "_CAPTCHA_";
    private static final Log _log = LogFactoryUtil.getLog(DDLFormDisplayContext.class);
    private final DDLRecordSetService _ddlRecordSetService;
    private final DDMFormRenderer _ddmFormRenderer;
    private final DDMFormValuesFactory _ddmFormValuesFactory;
    private Boolean _hasViewPermission;
    private DDLRecordSet _recordSet;
    private long _recordSetId;
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;
    private Boolean _showConfigurationIcon;
    private final WorkflowDefinitionLinkLocalService _workflowDefinitionLinkLocalService;

    public DDLFormDisplayContext(RenderRequest renderRequest, RenderResponse renderResponse, DDLRecordSetService ddlRecordSetService, DDMFormRenderer ddmFormRenderer, DDMFormValuesFactory ddmFormValuesFactory, WorkflowDefinitionLinkLocalService workflowDefinitionLinkLocalService) throws PortalException {
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
        this._ddlRecordSetService = ddlRecordSetService;
        this._ddmFormRenderer = ddmFormRenderer;
        this._ddmFormValuesFactory = ddmFormValuesFactory;
        this._workflowDefinitionLinkLocalService = workflowDefinitionLinkLocalService;
        if (Validator.isNotNull((String)this.getPortletResource())) {
            return;
        }
        DDLRecordSet recordSet = this.getRecordSet();
        if (recordSet == null || !this.hasViewPermission()) {
            renderRequest.setAttribute("PORTLET_CONFIGURATOR_VISIBILITY", (Object)Boolean.TRUE);
        }
    }

    public String getDDMFormHTML() throws PortalException {
        DDLRecordSet recordSet = this.getRecordSet();
        if (recordSet == null) {
            return "";
        }
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        boolean requireCaptcha = this.isCaptchaRequired(recordSet);
        DDMForm ddmForm = this.getDDMForm(ddmStructure, requireCaptcha);
        DDMFormLayout ddmFormLayout = this.getDDMFormLayout(ddmStructure, requireCaptcha);
        DDMFormRenderingContext ddmFormRenderingContext = this.createDDMFormRenderingContext(ddmForm);
        boolean showSubmitButton = this.isShowSubmitButton();
        ddmFormRenderingContext.setShowSubmitButton(showSubmitButton);
        String submitLabel = this.getSubmitLabel(recordSet);
        ddmFormRenderingContext.setSubmitLabel(submitLabel);
        return this._ddmFormRenderer.render(ddmForm, ddmFormLayout, ddmFormRenderingContext);
    }

    public DDLRecordSet getRecordSet() {
        if (this._recordSet != null) {
            return this._recordSet;
        }
        try {
            this._recordSet = this._ddlRecordSetService.fetchRecordSet(this.getRecordSetId());
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return null;
        }
        return this._recordSet;
    }

    public long getRecordSetId() {
        if (this._recordSetId != 0L) {
            return this._recordSetId;
        }
        this._recordSetId = PrefsParamUtil.getLong((PortletPreferences)this._renderRequest.getPreferences(), (PortletRequest)this._renderRequest, (String)"recordSetId");
        return this._recordSetId;
    }

    public String getRedirectURL() throws PortalException {
        DDLRecordSet recordSet = this.getRecordSet();
        if (recordSet == null) {
            return null;
        }
        DDLRecordSetSettings recordSetSettings = recordSet.getSettingsModel();
        return recordSetSettings.redirectURL();
    }

    public boolean isFormAvailable() throws PortalException {
        if (this.isPreview()) {
            return true;
        }
        if (this.isSharedURL()) {
            return this.isFormPublished() && this.isFormShared();
        }
        return this.getRecordSet() != null;
    }

    public boolean isShowConfigurationIcon() throws PortalException {
        if (this._showConfigurationIcon != null) {
            return this._showConfigurationIcon;
        }
        if (this.isPreview() || this.isSharedURL() && this.isFormShared()) {
            this._showConfigurationIcon = false;
            return this._showConfigurationIcon;
        }
        ThemeDisplay themeDisplay = this.getThemeDisplay();
        this._showConfigurationIcon = PortletPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (Layout)themeDisplay.getLayout(), (String)this.getPortletId(), (String)"CONFIGURATION");
        return this._showConfigurationIcon;
    }

    protected String createCaptchaResourceURL() {
        ResourceURL resourceURL = this._renderResponse.createResourceURL();
        resourceURL.setResourceID("captcha");
        return resourceURL.toString();
    }

    protected DDMFormRenderingContext createDDMFormRenderingContext(DDMForm ddmForm) {
        DDMFormRenderingContext ddmFormRenderingContext = new DDMFormRenderingContext();
        ddmFormRenderingContext.setDDMFormValues(this._ddmFormValuesFactory.create((PortletRequest)this._renderRequest, ddmForm));
        ddmFormRenderingContext.setHttpServletRequest(PortalUtil.getHttpServletRequest((PortletRequest)this._renderRequest));
        ddmFormRenderingContext.setHttpServletResponse(PortalUtil.getHttpServletResponse((PortletResponse)this._renderResponse));
        ddmFormRenderingContext.setLocale(ddmForm.getDefaultLocale());
        ddmFormRenderingContext.setPortletNamespace(this._renderResponse.getNamespace());
        return ddmFormRenderingContext;
    }

    protected DDMFormLayoutRow createFullColumnDDMFormLayoutRow(String ddmFormFieldName) {
        DDMFormLayoutRow ddmFormLayoutRow = new DDMFormLayoutRow();
        DDMFormLayoutColumn ddmFormLayoutColumn = new DDMFormLayoutColumn(12, new String[]{ddmFormFieldName});
        ddmFormLayoutRow.addDDMFormLayoutColumn(ddmFormLayoutColumn);
        return ddmFormLayoutRow;
    }

    protected DDMForm getDDMForm(DDMStructure ddmStructure, boolean requireCaptcha) {
        DDMForm ddmForm = ddmStructure.getDDMForm();
        if (requireCaptcha) {
            DDMFormField captchaDDMFormField = new DDMFormField(_DDM_FORM_FIELD_NAME_CAPTCHA, "captcha");
            captchaDDMFormField.setDataType("string");
            captchaDDMFormField.setProperty("url", (Object)this.createCaptchaResourceURL());
            ddmForm.addDDMFormField(captchaDDMFormField);
        }
        return ddmForm;
    }

    protected DDMFormLayout getDDMFormLayout(DDMStructure ddmStructure, boolean requireCaptcha) throws PortalException {
        DDMFormLayout ddmFormLayout = ddmStructure.getDDMFormLayout();
        if (requireCaptcha) {
            DDMFormLayoutPage lastDDMFormLayoutPage = this.getLastDDMFormLayoutPage(ddmFormLayout);
            DDMFormLayoutRow ddmFormLayoutRow = this.createFullColumnDDMFormLayoutRow(_DDM_FORM_FIELD_NAME_CAPTCHA);
            lastDDMFormLayoutPage.addDDMFormLayoutRow(ddmFormLayoutRow);
        }
        return ddmFormLayout;
    }

    protected DDMFormLayoutPage getLastDDMFormLayoutPage(DDMFormLayout ddmFormLayout) {
        List ddmFormLayoutPages = ddmFormLayout.getDDMFormLayoutPages();
        return (DDMFormLayoutPage)ddmFormLayoutPages.get(ddmFormLayoutPages.size() - 1);
    }

    protected String getPortletId() {
        ThemeDisplay themeDisplay = this.getThemeDisplay();
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        return portletDisplay.getId();
    }

    protected String getPortletResource() {
        ThemeDisplay themeDisplay = this.getThemeDisplay();
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        return portletDisplay.getPortletResource();
    }

    protected String getSubmitLabel(DDLRecordSet recordSet) {
        ThemeDisplay themeDisplay = this.getThemeDisplay();
        boolean workflowEnabled = this.hasWorkflowEnabled(recordSet, themeDisplay);
        if (workflowEnabled) {
            return LanguageUtil.get((HttpServletRequest)themeDisplay.getRequest(), (String)"submit-for-publication");
        }
        return LanguageUtil.get((HttpServletRequest)themeDisplay.getRequest(), (String)"submit");
    }

    protected ThemeDisplay getThemeDisplay() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return themeDisplay;
    }

    protected boolean hasViewPermission() throws PortalException {
        if (this._hasViewPermission != null) {
            return this._hasViewPermission;
        }
        this._hasViewPermission = true;
        DDLRecordSet recordSet = this.getRecordSet();
        if (recordSet != null) {
            ThemeDisplay themeDisplay = this.getThemeDisplay();
            this._hasViewPermission = DDLRecordSetPermission.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (DDLRecordSet)recordSet, (String)"VIEW");
        }
        return this._hasViewPermission;
    }

    protected boolean hasWorkflowEnabled(DDLRecordSet recordSet, ThemeDisplay themeDisplay) {
        return this._workflowDefinitionLinkLocalService.hasWorkflowDefinitionLink(themeDisplay.getCompanyId(), recordSet.getGroupId(), DDLRecordSet.class.getName(), recordSet.getRecordSetId());
    }

    protected boolean isCaptchaRequired(DDLRecordSet recordSet) throws PortalException {
        DDLRecordSetSettings recordSetSettings = recordSet.getSettingsModel();
        return recordSetSettings.requireCaptcha();
    }

    protected boolean isFormPublished() throws PortalException {
        DDLRecordSet recordSet = this.getRecordSet();
        if (recordSet == null) {
            return false;
        }
        DDLRecordSetSettings recordSetSettings = recordSet.getSettingsModel();
        return recordSetSettings.published();
    }

    protected boolean isFormShared() {
        return ParamUtil.getBoolean((PortletRequest)this._renderRequest, (String)"shared");
    }

    protected boolean isPreview() {
        return ParamUtil.getBoolean((PortletRequest)this._renderRequest, (String)"preview");
    }

    protected boolean isSharedURL() {
        ThemeDisplay themeDisplay = this.getThemeDisplay();
        String urlCurrent = themeDisplay.getURLCurrent();
        return urlCurrent.contains("/shared");
    }

    protected boolean isShowSubmitButton() {
        boolean preview = ParamUtil.getBoolean((PortletRequest)this._renderRequest, (String)"preview");
        return !preview;
    }
}

