/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.form.web.internal.asset;

import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.BaseAssetRendererFactory;
import com.liferay.dynamic.data.lists.form.web.internal.asset.DDLFormAssetRenderer;
import com.liferay.dynamic.data.lists.model.DDLFormRecord;
import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.model.DDLRecordVersion;
import com.liferay.dynamic.data.lists.model.impl.DDLFormRecordImpl;
import com.liferay.dynamic.data.lists.service.DDLRecordLocalService;
import com.liferay.dynamic.data.lists.service.DDLRecordVersionLocalService;
import com.liferay.dynamic.data.lists.service.permission.DDLRecordPermission;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderer;
import com.liferay.dynamic.data.mapping.form.values.factory.DDMFormValuesFactory;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesMerger;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import javax.servlet.ServletContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_dynamic_data_lists_form_web_portlet_DDLFormPortlet"}, service={AssetRendererFactory.class})
public class DDLFormAssetRendererFactory
extends BaseAssetRendererFactory<DDLFormRecord> {
    public static final String TYPE = "form";
    private DDLRecordLocalService _ddlRecordLocalService;
    private DDLRecordVersionLocalService _ddlRecordVersionLocalService;
    private DDMFormRenderer _ddmFormRenderer;
    private DDMFormValuesFactory _ddmFormValuesFactory;
    private DDMFormValuesMerger _ddmFormValuesMerger;
    private DDMStructureLocalService _ddmStructureLocalService;
    private ServletContext _servletContext;

    public DDLFormAssetRendererFactory() {
        this.setCategorizable(false);
        this.setClassName(DDLFormRecord.class.getName());
        this.setPortletId("com_liferay_dynamic_data_lists_form_web_portlet_DDLFormPortlet");
        this.setSearchable(true);
        this.setSelectable(false);
    }

    public AssetRenderer<DDLFormRecord> getAssetRenderer(long classPK, int type) throws PortalException {
        DDLRecord record = this._ddlRecordLocalService.fetchDDLRecord(classPK);
        DDLRecordVersion recordVersion = null;
        if (record == null) {
            recordVersion = this._ddlRecordVersionLocalService.getRecordVersion(classPK);
            record = recordVersion.getRecord();
        } else if (type == 0) {
            recordVersion = record.getLatestRecordVersion();
        } else if (type == 1) {
            recordVersion = record.getRecordVersion();
        } else {
            throw new IllegalArgumentException("Unknown asset renderer type " + type);
        }
        return this.createAssetRenderer(record, recordVersion, type);
    }

    public String getClassName() {
        return DDLFormRecord.class.getName();
    }

    public String getIconCssClass() {
        return "dynamic-data-list";
    }

    public String getType() {
        return TYPE;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws Exception {
        return DDLRecordPermission.contains((PermissionChecker)permissionChecker, (long)classPK, (String)actionId);
    }

    @Reference(target="(osgi.web.symbolicname=com.liferay.dynamic.data.lists.form.web)", unbind="-")
    public void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
    }

    protected AssetRenderer<DDLFormRecord> createAssetRenderer(DDLRecord record, DDLRecordVersion recordVersion, int type) {
        DDLFormRecordImpl formRecord = new DDLFormRecordImpl(record);
        DDLFormAssetRenderer ddlFormAssetRenderer = new DDLFormAssetRenderer((DDLFormRecord)formRecord, recordVersion, this._ddlRecordLocalService, this._ddmFormRenderer, this._ddmFormValuesFactory, this._ddmFormValuesMerger, this._ddmStructureLocalService);
        ddlFormAssetRenderer.setAssetRendererType(type);
        ddlFormAssetRenderer.setServletContext(this._servletContext);
        return ddlFormAssetRenderer;
    }

    @Reference(unbind="-")
    protected void setDDLRecordLocalService(DDLRecordLocalService ddlRecordLocalService) {
        this._ddlRecordLocalService = ddlRecordLocalService;
    }

    @Reference(unbind="-")
    protected void setDDLRecordVersionLocalService(DDLRecordVersionLocalService ddlRecordVersionLocalService) {
        this._ddlRecordVersionLocalService = ddlRecordVersionLocalService;
    }

    @Reference(unbind="-")
    protected void setDDMFormRenderer(DDMFormRenderer ddmFormRenderer) {
        this._ddmFormRenderer = ddmFormRenderer;
    }

    @Reference(unbind="-")
    protected void setDDMFormValuesFactory(DDMFormValuesFactory ddmFormValuesFactory) {
        this._ddmFormValuesFactory = ddmFormValuesFactory;
    }

    @Reference(unbind="-")
    protected void setDDMFormValuesMerger(DDMFormValuesMerger ddmFormValuesMerger) {
        this._ddmFormValuesMerger = ddmFormValuesMerger;
    }

    @Reference(unbind="-")
    protected void setDDMStructureLocalService(DDMStructureLocalService ddmStructureLocalService) {
        this._ddmStructureLocalService = ddmStructureLocalService;
    }
}

