/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.dynamic.data.lists.constants;

/**
 * Holds the DDL request attribute keys.
 *
 * @author Rafael Praxedes
 */
public class DDLWebKeys {

	/**
	 * {@value #DYNAMIC_DATA_LISTS_RECORD} is the key to use to retrieve the DDL
	 * Record from the request attribute.
	 */
	public static final String DYNAMIC_DATA_LISTS_RECORD =
		"DYNAMIC_DATA_LISTS_RECORD";

	/**
	 * {@value #DYNAMIC_DATA_LISTS_RECORD_SET} is the key to use to retrieve the
	 * DDL Record Set from the request attribute.
	 */
	public static final String DYNAMIC_DATA_LISTS_RECORD_SET =
		"DYNAMIC_DATA_LISTS_RECORD_SET";

	/**
	 * {@value #DYNAMIC_DATA_LISTS_RECORD_VERSION} is the key to use to retrieve
	 * the DDL Record Version from the request attribute.
	 */
	public static final String DYNAMIC_DATA_LISTS_RECORD_VERSION =
		"DYNAMIC_DATA_LISTS_RECORD_VERSION";

}