"use strict";

Liferay.Loader.define("document-library-web$dom-helpers@5.2.0/cjs/activeElement", ['module', 'exports', 'require', '@document-library-web$babel/runtime/helpers/interopRequireDefault', './ownerDocument'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var _interopRequireDefault = require("@document-library-web$babel/runtime/helpers/interopRequireDefault");

    exports.__esModule = true;
    exports.default = activeElement;

    var _ownerDocument = _interopRequireDefault(require("./ownerDocument"));

    /**
     * Return the actively focused element safely.
     *
     * @param doc the document to checl
     */
    function activeElement(doc) {
      if (doc === void 0) {
        doc = (0, _ownerDocument.default)();
      }

      // Support: IE 9 only
      // IE9 throws an "Unspecified error" accessing document.activeElement from an <iframe>
      try {
        var active = doc.activeElement; // IE11 returns a seemingly empty object in some cases when accessing
        // document.activeElement from an <iframe>

        if (!active || !active.nodeName) return null;
        return active;
      } catch (e) {
        /* ie throws if no active element */
        return doc.body;
      }
    }

    module.exports = exports["default"];
  }
});
//# sourceMappingURL=activeElement.js.map