Liferay.Loader.define('document-library-web$delegate@3.2.0/src/closest', ['module', 'exports', 'require'], function (module, exports, require) {
    var define = undefined;
    var global = window;
    {
        var DOCUMENT_NODE_TYPE = 9;

        /**
         * A polyfill for Element.matches()
         */
        if (typeof Element !== 'undefined' && !Element.prototype.matches) {
            var proto = Element.prototype;

            proto.matches = proto.matchesSelector || proto.mozMatchesSelector || proto.msMatchesSelector || proto.oMatchesSelector || proto.webkitMatchesSelector;
        }

        /**
         * Finds the closest parent that matches a selector.
         *
         * @param {Element} element
         * @param {String} selector
         * @return {Function}
         */
        function closest(element, selector) {
            while (element && element.nodeType !== DOCUMENT_NODE_TYPE) {
                if (typeof element.matches === 'function' && element.matches(selector)) {
                    return element;
                }
                element = element.parentNode;
            }
        }

        module.exports = closest;
    }
});
//# sourceMappingURL=closest.js.map