Liferay.Loader.define('document-library-web@5.0.83/document_library/js/bulk/reducer.es', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = reducer;
    exports.STATES = void 0;

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    var STATES = {
      IDLE: {
        running: false,
        show: false
      },
      LONG_POLLING: {
        running: true,
        show: true
      },
      NOTIFY: {
        running: false,
        show: false
      },
      SHORT_POLLING: {
        running: true,
        show: false
      }
    };
    exports.STATES = STATES;
    var TOASTS = {
      ERROR: {
        message: Liferay.Language.get('an-unexpected-error-occurred'),
        type: 'danger'
      },
      SUCCESS: {
        message: Liferay.Language.get('changes-saved')
      }
    };

    function reducer(state, action) {
      switch (action.type) {
        case 'check':
          if (state.current === STATES.LONG_POLLING) {
            return _objectSpread(_objectSpread({}, state), {}, {
              timestamp: Date.now()
            });
          }

          break;

        case 'error':
          return _objectSpread(_objectSpread({}, state), {}, {
            current: STATES.NOTIFY,
            toast: TOASTS.ERROR
          });

        case 'initialDelayCompleted':
          if (state.current === STATES.SHORT_POLLING) {
            return _objectSpread(_objectSpread({}, state), {}, {
              current: STATES.LONG_POLLING,
              timestamp: Date.now()
            });
          }

          break;

        case 'notificationCompleted':
          if (state.current === STATES.NOTIFY) {
            return _objectSpread(_objectSpread({}, state), {}, {
              current: STATES.IDLE
            });
          }

          break;

        case 'start':
          if (state.current === STATES.IDLE) {
            return _objectSpread(_objectSpread({}, state), {}, {
              current: STATES.SHORT_POLLING
            });
          }

          break;

        case 'success':
          return _objectSpread(_objectSpread({}, state), {}, {
            current: STATES.NOTIFY,
            toast: TOASTS.SUCCESS
          });

        default:
          return state;
      }

      return state;
    }
    //# sourceMappingURL=reducer.es.js.map
  }
});
//# sourceMappingURL=reducer.es.js.map