"use strict";

Liferay.Loader.define("document-library-web$dnd-core@11.1.3/dist/cjs/actions/dragDrop/beginDrag", ['module', 'exports', 'require', '@document-library-web$react-dnd/invariant', './local/setClientOffset', '../../utils/js_utils', './types'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.createBeginDrag = createBeginDrag;

    var _invariant = require("@document-library-web$react-dnd/invariant");

    var _setClientOffset = require("./local/setClientOffset");

    var _js_utils = require("../../utils/js_utils");

    var _types = require("./types");

    var ResetCoordinatesAction = {
      type: _types.INIT_COORDS,
      payload: {
        clientOffset: null,
        sourceClientOffset: null
      }
    };

    function createBeginDrag(manager) {
      return function beginDrag() {
        var sourceIds = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
        var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {
          publishSource: true
        };
        var _options$publishSourc = options.publishSource,
            publishSource = _options$publishSourc === void 0 ? true : _options$publishSourc,
            clientOffset = options.clientOffset,
            getSourceClientOffset = options.getSourceClientOffset;
        var monitor = manager.getMonitor();
        var registry = manager.getRegistry(); // Initialize the coordinates using the client offset

        manager.dispatch((0, _setClientOffset.setClientOffset)(clientOffset));
        verifyInvariants(sourceIds, monitor, registry); // Get the draggable source

        var sourceId = getDraggableSource(sourceIds, monitor);

        if (sourceId === null) {
          manager.dispatch(ResetCoordinatesAction);
          return;
        } // Get the source client offset


        var sourceClientOffset = null;

        if (clientOffset) {
          if (!getSourceClientOffset) {
            throw new Error('getSourceClientOffset must be defined');
          }

          verifyGetSourceClientOffsetIsFunction(getSourceClientOffset);
          sourceClientOffset = getSourceClientOffset(sourceId);
        } // Initialize the full coordinates


        manager.dispatch((0, _setClientOffset.setClientOffset)(clientOffset, sourceClientOffset));
        var source = registry.getSource(sourceId);
        var item = source.beginDrag(monitor, sourceId);
        verifyItemIsObject(item);
        registry.pinSource(sourceId);
        var itemType = registry.getSourceType(sourceId);
        return {
          type: _types.BEGIN_DRAG,
          payload: {
            itemType: itemType,
            item: item,
            sourceId: sourceId,
            clientOffset: clientOffset || null,
            sourceClientOffset: sourceClientOffset || null,
            isSourcePublic: !!publishSource
          }
        };
      };
    }

    function verifyInvariants(sourceIds, monitor, registry) {
      (0, _invariant.invariant)(!monitor.isDragging(), 'Cannot call beginDrag while dragging.');
      sourceIds.forEach(function (sourceId) {
        (0, _invariant.invariant)(registry.getSource(sourceId), 'Expected sourceIds to be registered.');
      });
    }

    function verifyGetSourceClientOffsetIsFunction(getSourceClientOffset) {
      (0, _invariant.invariant)(typeof getSourceClientOffset === 'function', 'When clientOffset is provided, getSourceClientOffset must be a function.');
    }

    function verifyItemIsObject(item) {
      (0, _invariant.invariant)((0, _js_utils.isObject)(item), 'Item must be an object.');
    }

    function getDraggableSource(sourceIds, monitor) {
      var sourceId = null;

      for (var i = sourceIds.length - 1; i >= 0; i--) {
        if (monitor.canDragSource(sourceIds[i])) {
          sourceId = sourceIds[i];
          break;
        }
      }

      return sourceId;
    }
  }
});
//# sourceMappingURL=beginDrag.js.map