/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.upload;

import com.liferay.document.library.util.DLURLHelper;
import com.liferay.item.selector.ItemSelectorUploadResponseHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.upload.UploadResponseHandler;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DLUploadResponseHandler.class})
public class DLUploadResponseHandler
implements UploadResponseHandler {
    private static final Log _log = LogFactoryUtil.getLog(DLUploadResponseHandler.class);
    @Reference
    private DLURLHelper _dlURLHelper;
    @Reference
    private ItemSelectorUploadResponseHandler _itemSelectorUploadResponseHandler;

    public JSONObject onFailure(PortletRequest portletRequest, PortalException pe) throws PortalException {
        return this._itemSelectorUploadResponseHandler.onFailure(portletRequest, pe);
    }

    public JSONObject onSuccess(UploadPortletRequest uploadPortletRequest, FileEntry fileEntry) throws PortalException {
        JSONObject jsonObject = this._itemSelectorUploadResponseHandler.onSuccess(uploadPortletRequest, fileEntry);
        JSONObject fileJSONObject = jsonObject.getJSONObject("file");
        fileJSONObject.put("url", this._getURL(uploadPortletRequest, fileEntry));
        return jsonObject;
    }

    private String _getURL(UploadPortletRequest uploadPortletRequest, FileEntry fileEntry) {
        try {
            ThemeDisplay themeDisplay = (ThemeDisplay)uploadPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            return this._dlURLHelper.getPreviewURL(fileEntry, fileEntry.getLatestFileVersion(), themeDisplay, "");
        }
        catch (PortalException pe) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to get URL for file entry " + fileEntry.getFileEntryId()), (Throwable)pe);
            }
            return "";
        }
    }
}

