/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.settings;

import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.settings.FallbackKeys;
import com.liferay.portal.kernel.settings.ParameterMapSettings;
import com.liferay.portal.kernel.settings.PortletInstanceSettingsLocator;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsFactoryUtil;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.settings.TypedSettings;
import com.liferay.portal.kernel.util.ArrayUtil;
import java.util.Collection;
import java.util.Map;

@Settings.Config(settingsIds={"com_liferay_document_library_web_portlet_DLPortlet", "com_liferay_document_library_web_portlet_DLAdminPortlet", "com_liferay_document_library_web_portlet_IGDisplayPortlet"})
public class DLPortletInstanceSettings {
    private static final String[] _MIME_TYPES_DEFAULT = ArrayUtil.toStringArray((Collection)DLUtil.getAllMediaGalleryMimeTypes());
    private final TypedSettings _typedSettings;

    public static DLPortletInstanceSettings getInstance(Layout layout, String portletId) throws PortalException {
        Settings settings = SettingsFactoryUtil.getSettings((SettingsLocator)new PortletInstanceSettingsLocator(layout, portletId));
        return new DLPortletInstanceSettings(settings);
    }

    public static DLPortletInstanceSettings getInstance(Layout layout, String portletId, Map<String, String[]> parameterMap) throws PortalException {
        Settings settings = SettingsFactoryUtil.getSettings((SettingsLocator)new PortletInstanceSettingsLocator(layout, portletId));
        ParameterMapSettings parameterMapSettings = new ParameterMapSettings(parameterMap, settings);
        return new DLPortletInstanceSettings((Settings)parameterMapSettings);
    }

    public static void registerSettingsMetadata() {
        SettingsFactoryUtil.registerSettingsMetadata(DLPortletInstanceSettings.class, null, (FallbackKeys)DLPortletInstanceSettings._getFallbackKeys());
    }

    public DLPortletInstanceSettings(Settings settings) {
        this._typedSettings = new TypedSettings(settings);
    }

    public String[] getDisplayViews() {
        return this._typedSettings.getValues("displayViews");
    }

    public int getEntriesPerPage() {
        return this._typedSettings.getIntegerValue("entriesPerPage");
    }

    public String[] getEntryColumns() {
        return this._typedSettings.getValues("entryColumns");
    }

    public int getFileEntriesPerPage() {
        return this._typedSettings.getIntegerValue("fileEntriesPerPage");
    }

    public String[] getFileEntryColumns() {
        return this._typedSettings.getValues("fileEntryColumns");
    }

    public String[] getFolderColumns() {
        return this._typedSettings.getValues("folderColumns");
    }

    public int getFoldersPerPage() {
        return this._typedSettings.getIntegerValue("foldersPerPage");
    }

    public String[] getMimeTypes() {
        return this._typedSettings.getValues("mimeTypes", _MIME_TYPES_DEFAULT);
    }

    public long getRootFolderId() {
        return this._typedSettings.getLongValue("rootFolderId", 0L);
    }

    public boolean isEnableCommentRatings() {
        return this._typedSettings.getBooleanValue("enableCommentRatings");
    }

    public boolean isEnableFileEntryDrafts() {
        return this._typedSettings.getBooleanValue("enableFileEntryDrafts");
    }

    public boolean isEnableRatings() {
        return this._typedSettings.getBooleanValue("enableRatings");
    }

    public boolean isEnableRelatedAssets() {
        return this._typedSettings.getBooleanValue("enableRelatedAssets");
    }

    public boolean isShowActions() {
        return this._typedSettings.getBooleanValue("showActions");
    }

    public boolean isShowFoldersSearch() {
        return this._typedSettings.getBooleanValue("showFoldersSearch");
    }

    public boolean isShowSubfolders() {
        return this._typedSettings.getBooleanValue("showSubfolders");
    }

    private static FallbackKeys _getFallbackKeys() {
        FallbackKeys fallbackKeys = new FallbackKeys();
        fallbackKeys.add("displayViews", new String[]{"dl.display.views"});
        fallbackKeys.add("enableCommentRatings", new String[]{"dl.comment.ratings.enabled"});
        fallbackKeys.add("enableFileEntryDrafts", new String[]{"dl.file.entry.drafts.enabled"});
        fallbackKeys.add("enableRatings", new String[]{"dl.ratings.enabled"});
        fallbackKeys.add("enableRelatedAssets", new String[]{"dl.related.assets.enabled"});
        fallbackKeys.add("entriesPerPage", new String[]{"search.container.page.default.delta"});
        fallbackKeys.add("entryColumns", new String[]{"dl.entry.columns"});
        fallbackKeys.add("fileEntryColumns", new String[]{"dl.file.entry.columns"});
        fallbackKeys.add("folderColumns", new String[]{"dl.folder.columns"});
        fallbackKeys.add("foldersPerPage", new String[]{"search.container.page.default.delta"});
        fallbackKeys.add("fileEntriesPerPage", new String[]{"search.container.page.default.delta"});
        fallbackKeys.add("showActions", new String[]{"dl.actions.visible"});
        fallbackKeys.add("showFoldersSearch", new String[]{"dl.folders.search.visible"});
        fallbackKeys.add("showSubfolders", new String[]{"dl.subfolders.visible"});
        return fallbackKeys;
    }

    static {
        SettingsFactoryUtil.registerSettingsMetadata(DLPortletInstanceSettings.class, null, (FallbackKeys)DLPortletInstanceSettings._getFallbackKeys());
    }
}

