/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.portlet.action;

import com.liferay.asset.display.page.portlet.AssetDisplayPageFriendlyURLProvider;
import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.exception.NoSuchFileVersionException;
import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.document.library.repository.authorization.capability.AuthorizationCapability;
import com.liferay.document.library.web.internal.portlet.action.GetFileEntryMVCRenderCommand;
import com.liferay.portal.kernel.exception.NoSuchRepositoryEntryException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCRenderCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCRenderConstants;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.RepositoryProviderUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import java.io.IOException;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_document_library_web_portlet_DLPortlet", "javax.portlet.name=com_liferay_document_library_web_portlet_DLAdminPortlet", "javax.portlet.name=com_liferay_document_library_web_portlet_IGDisplayPortlet", "mvc.command.name=/document_library/view_file_entry"}, service={MVCRenderCommand.class})
public class ViewFileEntryMVCRenderCommand
extends GetFileEntryMVCRenderCommand {
    @Reference
    private AssetDisplayPageFriendlyURLProvider _assetDisplayPageFriendlyURLProvider;
    @Reference
    private Portal _portal;

    @Override
    public String render(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException {
        try {
            long fileEntryId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"fileEntryId");
            Repository fileEntryRepository = RepositoryProviderUtil.getFileEntryRepository((long)fileEntryId);
            if (fileEntryRepository.isCapabilityProvided(AuthorizationCapability.class)) {
                AuthorizationCapability authorizationCapability = (AuthorizationCapability)fileEntryRepository.getCapability(AuthorizationCapability.class);
                authorizationCapability.authorize((PortletRequest)renderRequest, (PortletResponse)renderResponse);
                if (authorizationCapability.hasCustomRedirectFlow((PortletRequest)renderRequest, (PortletResponse)renderResponse)) {
                    return MVCRenderConstants.MVC_PATH_VALUE_SKIP_DISPATCH;
                }
            }
            ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            String assetDisplayPageFriendlyURL = this._assetDisplayPageFriendlyURLProvider.getFriendlyURL(DLFileEntryConstants.getClassName(), fileEntryId, themeDisplay);
            if (assetDisplayPageFriendlyURL != null) {
                HttpServletResponse httpServletResponse = this._portal.getHttpServletResponse((PortletResponse)renderResponse);
                httpServletResponse.sendRedirect(assetDisplayPageFriendlyURL);
                return MVCRenderConstants.MVC_PATH_VALUE_SKIP_DISPATCH;
            }
        }
        catch (NoSuchFileEntryException | NoSuchFileVersionException | NoSuchRepositoryEntryException | PrincipalException e) {
            SessionErrors.add((PortletRequest)renderRequest, e.getClass());
            return "/document_library/error.jsp";
        }
        catch (PortalException | IOException e) {
            throw new PortletException(e);
        }
        return super.render(renderRequest, renderResponse);
    }

    @Override
    protected String getPath() {
        return "/document_library/view_file_entry.jsp";
    }
}

