/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.portlet.action;

import com.liferay.document.library.kernel.document.conversion.DocumentConversionUtil;
import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLAppServiceUtil;
import com.liferay.document.library.kernel.service.DLFileEntryLocalServiceUtil;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.document.library.web.internal.security.permission.resource.DLFileEntryPermission;
import com.liferay.portal.kernel.flash.FlashMagicBytesUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GetFileActionHelper {
    public void processRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        try {
            long fileEntryId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"fileEntryId");
            long folderId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"folderId");
            String name = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"name");
            String title = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"title");
            String version = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"version");
            long fileShortcutId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"fileShortcutId");
            String uuid = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"uuid");
            String targetExtension = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"targetExtension");
            ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            long groupId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"groupId", (long)themeDisplay.getScopeGroupId());
            this.getFile(fileEntryId, folderId, name, title, version, fileShortcutId, uuid, groupId, targetExtension, httpServletRequest, httpServletResponse);
        }
        catch (NoSuchFileEntryException nsfee) {
            PortalUtil.sendError((int)404, (Exception)((Object)nsfee), (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
        }
        catch (PrincipalException pe) {
            this.processPrincipalException(pe, httpServletRequest, httpServletResponse);
        }
        catch (Exception e) {
            PortalUtil.sendError((Exception)e, (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
        }
    }

    protected void getFile(long fileEntryId, long folderId, String name, String title, String version, long fileShortcutId, String uuid, long groupId, String targetExtension, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        FlashMagicBytesUtil.Result flashMagicBytesUtilResult;
        String id;
        File convertedFile;
        if (name.startsWith("DLFE-")) {
            name = name.substring(5);
        }
        name = FileUtil.stripExtension((String)name);
        FileEntry fileEntry = null;
        if (Validator.isNotNull((String)uuid) && groupId > 0L) {
            fileEntry = DLAppServiceUtil.getFileEntryByUuidAndGroupId((String)uuid, (long)groupId);
            folderId = fileEntry.getFolderId();
        }
        if (fileEntryId > 0L) {
            fileEntry = DLAppServiceUtil.getFileEntry((long)fileEntryId);
        } else if (fileShortcutId <= 0L) {
            if (Validator.isNotNull((String)title)) {
                fileEntry = DLAppServiceUtil.getFileEntry((long)groupId, (long)folderId, (String)title);
            } else if (Validator.isNotNull((String)name)) {
                List dlFileEntries;
                DLFileEntry dlFileEntry = DLFileEntryLocalServiceUtil.fetchFileEntryByName((long)groupId, (long)folderId, (String)name);
                if (dlFileEntry == null && !(dlFileEntries = DLFileEntryLocalServiceUtil.getFileEntries((long)folderId, (String)name)).isEmpty()) {
                    dlFileEntry = (DLFileEntry)dlFileEntries.get(0);
                }
                if (dlFileEntry != null) {
                    ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                    PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
                    DLFileEntryPermission.check(permissionChecker, dlFileEntry, "VIEW");
                    fileEntry = new LiferayFileEntry(dlFileEntry);
                }
            }
        } else {
            FileShortcut fileShortcut = DLAppServiceUtil.getFileShortcut((long)fileShortcutId);
            fileEntryId = fileShortcut.getToFileEntryId();
            fileEntry = DLAppServiceUtil.getFileEntry((long)fileEntryId);
        }
        if (Validator.isNull((String)version)) {
            if (fileEntry != null && Validator.isNotNull((String)fileEntry.getVersion())) {
                version = fileEntry.getVersion();
            } else {
                throw new NoSuchFileEntryException("{fileEntryId=" + fileEntryId + "}");
            }
        }
        FileVersion fileVersion = fileEntry.getFileVersion(version);
        InputStream is = fileVersion.getContentStream(true);
        String fileName = fileVersion.getTitle();
        String sourceExtension = fileVersion.getExtension();
        if (Validator.isNotNull((String)sourceExtension) && !fileName.endsWith("." + sourceExtension)) {
            fileName = fileName + "." + sourceExtension;
        }
        long contentLength = fileVersion.getSize();
        String contentType = fileVersion.getMimeType();
        if (Validator.isNotNull((String)targetExtension) && (convertedFile = DocumentConversionUtil.convert((String)(id = DLUtil.getTempFileId((long)fileEntry.getFileEntryId(), (String)version)), (InputStream)is, (String)sourceExtension, (String)targetExtension)) != null) {
            fileName = FileUtil.stripExtension((String)fileName).concat(".").concat(targetExtension);
            is = new FileInputStream(convertedFile);
            contentLength = convertedFile.length();
            contentType = MimeTypesUtil.getContentType((String)fileName);
        }
        if ((flashMagicBytesUtilResult = FlashMagicBytesUtil.check((InputStream)is)).isFlash()) {
            fileName = FileUtil.stripExtension((String)fileName) + ".swf";
        }
        is = flashMagicBytesUtilResult.getInputStream();
        ServletResponseUtil.sendFile((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String)fileName, (InputStream)is, (long)contentLength, (String)contentType);
    }

    protected void processPrincipalException(Throwable t, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        User user = permissionChecker.getUser();
        if (user != null && !user.isDefaultUser()) {
            PortalUtil.sendError((int)401, (Exception)((Exception)t), (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
            return;
        }
        String redirect = PortalUtil.getPathMain() + "/portal/login";
        String currentURL = PortalUtil.getCurrentURL((HttpServletRequest)httpServletRequest);
        redirect = HttpUtil.addParameter((String)redirect, (String)"redirect", (String)currentURL);
        httpServletResponse.sendRedirect(redirect);
    }
}

