/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.portlet.action;

import com.liferay.asset.display.page.portlet.AssetDisplayPageEntryFormProcessor;
import com.liferay.asset.kernel.exception.AssetCategoryException;
import com.liferay.asset.kernel.exception.AssetTagException;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.document.library.configuration.DLConfiguration;
import com.liferay.document.library.kernel.antivirus.AntivirusScannerException;
import com.liferay.document.library.kernel.exception.DuplicateFileEntryException;
import com.liferay.document.library.kernel.exception.DuplicateFolderNameException;
import com.liferay.document.library.kernel.exception.FileEntryLockException;
import com.liferay.document.library.kernel.exception.FileExtensionException;
import com.liferay.document.library.kernel.exception.FileMimeTypeException;
import com.liferay.document.library.kernel.exception.FileNameException;
import com.liferay.document.library.kernel.exception.FileSizeException;
import com.liferay.document.library.kernel.exception.InvalidFileEntryTypeException;
import com.liferay.document.library.kernel.exception.InvalidFileVersionException;
import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.exception.NoSuchFolderException;
import com.liferay.document.library.kernel.exception.RequiredFileException;
import com.liferay.document.library.kernel.exception.SourceFileNameException;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLVersionNumberIncrease;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.kernel.service.DLTrashService;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.document.library.kernel.util.DLValidator;
import com.liferay.document.library.web.internal.settings.DLPortletInstanceSettings;
import com.liferay.dynamic.data.mapping.kernel.StorageFieldRequiredException;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.lock.DuplicateLockException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.portlet.JSONPortletResponseUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.repository.capabilities.TrashCapability;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.MultiSessionMessages;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.upload.LiferayFileItemException;
import com.liferay.portal.kernel.upload.UploadException;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.upload.UploadRequestSizeException;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TempFileEntryUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.trash.service.TrashEntryService;
import com.liferay.upload.UploadResponseHandler;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileUploadBase;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.document.library.configuration.DLConfiguration"}, property={"javax.portlet.name=com_liferay_document_library_web_portlet_DLPortlet", "javax.portlet.name=com_liferay_document_library_web_portlet_DLAdminPortlet", "javax.portlet.name=com_liferay_document_library_web_portlet_IGDisplayPortlet", "mvc.command.name=/document_library/edit_file_entry", "mvc.command.name=/document_library/upload_multiple_file_entries"}, service={MVCActionCommand.class})
public class EditFileEntryMVCActionCommand
extends BaseMVCActionCommand {
    public static final String TEMP_FOLDER_NAME = EditFileEntryMVCActionCommand.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(EditFileEntryMVCActionCommand.class);
    @Reference
    private AssetDisplayPageEntryFormProcessor _assetDisplayPageEntryFormProcessor;
    private DLAppService _dlAppService;
    private volatile DLConfiguration _dlConfiguration;
    private DLTrashService _dlTrashService;
    @Reference
    private DLValidator _dlValidator;
    @Reference
    private Http _http;
    @Reference(target="(upload.response.handler=multiple)")
    private UploadResponseHandler _multipleUploadResponseHandler;
    @Reference
    private Portal _portal;
    private TrashEntryService _trashEntryService;

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._dlConfiguration = (DLConfiguration)ConfigurableUtil.createConfigurable(DLConfiguration.class, properties);
    }

    protected void addMultipleFileEntries(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        JSONObject jsonObject;
        String fileName;
        String[] selectedFileNames;
        ArrayList<KeyValuePair> validFileNameKVPs = new ArrayList<KeyValuePair>();
        ArrayList<KeyValuePair> invalidFileNameKVPs = new ArrayList<KeyValuePair>();
        for (String selectedFileName : selectedFileNames = ParamUtil.getParameterValues((PortletRequest)actionRequest, (String)"selectedFileName", (String[])new String[0], (boolean)false)) {
            this.addMultipleFileEntries(portletConfig, actionRequest, actionResponse, selectedFileName, validFileNameKVPs, invalidFileNameKVPs);
        }
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (KeyValuePair validFileNameKVP : validFileNameKVPs) {
            fileName = validFileNameKVP.getKey();
            String originalFileName = validFileNameKVP.getValue();
            jsonObject = JSONUtil.put((String)"added", (Object)Boolean.TRUE).put("fileName", fileName).put("originalFileName", originalFileName);
            jsonArray.put(jsonObject);
        }
        for (KeyValuePair invalidFileNameKVP : invalidFileNameKVPs) {
            fileName = invalidFileNameKVP.getKey();
            String errorMessage = invalidFileNameKVP.getValue();
            jsonObject = JSONUtil.put((String)"added", (Object)Boolean.FALSE).put("errorMessage", errorMessage).put("fileName", fileName).put("originalFileName", fileName);
            jsonArray.put(jsonObject);
        }
        JSONPortletResponseUtil.writeJSON((PortletRequest)actionRequest, (PortletResponse)actionResponse, (Object)jsonArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMultipleFileEntries(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse, String selectedFileName, List<KeyValuePair> validFileNameKVPs, List<KeyValuePair> invalidFileNameKVPs) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long repositoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"repositoryId");
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        String changeLog = ParamUtil.getString((PortletRequest)actionRequest, (String)"changeLog");
        FileEntry tempFileEntry = null;
        try {
            tempFileEntry = TempFileEntryUtil.getTempFileEntry((long)themeDisplay.getScopeGroupId(), (long)themeDisplay.getUserId(), (String)TEMP_FOLDER_NAME, (String)selectedFileName);
            String originalSelectedFileName = TempFileEntryUtil.getOriginalTempFileName((String)tempFileEntry.getFileName());
            String uniqueFileName = DLUtil.getUniqueFileName((long)tempFileEntry.getGroupId(), (long)folderId, (String)originalSelectedFileName);
            String mimeType = tempFileEntry.getMimeType();
            InputStream inputStream = tempFileEntry.getContentStream();
            long size = tempFileEntry.getSize();
            ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DLFileEntry.class.getName(), (PortletRequest)actionRequest);
            FileEntry fileEntry = this._dlAppService.addFileEntry(repositoryId, folderId, uniqueFileName, mimeType, uniqueFileName, description, changeLog, inputStream, size, serviceContext);
            this._assetDisplayPageEntryFormProcessor.process(DLFileEntry.class.getName(), fileEntry.getFileEntryId(), (PortletRequest)actionRequest);
            validFileNameKVPs.add(new KeyValuePair(uniqueFileName, selectedFileName));
            return;
        }
        catch (Exception e) {
            String errorMessage = this.getAddMultipleFileEntriesErrorMessage(portletConfig, actionRequest, actionResponse, e);
            invalidFileNameKVPs.add(new KeyValuePair(selectedFileName, errorMessage));
        }
        finally {
            if (tempFileEntry != null) {
                TempFileEntryUtil.deleteTempFileEntry((long)tempFileEntry.getFileEntryId());
            }
        }
    }

    protected void addTempFileEntry(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        UploadPortletRequest uploadPortletRequest = this._portal.getUploadPortletRequest((PortletRequest)actionRequest);
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long folderId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"folderId");
        String sourceFileName = uploadPortletRequest.getFileName("file");
        try (InputStream inputStream = uploadPortletRequest.getFileAsStream("file");){
            String tempFileName = TempFileEntryUtil.getTempFileName((String)sourceFileName);
            String mimeType = uploadPortletRequest.getContentType("file");
            FileEntry fileEntry = this._dlAppService.addTempFileEntry(themeDisplay.getScopeGroupId(), folderId, TEMP_FOLDER_NAME, tempFileName, inputStream, mimeType);
            JSONObject jsonObject = this._multipleUploadResponseHandler.onSuccess(uploadPortletRequest, fileEntry);
            JSONPortletResponseUtil.writeJSON((PortletRequest)actionRequest, (PortletResponse)actionResponse, (Object)jsonObject);
        }
    }

    protected void cancelFileEntriesCheckOut(ActionRequest actionRequest) throws Exception {
        long fileEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"fileEntryId");
        if (fileEntryId > 0L) {
            this._dlAppService.cancelCheckOut(fileEntryId);
        } else {
            long[] fileEntryIds;
            for (long curFileEntryId : fileEntryIds = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIdsFileEntry")) {
                this._dlAppService.cancelCheckOut(curFileEntryId);
            }
        }
    }

    protected void checkInFileEntries(ActionRequest actionRequest) throws Exception {
        long fileEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"fileEntryId");
        DLVersionNumberIncrease dlVersionNumberIncrease = DLVersionNumberIncrease.valueOf((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"versionIncrease"), (DLVersionNumberIncrease)DLVersionNumberIncrease.AUTOMATIC);
        String changeLog = ParamUtil.getString((PortletRequest)actionRequest, (String)"changeLog");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)actionRequest);
        if (fileEntryId > 0L) {
            this._dlAppService.checkInFileEntry(fileEntryId, dlVersionNumberIncrease, changeLog, serviceContext);
        } else {
            long[] fileEntryIds;
            for (long curFileEntryId : fileEntryIds = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIdsFileEntry")) {
                this._dlAppService.checkInFileEntry(curFileEntryId, dlVersionNumberIncrease, changeLog, serviceContext);
            }
        }
    }

    protected void checkOutFileEntries(ActionRequest actionRequest) throws Exception {
        long fileEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"fileEntryId");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)actionRequest);
        if (fileEntryId > 0L) {
            this._dlAppService.checkOutFileEntry(fileEntryId, serviceContext);
        } else {
            long[] fileEntryIds;
            for (long curFileEntryId : fileEntryIds = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIdsFileEntry")) {
                this._dlAppService.checkOutFileEntry(curFileEntryId, serviceContext);
            }
        }
    }

    protected void deleteFileEntry(ActionRequest actionRequest, boolean moveToTrash) throws Exception {
        long fileEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"fileEntryId");
        if (fileEntryId == 0L) {
            return;
        }
        String version = ParamUtil.getString((PortletRequest)actionRequest, (String)"version");
        if (Validator.isNotNull((String)version)) {
            this._dlAppService.deleteFileVersion(fileEntryId, version);
            return;
        }
        if (!moveToTrash) {
            this._dlAppService.deleteFileEntry(fileEntryId);
            return;
        }
        FileEntry fileEntry = this._dlAppService.getFileEntry(fileEntryId);
        if (!fileEntry.isRepositoryCapabilityProvided(TrashCapability.class)) {
            this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
            return;
        }
        fileEntry = this._dlTrashService.moveFileEntryToTrash(fileEntryId);
        ArrayList<TrashedModel> trashedModels = new ArrayList<TrashedModel>();
        trashedModels.add((TrashedModel)fileEntry.getModel());
        HashMap<String, ArrayList<TrashedModel>> data = new HashMap<String, ArrayList<TrashedModel>>();
        data.put("trashedModels", trashedModels);
        this.addDeleteSuccessData((PortletRequest)actionRequest, data);
    }

    protected void deleteTempFileEntry(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        String fileName = ParamUtil.getString((PortletRequest)actionRequest, (String)"fileName");
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        try {
            this._dlAppService.deleteTempFileEntry(themeDisplay.getScopeGroupId(), folderId, TEMP_FOLDER_NAME, fileName);
            jsonObject.put("deleted", (Object)Boolean.TRUE);
        }
        catch (Exception e) {
            String errorMessage = themeDisplay.translate("an-unexpected-error-occurred-while-deleting-the-file");
            jsonObject.put("deleted", (Object)Boolean.FALSE).put("errorMessage", errorMessage);
        }
        JSONPortletResponseUtil.writeJSON((PortletRequest)actionRequest, (PortletResponse)actionResponse, (Object)jsonObject);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        FileEntry fileEntry = null;
        PortletConfig portletConfig = this.getPortletConfig((PortletRequest)actionRequest);
        try {
            block36: {
                block35: {
                    UploadException uploadException = (UploadException)actionRequest.getAttribute("UPLOAD_EXCEPTION");
                    if (uploadException == null) break block35;
                    Throwable cause = uploadException.getCause();
                    if (cmd.equals("add_temp")) {
                        if (cause instanceof FileUploadBase.IOFileUploadException && _log.isInfoEnabled()) {
                            _log.info((Object)"Temporary upload was cancelled");
                        }
                        break block36;
                    } else {
                        if (uploadException.isExceededFileSizeLimit()) {
                            throw new FileSizeException(cause);
                        }
                        if (uploadException.isExceededLiferayFileItemSizeLimit()) {
                            throw new LiferayFileItemException(cause);
                        }
                        if (!uploadException.isExceededUploadRequestSizeLimit()) throw new PortalException(cause);
                        throw new UploadRequestSizeException(cause);
                    }
                }
                if (cmd.equals("add") || cmd.equals("add_dynamic") || cmd.equals("update") || cmd.equals("update_and_checkin")) {
                    UploadPortletRequest uploadPortletRequest = this._portal.getUploadPortletRequest((PortletRequest)actionRequest);
                    String sourceFileName = uploadPortletRequest.getFileName("file");
                    try {
                        fileEntry = this.updateFileEntry(portletConfig, actionRequest, actionResponse, uploadPortletRequest);
                    }
                    catch (Exception e) {
                        if (cmd.equals("add_dynamic")) throw e;
                        if (!Validator.isNotNull((String)sourceFileName)) throw e;
                        SessionErrors.add((PortletRequest)actionRequest, RequiredFileException.class);
                        throw e;
                    }
                } else if (cmd.equals("add_multiple")) {
                    this.addMultipleFileEntries(portletConfig, actionRequest, actionResponse);
                } else if (cmd.equals("add_temp")) {
                    this.addTempFileEntry(actionRequest, actionResponse);
                } else if (cmd.equals("delete")) {
                    this.deleteFileEntry(actionRequest, false);
                } else if (cmd.equals("delete_temp")) {
                    this.deleteTempFileEntry(actionRequest, actionResponse);
                } else if (cmd.equals("cancel_checkout")) {
                    this.cancelFileEntriesCheckOut(actionRequest);
                } else if (cmd.equals("checkin")) {
                    this.checkInFileEntries(actionRequest);
                } else if (cmd.equals("checkout")) {
                    this.checkOutFileEntries(actionRequest);
                } else if (cmd.equals("move_to_trash")) {
                    this.deleteFileEntry(actionRequest, true);
                } else if (cmd.equals("restore")) {
                    this.restoreTrashEntries(actionRequest);
                } else if (cmd.equals("revert")) {
                    this.revertFileEntry(actionRequest);
                }
            }
            if (cmd.equals("add_temp") || cmd.equals("delete_temp")) {
                actionResponse.setRenderParameter("mvcPath", "/null.jsp");
                return;
            }
            if (cmd.equals("preview")) {
                SessionMessages.add((PortletRequest)actionRequest, (String)(this._portal.getPortletId((PortletRequest)actionRequest) + ".forceSendRedirect"));
                this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
                actionResponse.setRenderParameter("mvcRenderCommandName", "/document_library/edit_file_entry");
                return;
            }
            String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
            int workflowAction = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"workflowAction", (int)2);
            if (fileEntry != null && workflowAction == 2) {
                redirect = this.getSaveAndContinueRedirect(portletConfig, actionRequest, fileEntry, redirect);
                this.sendRedirect(actionRequest, actionResponse, redirect);
                return;
            }
            redirect = this._portal.escapeRedirect(ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
            if (!Validator.isNotNull((String)redirect)) return;
            if (cmd.equals("add") && fileEntry != null) {
                String portletResource = this._http.getParameter(redirect, "portletResource", false);
                String namespace = this._portal.getPortletNamespace(portletResource);
                if (Validator.isNotNull((String)portletResource)) {
                    redirect = this._http.addParameter(redirect, namespace + "className", DLFileEntry.class.getName());
                    redirect = this._http.addParameter(redirect, namespace + "classPK", fileEntry.getFileEntryId());
                }
            }
            actionRequest.setAttribute("REDIRECT", (Object)redirect);
            return;
        }
        catch (Exception e) {
            this.handleUploadException(portletConfig, actionRequest, actionResponse, cmd, e);
        }
    }

    protected String getAddMultipleFileEntriesErrorMessage(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse, Exception e) throws Exception {
        String errorMessage = null;
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (e instanceof AntivirusScannerException) {
            AntivirusScannerException ase = (AntivirusScannerException)e;
            errorMessage = themeDisplay.translate(ase.getMessageKey());
        } else if (e instanceof AssetCategoryException) {
            AssetCategoryException ace = (AssetCategoryException)((Object)e);
            AssetVocabulary assetVocabulary = ace.getVocabulary();
            String vocabularyTitle = "";
            if (assetVocabulary != null) {
                vocabularyTitle = assetVocabulary.getTitle(themeDisplay.getLocale());
            }
            if (ace.getType() == 1) {
                errorMessage = themeDisplay.translate("please-select-at-least-one-category-for-x", new Object[]{vocabularyTitle});
            } else if (ace.getType() == 2) {
                errorMessage = themeDisplay.translate("you-cannot-select-more-than-one-category-for-x", new Object[]{vocabularyTitle});
            }
        } else {
            errorMessage = e instanceof DuplicateFileEntryException ? themeDisplay.translate("the-folder-you-selected-already-has-an-entry-with-this-name.-please-select-a-different-folder") : (e instanceof FileExtensionException ? themeDisplay.translate("please-enter-a-file-with-a-valid-extension-x", new Object[]{StringUtil.merge((Object[])this.getAllowedFileExtensions(portletConfig, (PortletRequest)actionRequest, (PortletResponse)actionResponse))}) : (e instanceof FileNameException ? themeDisplay.translate("please-enter-a-file-with-a-valid-file-name") : (e instanceof FileSizeException ? themeDisplay.translate("please-enter-a-file-with-a-valid-file-size-no-larger-than-x", new Object[]{TextFormatter.formatStorageSize((double)this._dlValidator.getMaxAllowableSize(), (Locale)themeDisplay.getLocale())}) : (e instanceof InvalidFileEntryTypeException ? themeDisplay.translate("the-document-type-you-selected-is-not-valid-for-this-folder") : themeDisplay.translate("an-unexpected-error-occurred-while-saving-your-document")))));
        }
        return errorMessage;
    }

    protected String[] getAllowedFileExtensions(PortletConfig portletConfig, PortletRequest portletRequest, PortletResponse portletResponse) throws PortalException {
        String[] mimeTypes;
        String portletName = portletConfig.getPortletName();
        if (!portletName.equals("com_liferay_document_library_web_portlet_IGDisplayPortlet")) {
            return this._dlConfiguration.fileExtensions();
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        DLPortletInstanceSettings dlPortletInstanceSettings = DLPortletInstanceSettings.getInstance(themeDisplay.getLayout(), portletDisplay.getId());
        HashSet extensions = new HashSet();
        for (String mimeType : mimeTypes = dlPortletInstanceSettings.getMimeTypes()) {
            extensions.addAll(MimeTypesUtil.getExtensions((String)mimeType));
        }
        return extensions.toArray(new String[0]);
    }

    protected String getSaveAndContinueRedirect(PortletConfig portletConfig, ActionRequest actionRequest, FileEntry fileEntry, String redirect) throws Exception {
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)actionRequest, (String)portletConfig.getPortletName(), (String)"RENDER_PHASE");
        portletURL.setParameter("mvcRenderCommandName", "/document_library/edit_file_entry");
        portletURL.setParameter("cmd", "update", false);
        portletURL.setParameter("redirect", redirect, false);
        portletURL.setParameter("groupId", String.valueOf(fileEntry.getGroupId()), false);
        portletURL.setParameter("fileEntryId", String.valueOf(fileEntry.getFileEntryId()), false);
        portletURL.setParameter("version", String.valueOf(fileEntry.getVersion()), false);
        portletURL.setWindowState(actionRequest.getWindowState());
        return portletURL.toString();
    }

    protected void handleUploadException(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse, String cmd, Exception e) throws Exception {
        if (e instanceof AssetCategoryException || e instanceof AssetTagException) {
            SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
        } else if (e instanceof AntivirusScannerException || e instanceof DuplicateFileEntryException || e instanceof DuplicateFolderNameException || e instanceof FileExtensionException || e instanceof FileMimeTypeException || e instanceof FileNameException || e instanceof FileSizeException || e instanceof LiferayFileItemException || e instanceof NoSuchFolderException || e instanceof SourceFileNameException || e instanceof StorageFieldRequiredException || e instanceof UploadRequestSizeException) {
            if (!(cmd.equals("add_dynamic") || cmd.equals("add_multiple") || cmd.equals("add_temp"))) {
                if (e instanceof AntivirusScannerException) {
                    SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
                } else {
                    SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                }
                return;
            }
            if (cmd.equals("add_temp")) {
                this.hideDefaultErrorMessage((PortletRequest)actionRequest);
            }
            if (e instanceof AntivirusScannerException || e instanceof DuplicateFileEntryException || e instanceof FileExtensionException || e instanceof FileNameException || e instanceof FileSizeException || e instanceof UploadRequestSizeException) {
                JSONObject jsonObject = this._multipleUploadResponseHandler.onFailure((PortletRequest)actionRequest, (PortalException)((Object)e));
                JSONPortletResponseUtil.writeJSON((PortletRequest)actionRequest, (PortletResponse)actionResponse, (Object)jsonObject);
            }
            if (e instanceof AntivirusScannerException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
            } else {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
        } else if (e instanceof DuplicateLockException || e instanceof FileEntryLockException.MustOwnLock || e instanceof InvalidFileVersionException || e instanceof NoSuchFileEntryException || e instanceof PrincipalException) {
            if (e instanceof DuplicateLockException) {
                DuplicateLockException dle = (DuplicateLockException)((Object)e);
                SessionErrors.add((PortletRequest)actionRequest, ((Object)((Object)dle)).getClass(), (Object)dle.getLock());
            } else {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
            actionResponse.setRenderParameter("mvcPath", "/document_library/error.jsp");
        } else {
            Throwable cause = e.getCause();
            if (cause instanceof DuplicateFileEntryException) {
                SessionErrors.add((PortletRequest)actionRequest, DuplicateFileEntryException.class);
            } else {
                throw e;
            }
        }
    }

    protected void restoreTrashEntries(ActionRequest actionRequest) throws Exception {
        long[] restoreTrashEntryIds;
        for (long restoreTrashEntryId : restoreTrashEntryIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"restoreTrashEntryIds"), (long)0L)) {
            this._trashEntryService.restoreEntry(restoreTrashEntryId);
        }
    }

    protected void revertFileEntry(ActionRequest actionRequest) throws Exception {
        long fileEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"fileEntryId");
        String version = ParamUtil.getString((PortletRequest)actionRequest, (String)"version");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DLFileEntry.class.getName(), (PortletRequest)actionRequest);
        this._dlAppService.revertFileEntry(fileEntryId, version, serviceContext);
    }

    @Reference(unbind="-")
    protected void setDLAppService(DLAppService dlAppService) {
        this._dlAppService = dlAppService;
    }

    @Reference(unbind="-")
    protected void setDLTrashService(DLTrashService dlTrashService) {
        this._dlTrashService = dlTrashService;
    }

    @Reference(unbind="-")
    protected void setTrashEntryService(TrashEntryService trashEntryService) {
        this._trashEntryService = trashEntryService;
    }

    protected FileEntry updateFileEntry(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse, UploadPortletRequest uploadPortletRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String cmd = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"cmd");
        long fileEntryId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"fileEntryId");
        long repositoryId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"repositoryId");
        long folderId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"folderId");
        String sourceFileName = uploadPortletRequest.getFileName("file");
        String title = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"title");
        String description = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"description");
        String changeLog = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"changeLog");
        DLVersionNumberIncrease dlVersionNumberIncrease = DLVersionNumberIncrease.valueOf((String)ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"versionIncrease"), (DLVersionNumberIncrease)DLVersionNumberIncrease.AUTOMATIC);
        boolean updateVersionDetails = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"updateVersionDetails");
        if (!updateVersionDetails) {
            dlVersionNumberIncrease = DLVersionNumberIncrease.AUTOMATIC;
        }
        if (cmd.equals("add_dynamic")) {
            title = uploadPortletRequest.getFileName("file");
        }
        try (InputStream inputStream = uploadPortletRequest.getFileAsStream("file");){
            String portletName;
            String contentType = uploadPortletRequest.getContentType("file");
            long size = uploadPortletRequest.getSize("file");
            if ((cmd.equals("add") || cmd.equals("add_dynamic")) && size == 0L) {
                contentType = MimeTypesUtil.getContentType((String)title);
            }
            if ((cmd.equals("add") || cmd.equals("add_dynamic") || size > 0L) && (portletName = portletConfig.getPortletName()).equals("com_liferay_document_library_web_portlet_IGDisplayPortlet")) {
                PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
                DLPortletInstanceSettings dlPortletInstanceSettings = DLPortletInstanceSettings.getInstance(themeDisplay.getLayout(), portletDisplay.getId());
                Object[] mimeTypes = dlPortletInstanceSettings.getMimeTypes();
                if (Arrays.binarySearch(mimeTypes, contentType) < 0) {
                    throw new FileMimeTypeException(contentType);
                }
            }
            ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DLFileEntry.class.getName(), (UploadPortletRequest)uploadPortletRequest);
            FileEntry fileEntry = null;
            if (cmd.equals("add") || cmd.equals("add_dynamic")) {
                fileEntry = this._dlAppService.addFileEntry(repositoryId, folderId, sourceFileName, contentType, title, description, changeLog, inputStream, size, serviceContext);
                if (cmd.equals("add_dynamic")) {
                    JSONObject jsonObject = JSONUtil.put((String)"fileEntryId", (Object)fileEntry.getFileEntryId());
                    JSONPortletResponseUtil.writeJSON((PortletRequest)actionRequest, (PortletResponse)actionResponse, (Object)jsonObject);
                }
            } else {
                fileEntry = cmd.equals("update_and_checkin") ? this._dlAppService.updateFileEntryAndCheckIn(fileEntryId, sourceFileName, contentType, title, description, changeLog, dlVersionNumberIncrease, inputStream, size, serviceContext) : this._dlAppService.updateFileEntry(fileEntryId, sourceFileName, contentType, title, description, changeLog, dlVersionNumberIncrease, inputStream, size, serviceContext);
            }
            this._assetDisplayPageEntryFormProcessor.process(DLFileEntry.class.getName(), fileEntry.getFileEntryId(), (PortletRequest)actionRequest);
            String portletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletResource");
            if (Validator.isNotNull((String)portletResource)) {
                MultiSessionMessages.add((PortletRequest)actionRequest, (String)(portletResource + "requestProcessed"));
            }
            FileEntry fileEntry2 = fileEntry;
            return fileEntry2;
        }
    }
}

