/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.portlet.action;

import com.liferay.asset.kernel.exception.AssetCategoryException;
import com.liferay.asset.kernel.exception.AssetTagException;
import com.liferay.bulk.selection.BulkSelection;
import com.liferay.bulk.selection.BulkSelectionFactory;
import com.liferay.document.library.kernel.exception.DuplicateFileEntryException;
import com.liferay.document.library.kernel.exception.DuplicateFolderNameException;
import com.liferay.document.library.kernel.exception.InvalidFolderException;
import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.exception.NoSuchFolderException;
import com.liferay.document.library.kernel.exception.SourceFileNameException;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLVersionNumberIncrease;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.kernel.service.DLTrashService;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lock.DuplicateLockException;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.trash.service.TrashEntryService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_document_library_web_portlet_DLPortlet", "javax.portlet.name=com_liferay_document_library_web_portlet_DLAdminPortlet", "javax.portlet.name=com_liferay_document_library_web_portlet_IGDisplayPortlet", "mvc.command.name=/document_library/edit_entry", "mvc.command.name=/document_library/move_entry"}, service={MVCActionCommand.class})
public class EditEntryMVCActionCommand
extends BaseMVCActionCommand {
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private DLTrashService _dlTrashService;
    @Reference(target="(model.class.name=com.liferay.document.library.kernel.model.DLFileEntry)")
    private BulkSelectionFactory<FileEntry> _fileEntryBulkSelectionFactory;
    @Reference(target="(model.class.name=com.liferay.document.library.kernel.model.DLFileShortcut)")
    private BulkSelectionFactory<FileShortcut> _fileShortcutBulkSelectionFactory;
    @Reference(target="(model.class.name=com.liferay.document.library.kernel.model.DLFolder)")
    private BulkSelectionFactory<Folder> _folderBulkSelectionFactory;
    @Reference
    private Portal _portal;
    @Reference
    private TrashEntryService _trashEntryService;

    protected void cancelCheckedOutEntries(ActionRequest actionRequest) throws Exception {
        long[] fileEntryIds;
        for (long fileEntryId : fileEntryIds = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIdsFileEntry")) {
            this._dlAppService.cancelCheckOut(fileEntryId);
        }
    }

    protected void checkInEntries(ActionRequest actionRequest) throws Exception {
        long[] fileShortcutIds;
        long[] fileEntryIds = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIdsFileEntry");
        DLVersionNumberIncrease dlVersionNumberIncrease = DLVersionNumberIncrease.valueOf((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"versionIncrease"), (DLVersionNumberIncrease)DLVersionNumberIncrease.MINOR);
        String changeLog = ParamUtil.getString((PortletRequest)actionRequest, (String)"changeLog");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)actionRequest);
        for (long fileEntryId : fileEntryIds) {
            this._dlAppService.checkInFileEntry(fileEntryId, dlVersionNumberIncrease, changeLog, serviceContext);
        }
        for (long fileShortcutId : fileShortcutIds = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIdsDLFileShortcut")) {
            FileShortcut fileShortcut = this._dlAppService.getFileShortcut(fileShortcutId);
            long toFileEntryId = fileShortcut.getToFileEntryId();
            if (ArrayUtil.contains((long[])fileEntryIds, (long)toFileEntryId)) continue;
            this._dlAppService.checkInFileEntry(toFileEntryId, dlVersionNumberIncrease, changeLog, serviceContext);
        }
    }

    protected void checkOutEntries(ActionRequest actionRequest) throws Exception {
        long[] fileShortcutIds;
        long[] fileEntryIds = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIdsFileEntry");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)actionRequest);
        for (long fileEntryId : fileEntryIds) {
            this._dlAppService.checkOutFileEntry(fileEntryId, serviceContext);
        }
        for (long fileShortcutId : fileShortcutIds = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIdsDLFileShortcut")) {
            FileShortcut fileShortcut = this._dlAppService.getFileShortcut(fileShortcutId);
            long toFileEntryId = fileShortcut.getToFileEntryId();
            if (ArrayUtil.contains((long[])fileEntryIds, (long)toFileEntryId)) continue;
            this._dlAppService.checkOutFileEntry(toFileEntryId, serviceContext);
        }
    }

    protected void deleteEntries(ActionRequest actionRequest, boolean moveToTrash) throws Exception {
        ArrayList trashedModels = new ArrayList();
        BulkSelection folderBulkSelection = this._folderBulkSelectionFactory.create(actionRequest.getParameterMap());
        folderBulkSelection.forEach(folder -> this._deleteFolder((Folder)folder, moveToTrash, trashedModels));
        BulkSelection fileShortcutBulkSelection = this._fileShortcutBulkSelectionFactory.create(actionRequest.getParameterMap());
        fileShortcutBulkSelection.forEach(fileShortcut -> this._deleteFileShortcut((FileShortcut)fileShortcut, moveToTrash, trashedModels));
        BulkSelection fileEntryBulkSelection = this._fileEntryBulkSelectionFactory.create(actionRequest.getParameterMap());
        fileEntryBulkSelection.forEach(fileEntry -> this._deleteFileEntry((FileEntry)fileEntry, moveToTrash, trashedModels));
        if (moveToTrash && !trashedModels.isEmpty()) {
            HashMap data = new HashMap();
            data.put("trashedModels", trashedModels);
            this.addDeleteSuccessData((PortletRequest)actionRequest, data);
        }
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            String redirect;
            if (cmd.equals("cancel_checkout")) {
                this.cancelCheckedOutEntries(actionRequest);
            } else if (cmd.equals("checkin")) {
                this.checkInEntries(actionRequest);
            } else if (cmd.equals("checkout")) {
                this.checkOutEntries(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteEntries(actionRequest, false);
            } else if (cmd.equals("move")) {
                this.moveEntries(actionRequest);
            } else if (cmd.equals("move_to_trash")) {
                this.deleteEntries(actionRequest, true);
            } else if (cmd.equals("restore")) {
                this.restoreTrashEntries(actionRequest);
            }
            WindowState windowState = actionRequest.getWindowState();
            if (windowState.equals((Object)LiferayWindowState.POP_UP) && Validator.isNotNull((String)(redirect = this._portal.escapeRedirect(ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"))))) {
                this.sendRedirect(actionRequest, actionResponse, redirect);
            }
        }
        catch (NoSuchFileEntryException | NoSuchFolderException | DuplicateLockException | PrincipalException e) {
            if (e instanceof DuplicateLockException) {
                DuplicateLockException dle = (DuplicateLockException)e;
                SessionErrors.add((PortletRequest)actionRequest, ((Object)((Object)dle)).getClass(), (Object)dle.getLock());
            } else {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
            actionResponse.setRenderParameter("mvcPath", "/document_library/error.jsp");
        }
        catch (DuplicateFileEntryException | DuplicateFolderNameException | SourceFileNameException e) {
            if (e instanceof DuplicateFileEntryException) {
                HttpServletResponse httpServletResponse = this._portal.getHttpServletResponse((PortletResponse)actionResponse);
                httpServletResponse.setStatus(490);
            }
            SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
        }
        catch (AssetCategoryException | AssetTagException | InvalidFolderException e) {
            SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    protected void moveEntries(ActionRequest actionRequest) throws Exception {
        long newFolderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"newFolderId");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DLFileEntry.class.getName(), (PortletRequest)actionRequest);
        BulkSelection folderBulkSelection = this._folderBulkSelectionFactory.create(actionRequest.getParameterMap());
        folderBulkSelection.forEach(folder -> this._dlAppService.moveFolder(folder.getFolderId(), newFolderId, serviceContext));
        BulkSelection fileEntryBulkSelection = this._fileEntryBulkSelectionFactory.create(actionRequest.getParameterMap());
        fileEntryBulkSelection.forEach(fileEntry -> this._dlAppService.moveFileEntry(fileEntry.getFileEntryId(), newFolderId, serviceContext));
        BulkSelection fileShortcutBulkSelection = this._fileShortcutBulkSelectionFactory.create(actionRequest.getParameterMap());
        fileShortcutBulkSelection.forEach(fileShortcut -> this._dlAppService.updateFileShortcut(fileShortcut.getFileShortcutId(), newFolderId, fileShortcut.getToFileEntryId(), serviceContext));
    }

    protected void restoreTrashEntries(ActionRequest actionRequest) throws Exception {
        long[] restoreTrashEntryIds;
        for (long restoreTrashEntryId : restoreTrashEntryIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"restoreTrashEntryIds"), (long)0L)) {
            this._trashEntryService.restoreEntry(restoreTrashEntryId);
        }
    }

    private void _deleteFileEntry(FileEntry fileEntry, boolean moveToTrash, List<TrashedModel> trashedModels) {
        try {
            if (moveToTrash) {
                this._dlTrashService.moveFileEntryToTrash(fileEntry.getFileEntryId());
                if (fileEntry.getModel() instanceof TrashedModel) {
                    trashedModels.add((TrashedModel)fileEntry.getModel());
                }
            } else {
                this._dlAppService.deleteFileEntry(fileEntry.getFileEntryId());
            }
        }
        catch (PortalException pe) {
            ReflectionUtil.throwException((Throwable)pe);
        }
    }

    private void _deleteFileShortcut(FileShortcut fileShortcut, boolean moveToTrash, List<TrashedModel> trashedModels) {
        try {
            if (moveToTrash) {
                if ((fileShortcut = this._dlTrashService.moveFileShortcutToTrash(fileShortcut.getFileShortcutId())).getModel() instanceof TrashedModel) {
                    trashedModels.add((TrashedModel)fileShortcut.getModel());
                }
            } else {
                this._dlAppService.deleteFileShortcut(fileShortcut.getFileShortcutId());
            }
        }
        catch (PortalException pe) {
            ReflectionUtil.throwException((Throwable)pe);
        }
    }

    private void _deleteFolder(Folder folder, boolean moveToTrash, List<TrashedModel> trashedModels) {
        try {
            if (moveToTrash) {
                if (folder.isMountPoint()) {
                    return;
                }
                if ((folder = this._dlTrashService.moveFolderToTrash(folder.getFolderId())).getModel() instanceof TrashedModel) {
                    trashedModels.add((TrashedModel)folder.getModel());
                }
            } else {
                this._dlAppService.deleteFolder(folder.getFolderId());
            }
        }
        catch (PortalException pe) {
            ReflectionUtil.throwException((Throwable)pe);
        }
    }
}

