/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.info.display.contributor;

import com.liferay.asset.info.display.contributor.BaseAssetInfoDisplayContributor;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.ClassType;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.info.display.contributor.InfoDisplayContributor;
import com.liferay.info.display.contributor.InfoDisplayField;
import com.liferay.info.display.contributor.InfoDisplayObjectProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.RepositoryProvider;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={InfoDisplayContributor.class})
public class DLFileEntryInfoDisplayContributor
implements InfoDisplayContributor<FileEntry> {
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private DLAppLocalService _dlAppLocalService;
    private final DLFileEntryAssetInfoDisplayContributor _dlFileEntryAssetInfoDisplayContributor = new DLFileEntryAssetInfoDisplayContributor();
    @Reference
    private RepositoryProvider _repositoryProvider;

    public String getClassName() {
        return this._dlFileEntryAssetInfoDisplayContributor.getClassName();
    }

    public List<InfoDisplayField> getClassTypeInfoDisplayFields(long classTypeId, Locale locale) throws PortalException {
        return this._dlFileEntryAssetInfoDisplayContributor.getClassTypeInfoDisplayFields(classTypeId, locale);
    }

    public List<ClassType> getClassTypes(long groupId, Locale locale) throws PortalException {
        return this._dlFileEntryAssetInfoDisplayContributor.getClassTypes(groupId, locale);
    }

    public Set<InfoDisplayField> getInfoDisplayFields(long classTypeId, Locale locale) throws PortalException {
        return this._dlFileEntryAssetInfoDisplayContributor.getInfoDisplayFields(classTypeId, locale);
    }

    public Map<String, Object> getInfoDisplayFieldsValues(FileEntry fileEntry, Locale locale) throws PortalException {
        AssetEntry assetEntry = this._getAssetEntry(fileEntry);
        return this._dlFileEntryAssetInfoDisplayContributor.getInfoDisplayFieldsValues(assetEntry, locale);
    }

    public Object getInfoDisplayFieldValue(FileEntry fileEntry, String fieldName, Locale locale) throws PortalException {
        AssetEntry assetEntry = this._getAssetEntry(fileEntry);
        return this._dlFileEntryAssetInfoDisplayContributor.getInfoDisplayFieldValue(assetEntry, fieldName, locale);
    }

    public InfoDisplayObjectProvider getInfoDisplayObjectProvider(final long classPK) throws PortalException {
        LocalRepository localRepository = this._repositoryProvider.fetchFileEntryLocalRepository(classPK);
        if (localRepository == null) {
            return null;
        }
        final FileEntry fileEntry = localRepository.getFileEntry(classPK);
        return new InfoDisplayObjectProvider<FileEntry>(){

            public long getClassNameId() {
                return DLFileEntryInfoDisplayContributor.this._classNameLocalService.getClassNameId(DLFileEntryInfoDisplayContributor.this.getClassName());
            }

            public long getClassPK() {
                return classPK;
            }

            public long getClassTypeId() {
                InfoDisplayObjectProvider infoDisplayObjectProvider = DLFileEntryInfoDisplayContributor.this._dlFileEntryAssetInfoDisplayContributor.getInfoDisplayObjectProvider(classPK);
                if (infoDisplayObjectProvider != null) {
                    return infoDisplayObjectProvider.getClassTypeId();
                }
                return 0L;
            }

            public String getDescription(Locale locale) {
                return fileEntry.getDescription();
            }

            public FileEntry getDisplayObject() {
                return fileEntry;
            }

            public long getGroupId() {
                return fileEntry.getGroupId();
            }

            public String getKeywords(Locale locale) {
                InfoDisplayObjectProvider infoDisplayObjectProvider = DLFileEntryInfoDisplayContributor.this._dlFileEntryAssetInfoDisplayContributor.getInfoDisplayObjectProvider(classPK);
                if (infoDisplayObjectProvider != null) {
                    return infoDisplayObjectProvider.getKeywords(locale);
                }
                return "";
            }

            public String getTitle(Locale locale) {
                return fileEntry.getTitle();
            }

            public String getURLTitle(Locale locale) {
                return String.valueOf(classPK);
            }
        };
    }

    public InfoDisplayObjectProvider getInfoDisplayObjectProvider(long groupId, String urlTitle) throws PortalException {
        return this.getInfoDisplayObjectProvider(Long.valueOf(urlTitle));
    }

    public String getInfoURLSeparator() {
        return this._dlFileEntryAssetInfoDisplayContributor.getInfoURLSeparator();
    }

    public String getLabel(Locale locale) {
        return this._dlFileEntryAssetInfoDisplayContributor.getLabel(locale);
    }

    private AssetEntry _getAssetEntry(FileEntry fileEntry) {
        AssetEntry assetEntry = this._assetEntryLocalService.fetchEntry(this.getClassName(), fileEntry.getFileEntryId());
        if (assetEntry == null) {
            assetEntry = this._assetEntryLocalService.createAssetEntry(fileEntry.getFileEntryId());
            assetEntry.setGroupId(fileEntry.getGroupId());
            assetEntry.setCompanyId(fileEntry.getCompanyId());
            assetEntry.setUserId(fileEntry.getUserId());
            assetEntry.setCreateDate(fileEntry.getCreateDate());
            assetEntry.setClassNameId(this._classNameLocalService.getClassNameId(this.getClassName()));
            assetEntry.setClassPK(fileEntry.getFileEntryId());
            assetEntry.setPublishDate(fileEntry.getModifiedDate());
            assetEntry.setTitle(fileEntry.getTitle());
            assetEntry.setDescription(fileEntry.getDescription());
        }
        return assetEntry;
    }

    private class DLFileEntryAssetInfoDisplayContributor
    extends BaseAssetInfoDisplayContributor<FileEntry> {
        private DLFileEntryAssetInfoDisplayContributor() {
        }

        public String getClassName() {
            return DLFileEntryConstants.getClassName();
        }

        public String getInfoURLSeparator() {
            return "/d/";
        }

        protected Map<String, Object> getClassTypeValues(FileEntry fileEntry, Locale locale) {
            return new HashMap<String, Object>();
        }
    }
}

