/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.display.context.logic;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.web.internal.security.permission.resource.DLFileEntryPermission;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;

public class FileEntryDisplayContextHelper {
    private Boolean _checkedOut;
    private Boolean _dlFileEntry;
    private final FileEntry _fileEntry;
    private Boolean _hasDeletePermission;
    private Boolean _hasExportImportPermission;
    private Boolean _hasLock;
    private Boolean _hasOverrideCheckoutPermission;
    private Boolean _hasPermissionsPermission;
    private Boolean _hasUpdatePermission;
    private Boolean _hasViewPermission;
    private final PermissionChecker _permissionChecker;
    private Boolean _supportsLocking;

    public FileEntryDisplayContextHelper(PermissionChecker permissionChecker, FileEntry fileEntry) {
        this._permissionChecker = permissionChecker;
        this._fileEntry = fileEntry;
        if (this._fileEntry == null) {
            this._setValuesForNullFileEntry();
        }
    }

    public DLFileEntryType getDLFileEntryType() throws PortalException {
        if (this.isDLFileEntry()) {
            DLFileEntry dlFileEntry = (DLFileEntry)this._fileEntry.getModel();
            return dlFileEntry.getDLFileEntryType();
        }
        return null;
    }

    public FileEntry getFileEntry() {
        return this._fileEntry;
    }

    public boolean hasDeletePermission() throws PortalException {
        if (this._hasDeletePermission == null) {
            this._hasDeletePermission = DLFileEntryPermission.contains(this._permissionChecker, this._fileEntry, "DELETE");
        }
        return this._hasDeletePermission;
    }

    public boolean hasExportImportPermission() throws PortalException {
        if (this._hasExportImportPermission == null) {
            this._hasExportImportPermission = GroupPermissionUtil.contains((PermissionChecker)this._permissionChecker, (long)this._fileEntry.getGroupId(), (String)"EXPORT_IMPORT_PORTLET_INFO");
        }
        return this._hasExportImportPermission;
    }

    public boolean hasLock() {
        if (this._hasLock == null) {
            this._hasLock = this._fileEntry.hasLock();
        }
        return this._hasLock;
    }

    public boolean hasOverrideCheckoutPermission() throws PortalException {
        if (this._hasOverrideCheckoutPermission == null) {
            this._hasOverrideCheckoutPermission = DLFileEntryPermission.contains(this._permissionChecker, this._fileEntry, "OVERRIDE_CHECKOUT");
        }
        return this._hasOverrideCheckoutPermission;
    }

    public boolean hasPermissionsPermission() throws PortalException {
        if (this._hasPermissionsPermission == null) {
            this._hasPermissionsPermission = DLFileEntryPermission.contains(this._permissionChecker, this._fileEntry, "PERMISSIONS");
        }
        return this._hasPermissionsPermission;
    }

    public boolean hasUpdatePermission() throws PortalException {
        if (this._hasUpdatePermission == null) {
            this._hasUpdatePermission = DLFileEntryPermission.contains(this._permissionChecker, this._fileEntry, "UPDATE");
        }
        return this._hasUpdatePermission;
    }

    public boolean hasViewPermission() throws PortalException {
        if (this._hasViewPermission == null) {
            this._hasViewPermission = DLFileEntryPermission.contains(this._permissionChecker, this._fileEntry, "VIEW");
        }
        return this._hasViewPermission;
    }

    public boolean isCancelCheckoutDocumentActionAvailable() throws PortalException {
        return (this.isCheckinActionAvailable() || this.isCheckedOut() && this.hasOverrideCheckoutPermission()) && this._hasPreviousVersions();
    }

    public boolean isCheckedOut() {
        if (this._checkedOut == null) {
            this._checkedOut = this._fileEntry.isCheckedOut();
        }
        return this._checkedOut;
    }

    public boolean isCheckedOutByMe() {
        return this.isCheckedOut() && this.isLockedByMe();
    }

    public boolean isCheckedOutByOther() {
        return this.isCheckedOut() && !this.isLockedByMe();
    }

    public boolean isCheckinActionAvailable() throws PortalException {
        return this.hasUpdatePermission() && this.isLockedByMe() && this.isSupportsLocking();
    }

    public boolean isCheckoutDocumentActionAvailable() throws PortalException {
        return this.hasUpdatePermission() && !this.isCheckedOut() && this.isSupportsLocking();
    }

    public boolean isDLFileEntry() {
        if (this._dlFileEntry == null) {
            this._dlFileEntry = this._fileEntry.getModel() instanceof DLFileEntry ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        return this._dlFileEntry;
    }

    public boolean isDownloadActionAvailable() throws PortalException {
        return this.hasViewPermission();
    }

    public boolean isEditActionAvailable() throws PortalException {
        return this.isUpdatable();
    }

    public boolean isFileEntryDeletable() throws PortalException {
        return this.hasDeletePermission() && !this.isCheckedOutByOther();
    }

    public boolean isLockedByMe() {
        return this.hasLock();
    }

    public boolean isMoveActionAvailable() throws PortalException {
        return this.isUpdatable();
    }

    public boolean isPermissionsButtonVisible() throws PortalException {
        return this.hasPermissionsPermission();
    }

    public boolean isSupportsLocking() {
        if (this._supportsLocking == null) {
            this._supportsLocking = this._fileEntry.isSupportsLocking();
        }
        return this._supportsLocking;
    }

    public boolean isUpdatable() throws PortalException {
        return this.hasUpdatePermission() && !this.isCheckedOutByOther();
    }

    private boolean _hasPreviousVersions() {
        if (this._fileEntry == null) {
            return false;
        }
        return this._fileEntry.getFileVersionsCount(-1) > 1;
    }

    private void _setValuesForNullFileEntry() {
        this._checkedOut = false;
        this._dlFileEntry = true;
        this._hasDeletePermission = false;
        this._hasExportImportPermission = false;
        this._hasLock = false;
        this._hasOverrideCheckoutPermission = false;
        this._hasPermissionsPermission = true;
        this._hasUpdatePermission = true;
        this._hasViewPermission = false;
        this._supportsLocking = false;
    }
}

