/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.display.context;

import com.liferay.document.library.display.context.DLMimeTypeDisplayContext;
import com.liferay.document.library.display.context.DLViewFileVersionDisplayContext;
import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.document.library.kernel.model.DLFileEntryMetadata;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.service.DLFileEntryMetadataLocalServiceUtil;
import com.liferay.document.library.kernel.versioning.VersioningStrategy;
import com.liferay.document.library.preview.DLPreviewRenderer;
import com.liferay.document.library.preview.DLPreviewRendererProvider;
import com.liferay.document.library.preview.exception.DLFileEntryPreviewGenerationException;
import com.liferay.document.library.preview.exception.DLPreviewGenerationInProcessException;
import com.liferay.document.library.preview.exception.DLPreviewSizeException;
import com.liferay.document.library.util.DLURLHelper;
import com.liferay.document.library.web.internal.display.context.logic.DLPortletInstanceSettingsHelper;
import com.liferay.document.library.web.internal.display.context.logic.FileEntryDisplayContextHelper;
import com.liferay.document.library.web.internal.display.context.logic.FileVersionDisplayContextHelper;
import com.liferay.document.library.web.internal.display.context.logic.UIItemsBuilder;
import com.liferay.document.library.web.internal.display.context.util.DLRequestHelper;
import com.liferay.document.library.web.internal.display.context.util.JSPRenderer;
import com.liferay.document.library.web.internal.util.DLTrashUtil;
import com.liferay.dynamic.data.mapping.exception.StorageException;
import com.liferay.dynamic.data.mapping.kernel.DDMStructure;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.StorageEngine;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.servlet.taglib.ui.Menu;
import com.liferay.portal.kernel.servlet.taglib.ui.MenuItem;
import com.liferay.portal.kernel.servlet.taglib.ui.ToolbarItem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DefaultDLViewFileVersionDisplayContext
implements DLViewFileVersionDisplayContext {
    private static final UUID _UUID = UUID.fromString("85F6C50E-3893-4E32-9D63-208528A503FA");
    private static final Log _log = LogFactoryUtil.getLog(DefaultDLViewFileVersionDisplayContext.class);
    private List<DDMStructure> _ddmStructures;
    private final DLMimeTypeDisplayContext _dlMimeTypeDisplayContext;
    private final DLPortletInstanceSettingsHelper _dlPortletInstanceSettingsHelper;
    private DLPreviewRendererProvider _dlPreviewRendererProvider;
    private final FileEntryDisplayContextHelper _fileEntryDisplayContextHelper;
    private final FileVersion _fileVersion;
    private final FileVersionDisplayContextHelper _fileVersionDisplayContextHelper;
    private final ResourceBundle _resourceBundle;
    private final StorageEngine _storageEngine;
    private final UIItemsBuilder _uiItemsBuilder;

    public DefaultDLViewFileVersionDisplayContext(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FileShortcut fileShortcut, DLMimeTypeDisplayContext dlMimeTypeDisplayContext, ResourceBundle resourceBundle, StorageEngine storageEngine, DLTrashUtil dlTrashUtil, DLPreviewRendererProvider dlPreviewRendererProvider, VersioningStrategy versioningStrategy, DLURLHelper dlURLHelper) throws PortalException {
        this(httpServletRequest, fileShortcut.getFileVersion(), fileShortcut, dlMimeTypeDisplayContext, resourceBundle, storageEngine, dlTrashUtil, dlPreviewRendererProvider, versioningStrategy, dlURLHelper);
    }

    public DefaultDLViewFileVersionDisplayContext(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FileVersion fileVersion, DLMimeTypeDisplayContext dlMimeTypeDisplayContext, ResourceBundle resourceBundle, StorageEngine storageEngine, DLTrashUtil dlTrashUtil, DLPreviewRendererProvider dlPreviewRendererProvider, VersioningStrategy versioningStrategy, DLURLHelper dlURLHelper) {
        this(httpServletRequest, fileVersion, null, dlMimeTypeDisplayContext, resourceBundle, storageEngine, dlTrashUtil, dlPreviewRendererProvider, versioningStrategy, dlURLHelper);
    }

    public String getCssClassFileMimeType() {
        if (this._dlMimeTypeDisplayContext == null) {
            return "file-icon-color-0";
        }
        return this._dlMimeTypeDisplayContext.getCssClassFileMimeType(this._fileVersion.getMimeType());
    }

    public DDMFormValues getDDMFormValues(DDMStructure ddmStructure) throws PortalException {
        DLFileEntryMetadata dlFileEntryMetadata = DLFileEntryMetadataLocalServiceUtil.getFileEntryMetadata((long)ddmStructure.getStructureId(), (long)this._fileVersion.getFileVersionId());
        return this._storageEngine.getDDMFormValues(dlFileEntryMetadata.getDDMStorageId());
    }

    public DDMFormValues getDDMFormValues(long classPK) throws StorageException {
        return this._storageEngine.getDDMFormValues(classPK);
    }

    public List<DDMStructure> getDDMStructures() throws PortalException {
        if (this._ddmStructures != null) {
            return this._ddmStructures;
        }
        if (this._fileVersionDisplayContextHelper.isDLFileVersion()) {
            DLFileVersion dlFileVersion = (DLFileVersion)this._fileVersion.getModel();
            this._ddmStructures = dlFileVersion.getDDMStructures();
        } else {
            this._ddmStructures = Collections.emptyList();
        }
        return this._ddmStructures;
    }

    public int getDDMStructuresCount() throws PortalException {
        List<DDMStructure> ddmStructures = this.getDDMStructures();
        return ddmStructures.size();
    }

    public String getDiscussionClassName() {
        return DLFileEntryConstants.getClassName();
    }

    public long getDiscussionClassPK() {
        return this._fileVersion.getFileEntryId();
    }

    public String getDiscussionLabel(Locale locale) {
        return LanguageUtil.get((ResourceBundle)this._resourceBundle, (String)"comments");
    }

    public String getIconFileMimeType() {
        if (this._dlMimeTypeDisplayContext == null) {
            return "document-default";
        }
        return this._dlMimeTypeDisplayContext.getIconFileMimeType(this._fileVersion.getMimeType());
    }

    public Menu getMenu() throws PortalException {
        Menu menu = new Menu();
        menu.setDirection("left-side");
        menu.setMarkupView("lexicon");
        menu.setMenuItems(this._getMenuItems());
        menu.setMessage(LanguageUtil.get((ResourceBundle)this._resourceBundle, (String)"actions"));
        menu.setScroll(false);
        menu.setShowWhenSingleIcon(true);
        menu.setTriggerCssClass("component-action");
        return menu;
    }

    public List<ToolbarItem> getToolbarItems() throws PortalException {
        ArrayList<ToolbarItem> toolbarItems = new ArrayList<ToolbarItem>();
        this._uiItemsBuilder.addDownloadToolbarItem(toolbarItems);
        this._uiItemsBuilder.addOpenInMsOfficeToolbarItem(toolbarItems);
        this._uiItemsBuilder.addEditToolbarItem(toolbarItems);
        this._uiItemsBuilder.addCheckoutToolbarItem(toolbarItems);
        this._uiItemsBuilder.addCancelCheckoutToolbarItem(toolbarItems);
        this._uiItemsBuilder.addCheckinToolbarItem(toolbarItems);
        this._uiItemsBuilder.addMoveToolbarItem(toolbarItems);
        this._uiItemsBuilder.addPermissionsToolbarItem(toolbarItems);
        this._uiItemsBuilder.addMoveToTheRecycleBinToolbarItem(toolbarItems);
        this._uiItemsBuilder.addDeleteToolbarItem(toolbarItems);
        return toolbarItems;
    }

    public UUID getUuid() {
        return _UUID;
    }

    public boolean hasCustomThumbnail() {
        if (this._dlPreviewRendererProvider != null) {
            Optional dlPreviewRendererOptional = this._dlPreviewRendererProvider.getThumbnailDLPreviewRendererOptional(this._fileVersion);
            return dlPreviewRendererOptional.isPresent();
        }
        return false;
    }

    public boolean hasPreview() {
        if (this._dlPreviewRendererProvider != null) {
            Optional dlPreviewRendererOptional = this._dlPreviewRendererProvider.getPreviewDLPreviewRendererOptional(this._fileVersion);
            return dlPreviewRendererOptional.isPresent();
        }
        return false;
    }

    public boolean isActionsVisible() {
        return this._dlPortletInstanceSettingsHelper.isShowActions();
    }

    public boolean isDownloadLinkVisible() throws PortalException {
        return this._fileEntryDisplayContextHelper.isDownloadActionAvailable();
    }

    public boolean isSharingLinkVisible() {
        return false;
    }

    public boolean isVersionInfoVisible() {
        return true;
    }

    public void renderCustomThumbnail(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        Optional dlPreviewRendererOptional = Optional.empty();
        if (this._dlPreviewRendererProvider != null) {
            dlPreviewRendererOptional = this._dlPreviewRendererProvider.getThumbnailDLPreviewRendererOptional(this._fileVersion);
        }
        this._renderPreview(httpServletRequest, httpServletResponse, dlPreviewRendererOptional);
    }

    public void renderPreview(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        Optional dlPreviewRendererOptional = Optional.empty();
        if (this._dlPreviewRendererProvider != null) {
            dlPreviewRendererOptional = this._dlPreviewRendererProvider.getPreviewDLPreviewRendererOptional(this._fileVersion);
        }
        this._renderPreview(httpServletRequest, httpServletResponse, dlPreviewRendererOptional);
    }

    private DefaultDLViewFileVersionDisplayContext(HttpServletRequest httpServletRequest, FileVersion fileVersion, FileShortcut fileShortcut, DLMimeTypeDisplayContext dlMimeTypeDisplayContext, ResourceBundle resourceBundle, StorageEngine storageEngine, DLTrashUtil dlTrashUtil, DLPreviewRendererProvider dlPreviewRendererProvider, VersioningStrategy versioningStrategy, DLURLHelper dlURLHelper) {
        try {
            this._fileVersion = fileVersion;
            this._dlMimeTypeDisplayContext = dlMimeTypeDisplayContext;
            this._resourceBundle = resourceBundle;
            this._storageEngine = storageEngine;
            this._dlPreviewRendererProvider = dlPreviewRendererProvider;
            DLRequestHelper dlRequestHelper = new DLRequestHelper(httpServletRequest);
            this._dlPortletInstanceSettingsHelper = new DLPortletInstanceSettingsHelper(dlRequestHelper);
            FileEntry fileEntry = this._getFileEntry(fileVersion);
            this._fileEntryDisplayContextHelper = new FileEntryDisplayContextHelper(dlRequestHelper.getPermissionChecker(), fileEntry);
            this._fileVersionDisplayContextHelper = new FileVersionDisplayContextHelper(fileVersion);
            this._uiItemsBuilder = fileShortcut == null ? new UIItemsBuilder(httpServletRequest, fileEntry, fileVersion, this._resourceBundle, dlTrashUtil, versioningStrategy, dlURLHelper) : new UIItemsBuilder(httpServletRequest, fileShortcut, this._resourceBundle, dlTrashUtil, versioningStrategy, dlURLHelper);
        }
        catch (PortalException pe) {
            throw new SystemException("Unable to build DefaultDLViewFileVersionDisplayContext for " + fileVersion, (Throwable)pe);
        }
    }

    private FileEntry _getFileEntry(FileVersion fileVersion) throws PortalException {
        if (fileVersion != null) {
            return fileVersion.getFileEntry();
        }
        return null;
    }

    private List<MenuItem> _getMenuItems() throws PortalException {
        ArrayList<MenuItem> menuItems = new ArrayList<MenuItem>();
        if (this.isActionsVisible()) {
            this._uiItemsBuilder.addDownloadMenuItem(menuItems);
            this._uiItemsBuilder.addViewOriginalFileMenuItem(menuItems);
            this._uiItemsBuilder.addOpenInMsOfficeMenuItem(menuItems);
            this._uiItemsBuilder.addEditMenuItem(menuItems);
            this._uiItemsBuilder.addCheckoutMenuItem(menuItems);
            this._uiItemsBuilder.addCancelCheckoutMenuItem(menuItems);
            this._uiItemsBuilder.addCheckinMenuItem(menuItems);
            this._uiItemsBuilder.addMoveMenuItem(menuItems);
            MenuItem menuItem = null;
            if (!menuItems.isEmpty()) {
                menuItem = (MenuItem)menuItems.get(menuItems.size() - 1);
            }
            this._uiItemsBuilder.addPermissionsMenuItem(menuItems);
            this._uiItemsBuilder.addDeleteMenuItem(menuItems);
            this._uiItemsBuilder.addPublishMenuItem(menuItems, true);
            if (menuItem != null && menuItem != menuItems.get(menuItems.size() - 1)) {
                menuItem.setSeparator(true);
            }
        }
        return menuItems;
    }

    private void _handleError(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Exception e) throws IOException, ServletException {
        JSPRenderer jspRenderer = new JSPRenderer("/document_library/view_file_entry_preview_error.jsp");
        jspRenderer.setAttribute("DOCUMENT_LIBRARY_FILE_VERSION", this._fileVersion);
        if (e != null) {
            jspRenderer.setAttribute("DOCUMENT_LIBRARY_PREVIEW_EXCEPTION", e);
        }
        jspRenderer.render(httpServletRequest, httpServletResponse);
    }

    private void _renderPreview(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Optional<DLPreviewRenderer> dlPreviewRendererOptional) throws IOException, ServletException {
        try {
            if (!dlPreviewRendererOptional.isPresent()) {
                this._handleError(httpServletRequest, httpServletResponse, null);
                return;
            }
            DLPreviewRenderer dlPreviewRenderer = dlPreviewRendererOptional.get();
            dlPreviewRenderer.render(httpServletRequest, httpServletResponse);
        }
        catch (Exception e) {
            if (e instanceof DLFileEntryPreviewGenerationException || e instanceof DLPreviewGenerationInProcessException || e instanceof DLPreviewSizeException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)e, (Throwable)e);
                }
            } else {
                _log.error((Object)("Unable to render preview for file version: " + this._fileVersion.getTitle()), (Throwable)e);
            }
            this._handleError(httpServletRequest, httpServletResponse, e);
        }
    }
}

