/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.display.context;

import com.liferay.asset.kernel.service.AssetCategoryServiceUtil;
import com.liferay.asset.kernel.service.AssetVocabularyServiceUtil;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.service.DLAppServiceUtil;
import com.liferay.document.library.kernel.service.DLFileEntryTypeLocalServiceUtil;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.document.library.web.internal.display.context.DLAdminDisplayContext;
import com.liferay.document.library.web.internal.display.context.logic.DLPortletInstanceSettingsHelper;
import com.liferay.document.library.web.internal.display.context.util.DLRequestHelper;
import com.liferay.document.library.web.internal.security.permission.resource.DLFileEntryPermission;
import com.liferay.document.library.web.internal.security.permission.resource.DLFolderPermission;
import com.liferay.document.library.web.internal.settings.DLPortletInstanceSettings;
import com.liferay.document.library.web.internal.util.DLTrashUtil;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.CreationMenu;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.LabelItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.LabelItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.ViewTypeItemList;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.portlet.toolbar.contributor.PortletToolbarContributor;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ClassNameLocalServiceUtil;
import com.liferay.portal.kernel.servlet.taglib.ui.Menu;
import com.liferay.portal.kernel.servlet.taglib.ui.URLMenuItem;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.RepositoryUtil;
import com.liferay.staging.StagingGroupHelper;
import com.liferay.staging.StagingGroupHelperUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class DLAdminManagementToolbarDisplayContext {
    private final PortletURL _currentURLObj;
    private final DLAdminDisplayContext _dlAdminDisplayContext;
    private final DLPortletInstanceSettingsHelper _dlPortletInstanceSettingsHelper;
    private final DLRequestHelper _dlRequestHelper;
    private final DLTrashUtil _dlTrashUtil;
    private Boolean _hasValidAssetVocabularies;
    private final HttpServletRequest _httpServletRequest;
    private final LiferayPortletRequest _liferayPortletRequest;
    private final LiferayPortletResponse _liferayPortletResponse;
    private final ThemeDisplay _themeDisplay;

    public DLAdminManagementToolbarDisplayContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, HttpServletRequest httpServletRequest, DLAdminDisplayContext dlAdminDisplayContext) {
        this._liferayPortletRequest = liferayPortletRequest;
        this._liferayPortletResponse = liferayPortletResponse;
        this._httpServletRequest = httpServletRequest;
        this._dlAdminDisplayContext = dlAdminDisplayContext;
        this._currentURLObj = PortletURLUtil.getCurrent((LiferayPortletRequest)liferayPortletRequest, (LiferayPortletResponse)liferayPortletResponse);
        this._dlRequestHelper = new DLRequestHelper(this._httpServletRequest);
        this._dlPortletInstanceSettingsHelper = new DLPortletInstanceSettingsHelper(this._dlRequestHelper);
        this._dlTrashUtil = (DLTrashUtil)this._httpServletRequest.getAttribute("DOCUMENT_LIBRARY_TRASH_UTIL");
        this._themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public List<DropdownItem> getActionDropdownItems() throws PortalException {
        if (!this._dlPortletInstanceSettingsHelper.isShowActions()) {
            return null;
        }
        return new DropdownItemList(){
            {
                boolean stagedActions = false;
                Group scopeGroup = DLAdminManagementToolbarDisplayContext.this._themeDisplay.getScopeGroup();
                StagingGroupHelper stagingGroupHelper = StagingGroupHelperUtil.getStagingGroupHelper();
                if (!stagingGroupHelper.isLiveGroup(scopeGroup) || !stagingGroupHelper.isStagedPortlet(scopeGroup, "com_liferay_document_library_web_portlet_DLPortlet")) {
                    stagedActions = true;
                }
                if (stagedActions) {
                    this.add(dropdownItem -> {
                        dropdownItem.putData("action", "download");
                        dropdownItem.setIcon("download");
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)DLAdminManagementToolbarDisplayContext.this._httpServletRequest, (String)"download"));
                        dropdownItem.setQuickAction(true);
                    });
                }
                User user = DLAdminManagementToolbarDisplayContext.this._themeDisplay.getUser();
                if (stagedActions && !user.isDefaultUser()) {
                    this.add(dropdownItem -> {
                        dropdownItem.putData("action", "move");
                        dropdownItem.setIcon("move-folder");
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)DLAdminManagementToolbarDisplayContext.this._httpServletRequest, (String)"move"));
                        dropdownItem.setQuickAction(true);
                    });
                    boolean enableOnBulk = DLAdminManagementToolbarDisplayContext.this._isEnableOnBulk();
                    this.add(dropdownItem -> {
                        dropdownItem.putData("action", "editTags");
                        if (enableOnBulk) {
                            dropdownItem.putData("enableOnBulk", Boolean.TRUE.toString());
                        }
                        dropdownItem.setIcon("tag");
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)DLAdminManagementToolbarDisplayContext.this._httpServletRequest, (String)"edit-tags"));
                        dropdownItem.setQuickAction(true);
                    });
                    if (DLAdminManagementToolbarDisplayContext.this._hasValidAssetVocabularies(DLAdminManagementToolbarDisplayContext.this._themeDisplay.getScopeGroupId())) {
                        this.add(dropdownItem -> {
                            dropdownItem.putData("action", "editCategories");
                            if (enableOnBulk) {
                                dropdownItem.putData("enableOnBulk", Boolean.TRUE.toString());
                            }
                            dropdownItem.setIcon("categories");
                            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)DLAdminManagementToolbarDisplayContext.this._httpServletRequest, (String)"edit-categories"));
                            dropdownItem.setQuickAction(true);
                        });
                    }
                }
                if (!user.isDefaultUser()) {
                    this.add(dropdownItem -> {
                        dropdownItem.putData("action", "deleteEntries");
                        if (DLAdminManagementToolbarDisplayContext.this._dlTrashUtil.isTrashEnabled(scopeGroup.getGroupId(), DLAdminManagementToolbarDisplayContext.this._getRepositoryId())) {
                            dropdownItem.setIcon("trash");
                            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)DLAdminManagementToolbarDisplayContext.this._httpServletRequest, (String)"move-to-recycle-bin"));
                        } else {
                            dropdownItem.setIcon("times-circle");
                            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)DLAdminManagementToolbarDisplayContext.this._httpServletRequest, (String)"delete"));
                        }
                        dropdownItem.setQuickAction(true);
                    });
                }
                if (stagedActions && !user.isDefaultUser()) {
                    this.add(dropdownItem -> {
                        dropdownItem.putData("action", "checkin");
                        dropdownItem.setIcon("unlock");
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)DLAdminManagementToolbarDisplayContext.this._httpServletRequest, (String)"checkin"));
                        dropdownItem.setQuickAction(false);
                    });
                    this.add(dropdownItem -> {
                        dropdownItem.putData("action", "checkout");
                        dropdownItem.setIcon("lock");
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)DLAdminManagementToolbarDisplayContext.this._httpServletRequest, (String)"checkout[document]"));
                        dropdownItem.setQuickAction(false);
                    });
                }
            }
        };
    }

    public List<String> getAvailableActions(FileEntry fileEntry) throws PortalException {
        ArrayList<String> availableActionDropdownItems = new ArrayList<String>();
        PermissionChecker permissionChecker = this._themeDisplay.getPermissionChecker();
        if (DLFileEntryPermission.contains(permissionChecker, fileEntry, "DELETE")) {
            availableActionDropdownItems.add("deleteEntries");
        }
        if (DLFileEntryPermission.contains(permissionChecker, fileEntry, "UPDATE")) {
            availableActionDropdownItems.add("move");
            if (fileEntry.isCheckedOut()) {
                availableActionDropdownItems.add("checkin");
            } else {
                availableActionDropdownItems.add("checkout");
            }
            if (!RepositoryUtil.isExternalRepository((long)fileEntry.getRepositoryId()) && !this._hasWorkflowDefinitionLink(fileEntry)) {
                if (this._hasValidAssetVocabularies(this._themeDisplay.getScopeGroupId())) {
                    availableActionDropdownItems.add("editCategories");
                }
                availableActionDropdownItems.add("editTags");
            }
        }
        if (DLFileEntryPermission.contains(permissionChecker, fileEntry, "VIEW")) {
            availableActionDropdownItems.add("download");
        }
        return availableActionDropdownItems;
    }

    public List<String> getAvailableActions(Folder folder) throws PortalException {
        ArrayList<String> availableActionDropdownItems = new ArrayList<String>();
        PermissionChecker permissionChecker = this._themeDisplay.getPermissionChecker();
        if (DLFolderPermission.contains(permissionChecker, folder, "DELETE")) {
            availableActionDropdownItems.add("deleteEntries");
        }
        if (DLFolderPermission.contains(permissionChecker, folder, "UPDATE") && !folder.isMountPoint()) {
            availableActionDropdownItems.add("move");
        }
        if (DLFolderPermission.contains(permissionChecker, folder, "VIEW") && !RepositoryUtil.isExternalRepository((long)folder.getRepositoryId())) {
            availableActionDropdownItems.add("download");
        }
        return availableActionDropdownItems;
    }

    public String getClearResultsURL() {
        PortletURL clearResultsURL = this._liferayPortletResponse.createRenderURL();
        clearResultsURL.setParameter("mvcRenderCommandName", "/document_library/view");
        clearResultsURL.setParameter("folderId", String.valueOf(this._getFolderId()));
        return clearResultsURL.toString();
    }

    public String getComponentId() {
        return this._liferayPortletResponse.getNamespace() + "entriesManagementToolbar";
    }

    public CreationMenu getCreationMenu() {
        String portletName = this._liferayPortletRequest.getPortletName();
        if (!portletName.equals("com_liferay_document_library_web_portlet_DLAdminPortlet")) {
            return null;
        }
        PortletToolbarContributor dlPortletToolbarContributor = (PortletToolbarContributor)this._httpServletRequest.getAttribute("DOCUMENT_LIBRARY_PORTLET_TOOLBAR_CONTRIBUTOR");
        List menus = dlPortletToolbarContributor.getPortletTitleMenus((PortletRequest)this._liferayPortletRequest, (PortletResponse)this._liferayPortletResponse);
        if (menus.isEmpty()) {
            return null;
        }
        CreationMenu creationMenu = new CreationMenu();
        creationMenu.setItemsIconAlignment("left");
        for (Menu menu : menus) {
            List urlMenuItems = menu.getMenuItems();
            for (URLMenuItem urlMenuItem : urlMenuItems) {
                creationMenu.addDropdownItem(dropdownItem -> {
                    dropdownItem.setData(urlMenuItem.getData());
                    dropdownItem.setHref((Object)urlMenuItem.getURL());
                    dropdownItem.setIcon(urlMenuItem.getIcon());
                    dropdownItem.setLabel(urlMenuItem.getLabel());
                    dropdownItem.setSeparator(urlMenuItem.hasSeparator());
                });
            }
        }
        return creationMenu;
    }

    public List<DropdownItem> getFilterDropdownItems() {
        if (this._isSearch()) {
            return null;
        }
        return new DropdownItemList(){
            {
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(DLAdminManagementToolbarDisplayContext.this._getFilterNavigationDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)DLAdminManagementToolbarDisplayContext.this._httpServletRequest, (String)"filter-by-navigation"));
                });
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(DLAdminManagementToolbarDisplayContext.this._getOrderByDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)DLAdminManagementToolbarDisplayContext.this._httpServletRequest, (String)"order-by"));
                });
            }
        };
    }

    public List<LabelItem> getFilterLabelItems() {
        return new LabelItemList(){
            {
                String navigation;
                long fileEntryTypeId = DLAdminManagementToolbarDisplayContext.this._getFileEntryTypeId();
                if (fileEntryTypeId != -1L) {
                    this.add(labelItem -> {
                        PortletURL removeLabelURL = PortletURLUtil.clone((PortletURL)DLAdminManagementToolbarDisplayContext.this._currentURLObj, (LiferayPortletResponse)DLAdminManagementToolbarDisplayContext.this._liferayPortletResponse);
                        removeLabelURL.setParameter("fileEntryTypeId", (String)null);
                        labelItem.putData("removeLabelURL", removeLabelURL.toString());
                        labelItem.setCloseable(true);
                        String fileEntryTypeName = LanguageUtil.get((HttpServletRequest)DLAdminManagementToolbarDisplayContext.this._httpServletRequest, (String)"basic-document");
                        if (fileEntryTypeId != 0L) {
                            DLFileEntryType fileEntryType = DLFileEntryTypeLocalServiceUtil.getFileEntryType((long)fileEntryTypeId);
                            fileEntryTypeName = fileEntryType.getName(DLAdminManagementToolbarDisplayContext.this._httpServletRequest.getLocale());
                        }
                        String label = String.format("%s: %s", LanguageUtil.get((HttpServletRequest)DLAdminManagementToolbarDisplayContext.this._httpServletRequest, (String)"document-type"), fileEntryTypeName);
                        labelItem.setLabel(label);
                    });
                }
                if ((navigation = DLAdminManagementToolbarDisplayContext.this._getNavigation()).equals("mine")) {
                    this.add(labelItem -> {
                        PortletURL removeLabelURL = PortletURLUtil.clone((PortletURL)DLAdminManagementToolbarDisplayContext.this._currentURLObj, (LiferayPortletResponse)DLAdminManagementToolbarDisplayContext.this._liferayPortletResponse);
                        removeLabelURL.setParameter("navigation", (String)null);
                        labelItem.putData("removeLabelURL", removeLabelURL.toString());
                        labelItem.setCloseable(true);
                        User user = DLAdminManagementToolbarDisplayContext.this._themeDisplay.getUser();
                        String label = String.format("%s: %s", LanguageUtil.get((HttpServletRequest)DLAdminManagementToolbarDisplayContext.this._httpServletRequest, (String)"owner"), user.getFullName());
                        labelItem.setLabel(label);
                    });
                }
            }
        };
    }

    public PortletURL getSearchURL() {
        PortletURL searchURL = this._liferayPortletResponse.createRenderURL();
        searchURL.setParameter("mvcRenderCommandName", "/document_library/search");
        long repositoryId = this._getRepositoryId();
        searchURL.setParameter("repositoryId", String.valueOf(repositoryId));
        long searchRepositoryId = ParamUtil.getLong((HttpServletRequest)this._httpServletRequest, (String)"searchRepositoryId", (long)repositoryId);
        searchURL.setParameter("searchRepositoryId", String.valueOf(searchRepositoryId));
        long folderId = this._getFolderId();
        searchURL.setParameter("folderId", String.valueOf(folderId));
        long searchFolderId = ParamUtil.getLong((HttpServletRequest)this._httpServletRequest, (String)"searchFolderId", (long)folderId);
        searchURL.setParameter("searchFolderId", String.valueOf(searchFolderId));
        searchURL.setParameter("showSearchInfo", Boolean.TRUE.toString());
        return searchURL;
    }

    public String getSortingOrder() {
        if (this._isSearch()) {
            return null;
        }
        return this._dlAdminDisplayContext.getOrderByType();
    }

    public PortletURL getSortingURL() {
        if (this._isSearch()) {
            return null;
        }
        PortletURL sortingURL = this._getCurrentSortingURL();
        sortingURL.setParameter("orderByType", Objects.equals(this._getOrderByType(), "asc") ? "desc" : "asc");
        return sortingURL;
    }

    public int getTotalItems() {
        SearchContainer searchContainer = this._dlAdminDisplayContext.getSearchContainer();
        return searchContainer.getTotal();
    }

    public ViewTypeItemList getViewTypes() {
        if (this._isSearch()) {
            return null;
        }
        String navigation = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"navigation", (String)"home");
        int curEntry = ParamUtil.getInteger((HttpServletRequest)this._httpServletRequest, (String)"curEntry");
        int deltaEntry = ParamUtil.getInteger((HttpServletRequest)this._httpServletRequest, (String)"deltaEntry");
        long folderId = this._getFolderId();
        long fileEntryTypeId = this._getFileEntryTypeId();
        String keywords = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"keywords");
        PortletURL displayStyleURL = this._liferayPortletResponse.createRenderURL();
        String mvcRenderCommandName = "/document_library/search";
        if (Validator.isNull((String)keywords)) {
            mvcRenderCommandName = folderId == 0L ? "/document_library/view" : "/document_library/view_folder";
        }
        displayStyleURL.setParameter("mvcRenderCommandName", mvcRenderCommandName);
        displayStyleURL.setParameter("navigation", HtmlUtil.escapeJS((String)navigation));
        if (curEntry > 0) {
            displayStyleURL.setParameter("curEntry", String.valueOf(curEntry));
        }
        if (deltaEntry > 0) {
            displayStyleURL.setParameter("deltaEntry", String.valueOf(deltaEntry));
        }
        displayStyleURL.setParameter("folderId", String.valueOf(folderId));
        if (fileEntryTypeId != -1L) {
            displayStyleURL.setParameter("fileEntryTypeId", String.valueOf(fileEntryTypeId));
        }
        return new ViewTypeItemList(displayStyleURL, this._getDisplayStyle()){
            {
                if (ArrayUtil.contains((Object[])DLAdminManagementToolbarDisplayContext.this._getDisplayViews(), (Object)"icon")) {
                    this.addCardViewTypeItem();
                }
                if (ArrayUtil.contains((Object[])DLAdminManagementToolbarDisplayContext.this._getDisplayViews(), (Object)"descriptive")) {
                    this.addListViewTypeItem();
                }
                if (ArrayUtil.contains((Object[])DLAdminManagementToolbarDisplayContext.this._getDisplayViews(), (Object)"list")) {
                    this.addTableViewTypeItem();
                }
            }
        };
    }

    public boolean isDisabled() {
        try {
            int count = DLAppServiceUtil.getFoldersAndFileEntriesAndFileShortcutsCount((long)this._getRepositoryId(), (long)this._getFolderId(), (int)-1, (boolean)true);
            return count <= 0;
        }
        catch (PortalException pe) {
            throw new SystemException((Throwable)pe);
        }
    }

    public boolean isSelectable() {
        return true;
    }

    public boolean isShowSearch() {
        return this._dlPortletInstanceSettingsHelper.isShowSearch();
    }

    private PortletURL _getCurrentSortingURL() {
        int deltaEntry = ParamUtil.getInteger((HttpServletRequest)this._httpServletRequest, (String)"deltaEntry");
        PortletURL sortingURL = this._liferayPortletResponse.createRenderURL();
        long folderId = this._getFolderId();
        if (folderId == 0L) {
            sortingURL.setParameter("mvcRenderCommandName", "/document_library/view");
        } else {
            sortingURL.setParameter("mvcRenderCommandName", "/document_library/view_folder");
        }
        sortingURL.setParameter("navigation", this._getNavigation());
        if (deltaEntry > 0) {
            sortingURL.setParameter("deltaEntry", String.valueOf(deltaEntry));
        }
        sortingURL.setParameter("folderId", String.valueOf(folderId));
        long fileEntryTypeId = this._getFileEntryTypeId();
        sortingURL.setParameter("fileEntryTypeId", String.valueOf(fileEntryTypeId));
        return sortingURL;
    }

    private String _getDisplayStyle() {
        return this._dlAdminDisplayContext.getDisplayStyle();
    }

    private String[] _getDisplayViews() {
        DLPortletInstanceSettings dlPortletInstanceSettings = this._dlRequestHelper.getDLPortletInstanceSettings();
        return dlPortletInstanceSettings.getDisplayViews();
    }

    private long _getFileEntryTypeId() {
        return ParamUtil.getLong((HttpServletRequest)this._httpServletRequest, (String)"fileEntryTypeId", (long)-1L);
    }

    private List<DropdownItem> _getFilterNavigationDropdownItems() {
        final long fileEntryTypeId = this._getFileEntryTypeId();
        final String navigation = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"navigation", (String)"home");
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setActive(navigation.equals("home") && fileEntryTypeId == -1L);
                    PortletURL viewAllDocumentsURL = PortletURLUtil.clone((PortletURL)DLAdminManagementToolbarDisplayContext.this._currentURLObj, (LiferayPortletResponse)DLAdminManagementToolbarDisplayContext.this._liferayPortletResponse);
                    viewAllDocumentsURL.setParameter("mvcRenderCommandName", "/document_library/view");
                    viewAllDocumentsURL.setParameter("navigation", "home");
                    viewAllDocumentsURL.setParameter("browseBy", (String)null);
                    viewAllDocumentsURL.setParameter("fileEntryTypeId", (String)null);
                    dropdownItem.setHref((Object)viewAllDocumentsURL);
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)DLAdminManagementToolbarDisplayContext.this._httpServletRequest, (String)"all"));
                });
                if (DLAdminManagementToolbarDisplayContext.this._themeDisplay.isSignedIn()) {
                    this.add(dropdownItem -> {
                        dropdownItem.setActive(navigation.equals("mine"));
                        PortletURL viewMyDocumentsURL = PortletURLUtil.clone((PortletURL)DLAdminManagementToolbarDisplayContext.this._currentURLObj, (LiferayPortletResponse)DLAdminManagementToolbarDisplayContext.this._liferayPortletResponse);
                        viewMyDocumentsURL.setParameter("mvcRenderCommandName", "/document_library/view");
                        viewMyDocumentsURL.setParameter("navigation", "mine");
                        dropdownItem.setHref((Object)viewMyDocumentsURL);
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)DLAdminManagementToolbarDisplayContext.this._httpServletRequest, (String)"mine"));
                    });
                }
                this.add(dropdownItem -> {
                    dropdownItem.setActive(fileEntryTypeId != -1L);
                    dropdownItem.putData("action", "openDocumentTypesSelector");
                    String label = LanguageUtil.get((HttpServletRequest)DLAdminManagementToolbarDisplayContext.this._httpServletRequest, (String)"document-type");
                    if (fileEntryTypeId != -1L) {
                        String fileEntryTypeName = LanguageUtil.get((HttpServletRequest)DLAdminManagementToolbarDisplayContext.this._httpServletRequest, (String)"basic-document");
                        if (fileEntryTypeId != 0L) {
                            DLFileEntryType fileEntryType = DLFileEntryTypeLocalServiceUtil.getFileEntryType((long)fileEntryTypeId);
                            fileEntryTypeName = fileEntryType.getName(DLAdminManagementToolbarDisplayContext.this._httpServletRequest.getLocale());
                        }
                        label = String.format("%s: %s", label, fileEntryTypeName);
                    }
                    dropdownItem.setLabel(label);
                });
            }
        };
    }

    private long _getFolderId() {
        if (this._isSearch()) {
            return ParamUtil.getLong((HttpServletRequest)this._httpServletRequest, (String)"folderId");
        }
        return this._dlAdminDisplayContext.getFolderId();
    }

    private String _getNavigation() {
        return ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"navigation", (String)"home");
    }

    private String _getOrderByCol() {
        return this._dlAdminDisplayContext.getOrderByCol();
    }

    private List<DropdownItem> _getOrderByDropdownItems() {
        final HashMap<String, String> orderColumns = new HashMap<String, String>();
        orderColumns.put("creationDate", "create-date");
        if (this._getFileEntryTypeId() == -1L) {
            orderColumns.put("downloads", "downloads");
        }
        orderColumns.put("modifiedDate", "modified-date");
        orderColumns.put("size", "size");
        orderColumns.put("title", "title");
        return new DropdownItemList(){
            {
                for (Map.Entry orderByColEntry : orderColumns.entrySet()) {
                    String orderByCol = (String)orderByColEntry.getKey();
                    this.add(dropdownItem -> {
                        dropdownItem.setActive(orderByCol.equals(DLAdminManagementToolbarDisplayContext.this._getOrderByCol()));
                        dropdownItem.setHref(DLAdminManagementToolbarDisplayContext.this._getCurrentSortingURL(), new Object[]{"orderByCol", orderByCol});
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)DLAdminManagementToolbarDisplayContext.this._httpServletRequest, (String)((String)orderByColEntry.getValue())));
                    });
                }
            }
        };
    }

    private String _getOrderByType() {
        return this._dlAdminDisplayContext.getOrderByType();
    }

    private long _getRepositoryId() {
        return this._dlAdminDisplayContext.getRepositoryId();
    }

    private boolean _hasValidAssetVocabularies(long scopeGroupId) throws PortalException {
        if (this._hasValidAssetVocabularies != null) {
            return this._hasValidAssetVocabularies;
        }
        List assetVocabularies = AssetVocabularyServiceUtil.getGroupVocabularies((long[])PortalUtil.getCurrentAndAncestorSiteGroupIds((long)scopeGroupId));
        Stream stream = assetVocabularies.stream();
        this._hasValidAssetVocabularies = stream.anyMatch(assetVocabulary -> {
            if (!assetVocabulary.isAssociatedToClassNameId(ClassNameLocalServiceUtil.getClassNameId((String)DLFileEntry.class.getName()))) {
                return false;
            }
            int count = AssetCategoryServiceUtil.getVocabularyCategoriesCount((long)assetVocabulary.getGroupId(), (long)assetVocabulary.getVocabularyId());
            return count > 0;
        });
        return this._hasValidAssetVocabularies;
    }

    private boolean _hasWorkflowDefinitionLink(FileEntry fileEntry) throws PortalException {
        if (!(fileEntry.getModel() instanceof DLFileEntry)) {
            return false;
        }
        DLFileEntry dlFileEntry = (DLFileEntry)fileEntry.getModel();
        return this._hasWorkflowDefinitionLink(dlFileEntry.getFolderId(), dlFileEntry.getFileEntryTypeId());
    }

    private boolean _hasWorkflowDefinitionLink(long folderId, long fileEntryTypeId) throws PortalException {
        try {
            return DLUtil.hasWorkflowDefinitionLink((long)this._themeDisplay.getCompanyId(), (long)this._themeDisplay.getScopeGroupId(), (long)folderId, (long)fileEntryTypeId);
        }
        catch (PortalException | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PortalException((Throwable)e);
        }
    }

    private boolean _isEnableOnBulk() throws PortalException {
        long folderId = ParamUtil.getLong((HttpServletRequest)this._httpServletRequest, (String)"folderId");
        return !this._hasWorkflowDefinitionLink(folderId, -1L);
    }

    private boolean _isSearch() {
        return this._dlAdminDisplayContext.isSearch();
    }
}

