/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.asset.model;

import com.liferay.asset.display.page.portlet.AssetDisplayPageFriendlyURLProvider;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.BaseAssetRendererFactory;
import com.liferay.asset.kernel.model.ClassTypeReader;
import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.kernel.service.DLFileEntryTypeLocalService;
import com.liferay.document.library.util.DLURLHelper;
import com.liferay.document.library.web.internal.asset.model.DLFileEntryAssetRenderer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portlet.documentlibrary.asset.model.DLFileEntryClassTypeReader;
import com.liferay.trash.TrashHelper;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_document_library_web_portlet_DLPortlet"}, service={AssetRendererFactory.class})
public class DLFileEntryAssetRendererFactory
extends BaseAssetRendererFactory<FileEntry> {
    public static final String TYPE = "document";
    private static final Log _log = LogFactoryUtil.getLog(DLFileEntryAssetRendererFactory.class);
    @Reference
    private AssetDisplayPageFriendlyURLProvider _assetDisplayPageFriendlyURLProvider;
    private DLAppLocalService _dlAppLocalService;
    private DLFileEntryLocalService _dlFileEntryLocalService;
    private DLFileEntryTypeLocalService _dlFileEntryTypeLocalService;
    @Reference(target="(model.class.name=com.liferay.document.library.kernel.model.DLFileEntryType)")
    private ModelResourcePermission<DLFileEntryType> _dlFileEntryTypeModelResourcePermission;
    @Reference
    private DLURLHelper _dlURLHelper;
    @Reference(target="(model.class.name=com.liferay.portal.kernel.repository.model.FileEntry)")
    private ModelResourcePermission<FileEntry> _fileEntryModelResourcePermission;
    @Reference
    private Portal _portal;
    @Reference(target="(resource.name=com.liferay.document.library)")
    private PortletResourcePermission _portletResourcePermission;
    @Reference
    private TrashHelper _trashHelper;

    public DLFileEntryAssetRendererFactory() {
        this.setLinkable(true);
        this.setPortletId("com_liferay_document_library_web_portlet_DLPortlet");
        this.setSearchable(true);
        this.setSupportsClassTypes(true);
    }

    public AssetRenderer<FileEntry> getAssetRenderer(long classPK, int type) throws PortalException {
        FileVersion fileVersion;
        FileEntry fileEntry;
        block5: {
            fileEntry = null;
            fileVersion = null;
            try {
                fileEntry = this._dlAppLocalService.getFileEntry(classPK);
                if (type == 0) {
                    fileVersion = fileEntry.getLatestFileVersion();
                    break block5;
                }
                if (type == 1) {
                    fileVersion = fileEntry.getFileVersion();
                    break block5;
                }
                throw new IllegalArgumentException("Unknown asset renderer type " + type);
            }
            catch (NoSuchFileEntryException nsfee) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)nsfee, (Throwable)nsfee);
                }
                fileVersion = this._dlAppLocalService.getFileVersion(classPK);
                fileEntry = fileVersion.getFileEntry();
            }
        }
        DLFileEntryAssetRenderer dlFileEntryAssetRenderer = new DLFileEntryAssetRenderer(fileEntry, fileVersion, this._dlFileEntryLocalService, this._trashHelper, this._dlURLHelper);
        dlFileEntryAssetRenderer.setAssetDisplayPageFriendlyURLProvider(this._assetDisplayPageFriendlyURLProvider);
        dlFileEntryAssetRenderer.setAssetRendererType(type);
        return dlFileEntryAssetRenderer;
    }

    public String getClassName() {
        return DLFileEntry.class.getName();
    }

    public ClassTypeReader getClassTypeReader() {
        return new DLFileEntryClassTypeReader();
    }

    public String getIconCssClass() {
        return "documents-and-media";
    }

    public String getSubtypeTitle(Locale locale) {
        return LanguageUtil.get((Locale)locale, (String)"type");
    }

    public String getType() {
        return TYPE;
    }

    public String getTypeName(Locale locale, long subtypeId) {
        try {
            DLFileEntryType dlFileEntryType = this._dlFileEntryTypeLocalService.getFileEntryType(subtypeId);
            return dlFileEntryType.getName(locale);
        }
        catch (Exception e) {
            return super.getTypeName(locale, subtypeId);
        }
    }

    public PortletURL getURLAdd(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, long classTypeId) {
        PortletURL portletURL = this._portal.getControlPanelPortletURL((PortletRequest)liferayPortletRequest, this.getGroup(liferayPortletRequest), "com_liferay_document_library_web_portlet_DLPortlet", 0L, 0L, "RENDER_PHASE");
        portletURL.setParameter("mvcRenderCommandName", "/document_library/edit_file_entry");
        portletURL.setParameter("cmd", "add");
        portletURL.setParameter("folderId", String.valueOf(0L));
        long fileEntryTypeId = 0L;
        if (classTypeId >= 0L) {
            fileEntryTypeId = classTypeId;
        }
        portletURL.setParameter("fileEntryTypeId", String.valueOf(fileEntryTypeId));
        portletURL.setParameter("showMountFolder", Boolean.FALSE.toString());
        portletURL.setParameter("showSelectFolder", Boolean.TRUE.toString());
        return portletURL;
    }

    public PortletURL getURLView(LiferayPortletResponse liferayPortletResponse, WindowState windowState) {
        LiferayPortletURL liferayPortletURL = liferayPortletResponse.createLiferayPortletURL("com_liferay_document_library_web_portlet_DLPortlet", "RENDER_PHASE");
        try {
            liferayPortletURL.setWindowState(windowState);
        }
        catch (WindowStateException windowStateException) {
            // empty catch block
        }
        return liferayPortletURL;
    }

    public boolean hasAddPermission(PermissionChecker permissionChecker, long groupId, long classTypeId) throws Exception {
        if (classTypeId > 0L && !this._dlFileEntryTypeModelResourcePermission.contains(permissionChecker, classTypeId, "VIEW")) {
            return false;
        }
        return this._portletResourcePermission.contains(permissionChecker, groupId, "ADD_DOCUMENT");
    }

    public boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws Exception {
        return this._fileEntryModelResourcePermission.contains(permissionChecker, classPK, actionId);
    }

    @Reference(unbind="-")
    protected void setDLAppLocalService(DLAppLocalService dlAppLocalService) {
        this._dlAppLocalService = dlAppLocalService;
    }

    @Reference(unbind="-")
    protected void setDLFileEntryLocalService(DLFileEntryLocalService dlFileEntryLocalService) {
        this._dlFileEntryLocalService = dlFileEntryLocalService;
    }

    @Reference(unbind="-")
    protected void setDLFileEntryTypeLocalService(DLFileEntryTypeLocalService dlFileEntryTypeLocalService) {
        this._dlFileEntryTypeLocalService = dlFileEntryTypeLocalService;
    }
}

