/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.portlet.action;

import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.web.internal.portlet.action.ActionUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.PortletResponseUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCResourceCommand;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.zip.ZipWriter;
import com.liferay.portal.kernel.zip.ZipWriterFactoryUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import javax.portlet.MimeResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_document_library_web_portlet_DLPortlet", "javax.portlet.name=com_liferay_document_library_web_portlet_DLAdminPortlet", "javax.portlet.name=com_liferay_document_library_web_portlet_IGDisplayPortlet", "mvc.command.name=/document_library/download_entry", "mvc.command.name=/document_library/download_folder"}, service={MVCResourceCommand.class})
public class DownloadEntriesMVCResourceCommand
implements MVCResourceCommand {
    private DLAppService _dlAppService;

    public boolean serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws PortletException {
        try {
            String resourceID = GetterUtil.getString((String)resourceRequest.getResourceID());
            if (resourceID.equals("/document_library/download_folder")) {
                this.downloadFolder(resourceRequest, resourceResponse);
            } else {
                this.downloadFileEntries(resourceRequest, resourceResponse);
            }
            return false;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void downloadFileEntries(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        block23: {
            ThemeDisplay themeDisplay = (ThemeDisplay)resourceRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            long folderId = ParamUtil.getLong((PortletRequest)resourceRequest, (String)"folderId");
            File file = null;
            try {
                List<FileEntry> fileEntries = ActionUtil.getFileEntries((PortletRequest)resourceRequest);
                List<FileShortcut> fileShortcuts = ActionUtil.getFileShortcuts((PortletRequest)resourceRequest);
                List<Folder> folders = ActionUtil.getFolders((PortletRequest)resourceRequest);
                if (fileEntries.isEmpty() && fileShortcuts.isEmpty() && folders.isEmpty()) {
                    return;
                }
                if (fileEntries.size() == 1 && fileShortcuts.isEmpty() && folders.isEmpty()) {
                    FileEntry fileEntry = fileEntries.get(0);
                    PortletResponseUtil.sendFile((PortletRequest)resourceRequest, (MimeResponse)resourceResponse, (String)fileEntry.getFileName(), (InputStream)fileEntry.getContentStream(), (int)0, (String)fileEntry.getMimeType(), (String)"attachment");
                    break block23;
                }
                if (fileShortcuts.size() == 1 && fileEntries.isEmpty() && folders.isEmpty()) {
                    FileShortcut fileShortcut = fileShortcuts.get(0);
                    FileEntry fileEntry = this._dlAppService.getFileEntry(fileShortcut.getToFileEntryId());
                    PortletResponseUtil.sendFile((PortletRequest)resourceRequest, (MimeResponse)resourceResponse, (String)fileEntry.getFileName(), (InputStream)fileEntry.getContentStream(), (int)0, (String)fileEntry.getMimeType(), (String)"attachment");
                    break block23;
                }
                String zipFileName = this.getZipFileName(folderId, themeDisplay);
                ZipWriter zipWriter = ZipWriterFactoryUtil.getZipWriter();
                for (FileEntry fileEntry : fileEntries) {
                    this.zipFileEntry(fileEntry, "/", zipWriter);
                }
                for (FileShortcut fileShortcut : fileShortcuts) {
                    FileEntry fileEntry = this._dlAppService.getFileEntry(fileShortcut.getToFileEntryId());
                    this.zipFileEntry(fileEntry, "/", zipWriter);
                }
                for (Folder folder : folders) {
                    this.zipFolder(folder.getRepositoryId(), folder.getFolderId(), "/".concat(folder.getName()), zipWriter);
                }
                file = zipWriter.getFile();
                try (FileInputStream inputStream = new FileInputStream(file);){
                    PortletResponseUtil.sendFile((PortletRequest)resourceRequest, (MimeResponse)resourceResponse, (String)zipFileName, (InputStream)inputStream, (String)"application/zip");
                }
            }
            finally {
                if (file != null) {
                    file.delete();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void downloadFolder(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)resourceRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long repositoryId = ParamUtil.getLong((PortletRequest)resourceRequest, (String)"repositoryId");
        long folderId = ParamUtil.getLong((PortletRequest)resourceRequest, (String)"folderId");
        File file = null;
        try {
            String zipFileName = this.getZipFileName(folderId, themeDisplay);
            ZipWriter zipWriter = ZipWriterFactoryUtil.getZipWriter();
            this.zipFolder(repositoryId, folderId, "/", zipWriter);
            file = zipWriter.getFile();
            try (FileInputStream inputStream = new FileInputStream(file);){
                PortletResponseUtil.sendFile((PortletRequest)resourceRequest, (MimeResponse)resourceResponse, (String)zipFileName, (InputStream)inputStream, (String)"application/zip");
            }
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    protected String getZipFileName(long folderId, ThemeDisplay themeDisplay) throws PortalException {
        if (folderId != 0L) {
            Folder folder = this._dlAppService.getFolder(folderId);
            return folder.getName() + ".zip";
        }
        return themeDisplay.getScopeGroupName() + ".zip";
    }

    @Reference(unbind="-")
    protected void setDLAppService(DLAppService dlAppService) {
        this._dlAppService = dlAppService;
    }

    protected void zipFileEntry(FileEntry fileEntry, String path, ZipWriter zipWriter) throws Exception {
        zipWriter.addEntry(path + "/" + fileEntry.getFileName(), fileEntry.getContentStream());
    }

    protected void zipFolder(long repositoryId, long folderId, String path, ZipWriter zipWriter) throws Exception {
        List foldersAndFileEntriesAndFileShortcuts = this._dlAppService.getFoldersAndFileEntriesAndFileShortcuts(repositoryId, folderId, 0, false, -1, -1);
        for (Object entry : foldersAndFileEntriesAndFileShortcuts) {
            if (entry instanceof Folder) {
                Folder folder = (Folder)entry;
                this.zipFolder(folder.getRepositoryId(), folder.getFolderId(), path.concat("/").concat(folder.getName()), zipWriter);
                continue;
            }
            if (entry instanceof FileEntry) {
                this.zipFileEntry((FileEntry)entry, path, zipWriter);
                continue;
            }
            if (!(entry instanceof FileShortcut)) continue;
            FileShortcut fileShortcut = (FileShortcut)entry;
            FileEntry fileEntry = this._dlAppService.getFileEntry(fileShortcut.getToFileEntryId());
            this.zipFileEntry(fileEntry, path, zipWriter);
        }
    }
}

