/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.messaging;

import com.liferay.document.library.configuration.DLConfiguration;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.RepositoryProvider;
import com.liferay.portal.kernel.repository.UndeployedExternalRepositoryException;
import com.liferay.portal.kernel.repository.capabilities.TemporaryFileEntriesCapability;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelper;
import com.liferay.portal.kernel.scheduler.SchedulerEntry;
import com.liferay.portal.kernel.scheduler.SchedulerEntryImpl;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.TriggerFactory;
import com.liferay.portal.kernel.service.RepositoryLocalService;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.document.library.configuration.DLConfiguration"}, immediate=true, service={TempFileEntriesMessageListener.class})
public class TempFileEntriesMessageListener
extends BaseMessageListener {
    private static final Log _log = LogFactoryUtil.getLog(TempFileEntriesMessageListener.class);
    private volatile DLConfiguration _dlConfiguration;
    private RepositoryLocalService _repositoryLocalService;
    private RepositoryProvider _repositoryProvider;
    private SchedulerEngineHelper _schedulerEngineHelper;
    @Reference
    private TriggerFactory _triggerFactory;

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._dlConfiguration = (DLConfiguration)ConfigurableUtil.createConfigurable(DLConfiguration.class, properties);
        Class<?> clazz = ((Object)((Object)this)).getClass();
        String className = clazz.getName();
        Trigger trigger = this._triggerFactory.createTrigger(className, className, null, null, this._dlConfiguration.temporaryFileEntriesCheckInterval(), TimeUnit.HOUR);
        SchedulerEntryImpl schedulerEntry = new SchedulerEntryImpl(className, trigger);
        this._schedulerEngineHelper.register((MessageListener)this, (SchedulerEntry)schedulerEntry, "liferay/scheduler_dispatch");
    }

    @Deactivate
    protected void deactivate() {
        this._schedulerEngineHelper.unregister((MessageListener)this);
    }

    protected void deleteExpiredTemporaryFileEntries(Repository repository) {
        block6: {
            LocalRepository localRepository = null;
            try {
                localRepository = this._repositoryProvider.getLocalRepository(repository.getRepositoryId());
            }
            catch (PortalException | UndeployedExternalRepositoryException e) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Unable to get implementation for repository " + repository.getRepositoryId()), e);
                }
                return;
            }
            try {
                if (localRepository.isCapabilityProvided(TemporaryFileEntriesCapability.class)) {
                    TemporaryFileEntriesCapability temporaryFileEntriesCapability = (TemporaryFileEntriesCapability)localRepository.getCapability(TemporaryFileEntriesCapability.class);
                    temporaryFileEntriesCapability.deleteExpiredTemporaryFileEntries();
                }
            }
            catch (Exception pe) {
                if (!_log.isWarnEnabled()) break block6;
                _log.warn((Object)("Unable to delete expired temporary file entries in repository " + repository.getRepositoryId()), (Throwable)pe);
            }
        }
    }

    protected void doReceive(Message message) throws Exception {
        ActionableDynamicQuery actionableDynamicQuery = this._repositoryLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<Repository>(){

            public void performAction(Repository repository) {
                TempFileEntriesMessageListener.this.deleteExpiredTemporaryFileEntries(repository);
            }
        });
        actionableDynamicQuery.performActions();
    }

    @Reference(target="(module.service.lifecycle=portal.initialized)", unbind="-")
    protected void setModuleServiceLifecycle(ModuleServiceLifecycle moduleServiceLifecycle) {
    }

    @Reference(unbind="-")
    protected void setRepositoryLocalService(RepositoryLocalService repositoryLocalService) {
        this._repositoryLocalService = repositoryLocalService;
    }

    @Reference(unbind="-")
    protected void setRepositoryProvider(RepositoryProvider repositoryProvider) {
        this._repositoryProvider = repositoryProvider;
    }

    @Reference(unbind="-")
    protected void setSchedulerEngineHelper(SchedulerEngineHelper schedulerEngineHelper) {
        this._schedulerEngineHelper = schedulerEngineHelper;
    }
}

