/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.lar;

import com.liferay.document.library.exportimport.data.handler.DLExportableRepositoryPublisher;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.model.DLFileShortcut;
import com.liferay.document.library.kernel.model.DLFileShortcutConstants;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.model.DLFolderConstants;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.kernel.service.DLFileEntryTypeLocalService;
import com.liferay.document.library.kernel.service.DLFileShortcutLocalService;
import com.liferay.document.library.kernel.service.DLFolderLocalService;
import com.liferay.exportimport.kernel.lar.BasePortletDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportDateUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataHandler;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerControl;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerRegistryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.exportimport.kernel.staging.Staging;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Conjunction;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.Disjunction;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.RepositoryLocalService;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.repository.liferayrepository.LiferayRepositoryDefiner;
import com.liferay.portal.repository.temporaryrepository.TemporaryFileEntryRepositoryDefiner;
import com.liferay.portal.util.PropsValues;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.portlet.PortletPreferences;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_document_library_web_portlet_DLPortlet", "javax.portlet.name=com_liferay_document_library_web_portlet_DLAdminPortlet"}, service={PortletDataHandler.class})
public class DLPortletDataHandler
extends BasePortletDataHandler {
    public static final String NAMESPACE = "document_library";
    public static final String SCHEMA_VERSION = "1.0.0";
    @Reference
    private DLAppLocalService _dlAppLocalService;
    private ServiceTrackerList<DLExportableRepositoryPublisher, DLExportableRepositoryPublisher> _dlExportableRepositoryPublishers;
    @Reference
    private DLFileEntryLocalService _dlFileEntryLocalService;
    @Reference
    private DLFileEntryTypeLocalService _dlFileEntryTypeLocalService;
    @Reference
    private DLFileShortcutLocalService _dlFileShortcutLocalService;
    @Reference
    private DLFolderLocalService _dlFolderLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private RepositoryLocalService _repositoryLocalService;
    @Reference
    private Staging _staging;

    public String getSchemaVersion() {
        return SCHEMA_VERSION;
    }

    public String getServiceName() {
        return "com.liferay.document.library";
    }

    public boolean isSupportsDataStrategyMirrorWithOverwriting() {
        return true;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this.setDataLocalized(true);
        this.setDataPortletPreferences(new String[]{"rootFolderId"});
        this.setDeletionSystemEventStagedModelTypes(new StagedModelType[]{new StagedModelType(DLFileEntryType.class), new StagedModelType(DLFileShortcut.class), new StagedModelType(DLFileEntryConstants.getClassName()), new StagedModelType(DLFolderConstants.getClassName()), new StagedModelType(Repository.class.getName(), "referrer-class-name-all")});
        this.setExportControls(new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(NAMESPACE, "repositories", true, false, null, Repository.class.getName(), "referrer-class-name-all"), new PortletDataHandlerBoolean(NAMESPACE, "folders", true, false, null, DLFolderConstants.getClassName()), new PortletDataHandlerBoolean(NAMESPACE, "documents", true, false, new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(NAMESPACE, "previews-and-thumbnails")}, DLFileEntryConstants.getClassName()), new PortletDataHandlerBoolean(NAMESPACE, "document-types", true, false, null, DLFileEntryType.class.getName()), new PortletDataHandlerBoolean(NAMESPACE, "shortcuts", true, false, null, DLFileShortcutConstants.getClassName())});
        this.setPublishToLiveByDefault(PropsValues.DL_PUBLISH_TO_LIVE_BY_DEFAULT);
        this.setRank(90);
        this.setStagingControls(this.getExportControls());
        this._dlExportableRepositoryPublishers = ServiceTrackerListFactory.open((BundleContext)bundleContext, DLExportableRepositoryPublisher.class);
    }

    @Deactivate
    protected void deactivate() {
        if (this._dlExportableRepositoryPublishers != null) {
            this._dlExportableRepositoryPublishers.close();
        }
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        if (portletDataContext.addPrimaryKey(DLPortletDataHandler.class, "deleteData")) {
            return portletPreferences;
        }
        this._dlAppLocalService.deleteAll(portletDataContext.getScopeGroupId());
        this._dlFileEntryTypeLocalService.deleteFileEntryTypes(portletDataContext.getScopeGroupId());
        if (portletPreferences == null) {
            return portletPreferences;
        }
        portletPreferences.setValue("enable-comment-ratings", "");
        portletPreferences.setValue("fileEntriesPerPage", "");
        portletPreferences.setValue("fileEntryColumns", "");
        portletPreferences.setValue("folderColumns", "");
        portletPreferences.setValue("foldersPerPage", "");
        portletPreferences.setValue("rootFolderId", "");
        portletPreferences.setValue("showFoldersSearch", "");
        portletPreferences.setValue("showSubfolders", "");
        return portletPreferences;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        portletDataContext.addPortletPermissions("com.liferay.document.library");
        Element rootElement = this.addExportDataRootElement(portletDataContext);
        rootElement.addAttribute("group-id", String.valueOf(portletDataContext.getScopeGroupId()));
        if (portletDataContext.getBooleanParameter(NAMESPACE, "folders")) {
            ActionableDynamicQuery folderActionableDynamicQuery = this.getFolderActionableDynamicQuery(portletDataContext);
            folderActionableDynamicQuery.performActions();
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "documents")) {
            ActionableDynamicQuery fileEntryActionableDynamicQuery = this.getFileEntryActionableDynamicQuery(portletDataContext);
            fileEntryActionableDynamicQuery.performActions();
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "document-types")) {
            ActionableDynamicQuery fileEntryTypeActionableDynamicQuery = this.getDLFileEntryTypeActionableDynamicQuery(portletDataContext);
            fileEntryTypeActionableDynamicQuery.performActions();
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "repositories")) {
            ActionableDynamicQuery repositoryActionableDynamicQuery = this.getRepositoryActionableDynamicQuery(portletDataContext);
            repositoryActionableDynamicQuery.performActions();
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "shortcuts")) {
            ActionableDynamicQuery fileShortcutActionableDynamicQuery = this.getDLFileShortcutActionableDynamicQuery(portletDataContext);
            fileShortcutActionableDynamicQuery.performActions();
        }
        return this.getExportDataRootElementString(rootElement);
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        portletDataContext.importPortletPermissions("com.liferay.document.library");
        if (portletDataContext.getBooleanParameter(NAMESPACE, "folders")) {
            Element foldersElement = portletDataContext.getImportDataGroupElement(DLFolder.class);
            List folderElements = foldersElement.elements();
            for (Element folderElement : folderElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)folderElement);
            }
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "documents")) {
            Element fileEntriesElement = portletDataContext.getImportDataGroupElement(DLFileEntry.class);
            List fileEntryElements = fileEntriesElement.elements();
            for (Element fileEntryElement : fileEntryElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)fileEntryElement);
            }
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "document-types")) {
            Element fileEntryTypesElement = portletDataContext.getImportDataGroupElement(DLFileEntryType.class);
            List fileEntryTypeElements = fileEntryTypesElement.elements();
            for (Element fileEntryTypeElement : fileEntryTypeElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)fileEntryTypeElement);
            }
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "repositories")) {
            Element repositoriesElement = portletDataContext.getImportDataGroupElement(Repository.class);
            List repositoryElements = repositoriesElement.elements();
            for (Element repositoryElement : repositoryElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)repositoryElement);
            }
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "shortcuts")) {
            Element fileShortcutsElement = portletDataContext.getImportDataGroupElement(DLFileShortcut.class);
            List fileShortcutElements = fileShortcutsElement.elements();
            for (Element fileShortcutElement : fileShortcutElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)fileShortcutElement);
            }
        }
        return portletPreferences;
    }

    protected void doPrepareManifestSummary(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws Exception {
        if (ExportImportDateUtil.isRangeFromLastPublishDate((PortletDataContext)portletDataContext)) {
            this._staging.populateLastPublishDateCounts(portletDataContext, new StagedModelType[]{new StagedModelType(DLFileEntry.class.getName()), new StagedModelType(DLFileEntryType.class.getName()), new StagedModelType(DLFileShortcut.class.getName()), new StagedModelType(DLFolder.class.getName()), new StagedModelType(Repository.class.getName())});
            return;
        }
        ActionableDynamicQuery dlFileShortcutActionableDynamicQuery = this.getDLFileShortcutActionableDynamicQuery(portletDataContext);
        dlFileShortcutActionableDynamicQuery.performCount();
        ActionableDynamicQuery fileEntryActionableDynamicQuery = this.getFileEntryActionableDynamicQuery(portletDataContext);
        fileEntryActionableDynamicQuery.performCount();
        ActionableDynamicQuery fileEntryTypeActionableDynamicQuery = this.getDLFileEntryTypeActionableDynamicQuery(portletDataContext);
        fileEntryTypeActionableDynamicQuery.performCount();
        ActionableDynamicQuery folderActionableDynamicQuery = this.getFolderActionableDynamicQuery(portletDataContext);
        folderActionableDynamicQuery.performCount();
        ActionableDynamicQuery repositoryActionableDynamicQuery = this.getRepositoryActionableDynamicQuery(portletDataContext);
        repositoryActionableDynamicQuery.performCount();
    }

    protected ActionableDynamicQuery getDLFileEntryTypeActionableDynamicQuery(PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery actionableDynamicQuery = this._dlFileEntryTypeLocalService.getExportActionableDynamicQuery(portletDataContext);
        ActionableDynamicQuery.AddCriteriaMethod addCriteriaMethod = actionableDynamicQuery.getAddCriteriaMethod();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            addCriteriaMethod.addCriteria(dynamicQuery);
            Property property = PropertyFactoryUtil.forName((String)"groupId");
            dynamicQuery.add(property.in((Object[])new Long[]{portletDataContext.getScopeGroupId()}));
        });
        actionableDynamicQuery.setPerformActionMethod(dlFileEntryType -> {
            if (dlFileEntryType.isExportable()) {
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)dlFileEntryType);
            }
        });
        return actionableDynamicQuery;
    }

    protected ActionableDynamicQuery getDLFileShortcutActionableDynamicQuery(PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = this._dlFileShortcutLocalService.getExportActionableDynamicQuery(portletDataContext);
        ActionableDynamicQuery.AddCriteriaMethod addCriteriaMethod = exportActionableDynamicQuery.getAddCriteriaMethod();
        exportActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            addCriteriaMethod.addCriteria(dynamicQuery);
            Property property = PropertyFactoryUtil.forName((String)"active");
            dynamicQuery.add(property.eq((Object)Boolean.TRUE));
        });
        exportActionableDynamicQuery.setPerformActionMethod(dlFileShortcut -> {
            FileShortcut fileShortcut = this._dlAppLocalService.getFileShortcut(dlFileShortcut.getFileShortcutId());
            StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)fileShortcut);
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(DLFileShortcutConstants.getClassName()));
        return exportActionableDynamicQuery;
    }

    protected ActionableDynamicQuery getFileEntryActionableDynamicQuery(PortletDataContext portletDataContext) {
        Collection<Long> exportableRepositoryIds = this._getExportableRepositoryIds(portletDataContext);
        ExportActionableDynamicQuery exportActionableDynamicQuery = this._dlFileEntryLocalService.getExportActionableDynamicQuery(portletDataContext);
        exportActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            DynamicQuery fileVersionDynamicQuery = DynamicQueryFactoryUtil.forClass(DLFileVersion.class, (String)"dlFileVersion", (ClassLoader)PortalClassLoaderUtil.getClassLoader());
            fileVersionDynamicQuery.setProjection(ProjectionFactoryUtil.property((String)"fileEntryId"));
            fileVersionDynamicQuery.add(RestrictionsFactoryUtil.eqProperty((String)"dlFileVersion.fileEntryId", (String)"this.fileEntryId"));
            fileVersionDynamicQuery.add(RestrictionsFactoryUtil.eqProperty((String)"dlFileVersion.version", (String)"this.version"));
            Property fileVersionStatusProperty = PropertyFactoryUtil.forName((String)"dlFileVersion.status");
            StagedModelDataHandler stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler((String)DLFileEntry.class.getName());
            fileVersionDynamicQuery.add(fileVersionStatusProperty.in(stagedModelDataHandler.getExportableStatuses()));
            Criterion fileVersionModifiedDateCriterion = portletDataContext.getDateRangeCriteria("dlFileVersion.modifiedDate");
            Criterion fileVersionStatusDateCriterion = portletDataContext.getDateRangeCriteria("dlFileVersion.statusDate");
            Criterion modifiedDateCriterion = portletDataContext.getDateRangeCriteria("this.modifiedDate");
            if (fileVersionStatusDateCriterion != null && modifiedDateCriterion != null) {
                Disjunction disjunction = RestrictionsFactoryUtil.disjunction();
                disjunction.add(fileVersionModifiedDateCriterion);
                disjunction.add(fileVersionStatusDateCriterion);
                disjunction.add(modifiedDateCriterion);
                fileVersionDynamicQuery.add((Criterion)disjunction);
            }
            Property fileEntryIdProperty = PropertyFactoryUtil.forName((String)"fileEntryId");
            dynamicQuery.add(fileEntryIdProperty.in(fileVersionDynamicQuery));
            Property repositoryIdProperty = PropertyFactoryUtil.forName((String)"repositoryId");
            dynamicQuery.add(repositoryIdProperty.in(exportableRepositoryIds));
        });
        exportActionableDynamicQuery.setPerformActionMethod(dlFileEntry -> {
            FileEntry fileEntry = this._dlAppLocalService.getFileEntry(dlFileEntry.getFileEntryId());
            StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)fileEntry);
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(DLFileEntryConstants.getClassName()));
        return exportActionableDynamicQuery;
    }

    protected ActionableDynamicQuery getFolderActionableDynamicQuery(PortletDataContext portletDataContext) {
        Collection<Long> exportableRepositoryIds = this._getExportableRepositoryIds(portletDataContext);
        ExportActionableDynamicQuery exportActionableDynamicQuery = this._dlFolderLocalService.getExportActionableDynamicQuery(portletDataContext);
        ActionableDynamicQuery.AddCriteriaMethod addCriteriaMethod = exportActionableDynamicQuery.getAddCriteriaMethod();
        exportActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            addCriteriaMethod.addCriteria(dynamicQuery);
            Property property = PropertyFactoryUtil.forName((String)"repositoryId");
            dynamicQuery.add(property.in(exportableRepositoryIds));
        });
        exportActionableDynamicQuery.setPerformActionMethod(dlFolder -> {
            if (dlFolder.isInTrash()) {
                return;
            }
            Folder folder = this._dlAppLocalService.getFolder(dlFolder.getFolderId());
            StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)folder);
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(DLFolderConstants.getClassName()));
        return exportActionableDynamicQuery;
    }

    protected ActionableDynamicQuery getRepositoryActionableDynamicQuery(PortletDataContext portletDataContext) {
        Collection<Long> exportableRepositoryIds = this._getExportableRepositoryIds(portletDataContext);
        ExportActionableDynamicQuery exportActionableDynamicQuery = this._repositoryLocalService.getExportActionableDynamicQuery(portletDataContext);
        ActionableDynamicQuery.AddCriteriaMethod addCriteriaMethod = exportActionableDynamicQuery.getAddCriteriaMethod();
        exportActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            addCriteriaMethod.addCriteria(dynamicQuery);
            Conjunction conjunction = RestrictionsFactoryUtil.conjunction();
            Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
            long liferayRepositoryClassNameId = this._portal.getClassNameId(LiferayRepositoryDefiner.CLASS_NAME);
            conjunction.add(classNameIdProperty.ne((Object)liferayRepositoryClassNameId));
            long tempFileRepositoryClassNameId = this._portal.getClassNameId(TemporaryFileEntryRepositoryDefiner.CLASS_NAME);
            conjunction.add(classNameIdProperty.ne((Object)tempFileRepositoryClassNameId));
            dynamicQuery.add((Criterion)conjunction);
            Disjunction disjunction = RestrictionsFactoryUtil.disjunction();
            Property portletIdProperty = PropertyFactoryUtil.forName((String)"portletId");
            disjunction.add(portletIdProperty.isNull());
            disjunction.add(portletIdProperty.eq((Object)""));
            disjunction.add(portletIdProperty.eq((Object)"com_liferay_document_library_web_portlet_DLAdminPortlet"));
            disjunction.add(portletIdProperty.like((Object)"com_liferay_document_library_web_portlet_DLPortlet%"));
            Property repositoryIdProperty = PropertyFactoryUtil.forName((String)"repositoryId");
            disjunction.add(repositoryIdProperty.in(exportableRepositoryIds));
            dynamicQuery.add((Criterion)disjunction);
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(this._portal.getClassNameId(Repository.class.getName()), -1L));
        return exportActionableDynamicQuery;
    }

    private Collection<Long> _getExportableRepositoryIds(PortletDataContext portletDataContext) {
        HashSet<Long> exportableRepositoryIds = new HashSet<Long>();
        exportableRepositoryIds.add(portletDataContext.getScopeGroupId());
        for (DLExportableRepositoryPublisher dlExportableRepositoryPublisher : this._dlExportableRepositoryPublishers) {
            dlExportableRepositoryPublisher.publish(portletDataContext.getScopeGroupId(), exportableRepositoryIds::add);
        }
        return exportableRepositoryIds;
    }
}

