/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.exportimport.lifecycle;

import aQute.bnd.annotation.ProviderType;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLFileEntryTypeLocalService;
import com.liferay.document.library.kernel.service.DLFolderLocalService;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lifecycle.EventAwareExportImportLifecycleListener;
import com.liferay.exportimport.kernel.lifecycle.ExportImportLifecycleListener;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ExportImportLifecycleListener.class})
@ProviderType
public class CascadeFileEntryTypesExportImportLifecycleListener
implements EventAwareExportImportLifecycleListener {
    private DLFileEntryTypeLocalService _dlFileEntryTypeLocalService;
    private DLFolderLocalService _dlFolderLocalService;
    private Map<Long, Long> _importedFolderIds;
    private Set<Long> _processedFolderIds;

    public boolean isParallel() {
        return true;
    }

    public void onLayoutExportFailed(PortletDataContext portletDataContext, Throwable throwable) throws Exception {
    }

    public void onLayoutExportStarted(PortletDataContext portletDataContext) throws Exception {
    }

    public void onLayoutExportSucceeded(PortletDataContext portletDataContext) throws Exception {
    }

    public void onLayoutImportFailed(PortletDataContext portletDataContext, Throwable throwable) throws Exception {
    }

    public void onLayoutImportProcessFinished(PortletDataContext portletDataContext) throws Exception {
        this._importedFolderIds = portletDataContext.getNewPrimaryKeysMap(DLFolder.class);
        if (MapUtil.isEmpty(this._importedFolderIds)) {
            return;
        }
        this._processedFolderIds = new HashSet<Long>();
        this.processFolderIds(this._importedFolderIds.values());
    }

    public void onLayoutImportStarted(PortletDataContext portletDataContext) throws Exception {
    }

    public void onLayoutImportSucceeded(PortletDataContext portletDataContext) throws Exception {
    }

    public void onLayoutLocalPublicationFailed(ExportImportConfiguration exportImportConfiguration, Throwable throwable) throws Exception {
    }

    public void onLayoutLocalPublicationStarted(ExportImportConfiguration exportImportConfiguration) throws Exception {
    }

    public void onLayoutLocalPublicationSucceeded(ExportImportConfiguration exportImportConfiguration) throws Exception {
    }

    public void onLayoutRemotePublicationFailed(ExportImportConfiguration exportImportConfiguration, Throwable throwable) throws Exception {
    }

    public void onLayoutRemotePublicationStarted(ExportImportConfiguration exportImportConfiguration) throws Exception {
    }

    public void onLayoutRemotePublicationSucceeded(ExportImportConfiguration exportImportConfiguration) throws Exception {
    }

    public void onPortletExportFailed(PortletDataContext portletDataContext, Throwable throwable) throws Exception {
    }

    public void onPortletExportStarted(PortletDataContext portletDataContext) throws Exception {
    }

    public void onPortletExportSucceeded(PortletDataContext portletDataContext) throws Exception {
    }

    public void onPortletImportFailed(PortletDataContext portletDataContext, Throwable throwable) throws Exception {
    }

    public void onPortletImportProcessFinished(PortletDataContext portletDataContext) throws Exception {
        this._importedFolderIds = portletDataContext.getNewPrimaryKeysMap(DLFolder.class);
        if (MapUtil.isEmpty(this._importedFolderIds)) {
            return;
        }
        this._processedFolderIds = new HashSet<Long>();
        this.processFolderIds(this._importedFolderIds.values());
    }

    public void onPortletImportStarted(PortletDataContext portletDataContext) throws Exception {
    }

    public void onPortletImportSucceeded(PortletDataContext portletDataContext) throws Exception {
    }

    public void onPortletPublicationFailed(ExportImportConfiguration exportImportConfiguration, Throwable throwable) throws Exception {
    }

    public void onPortletPublicationStarted(ExportImportConfiguration exportImportConfiguration) throws Exception {
    }

    public void onPortletPublicationSucceeded(ExportImportConfiguration exportImportConfiguration) throws Exception {
    }

    public void onStagedModelExportFailed(PortletDataContext portletDataContext, StagedModel stagedModel, Throwable throwable) throws Exception {
    }

    public void onStagedModelExportStarted(PortletDataContext portletDataContext, StagedModel stagedModel) throws Exception {
    }

    public void onStagedModelExportSucceeded(PortletDataContext portletDataContext, StagedModel stagedModel) throws Exception {
    }

    public void onStagedModelImportFailed(PortletDataContext portletDataContext, StagedModel stagedModel, Throwable throwable) throws Exception {
    }

    public void onStagedModelImportStarted(PortletDataContext portletDataContext, StagedModel stagedModel) throws Exception {
    }

    public void onStagedModelImportSucceeded(PortletDataContext portletDataContext, StagedModel stagedModel) throws Exception {
    }

    protected DLFolder getProcessableRootFolder(DLFolder dlFolder) throws PortalException {
        long dlFolderId = dlFolder.getFolderId();
        if (this._processedFolderIds.contains(dlFolderId)) {
            return null;
        }
        this._processedFolderIds.add(dlFolderId);
        DLFolder parentFolder = dlFolder.getParentFolder();
        if (parentFolder == null || !this._importedFolderIds.containsValue(parentFolder.getFolderId())) {
            return dlFolder;
        }
        return this.getProcessableRootFolder(parentFolder);
    }

    protected void processFolderIds(Collection<Long> folderIds) throws PortalException {
        for (Long folderId : folderIds) {
            DLFolder dlFolder = this._dlFolderLocalService.fetchDLFolder(folderId.longValue());
            DLFolder rootFolder = this.getProcessableRootFolder(dlFolder);
            if (rootFolder == null) continue;
            this._dlFileEntryTypeLocalService.cascadeFileEntryTypes(rootFolder.getUserId(), rootFolder);
        }
    }

    @Reference(unbind="-")
    protected void setDLFileEntryTypeLocalService(DLFileEntryTypeLocalService dlFileEntryTypeLocalService) {
        this._dlFileEntryTypeLocalService = dlFileEntryTypeLocalService;
    }

    @Reference(unbind="-")
    protected void setDlFolderLocalService(DLFolderLocalService dlFolderLocalService) {
        this._dlFolderLocalService = dlFolderLocalService;
    }
}

