/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.display.context.logic;

import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.portal.kernel.repository.model.FileVersion;

public class FileVersionDisplayContextHelper {
    private Boolean _approved;
    private Boolean _draft;
    private final FileVersion _fileVersion;
    private Boolean _officeDoc;
    private Boolean _pending;

    public FileVersionDisplayContextHelper(FileVersion fileVersion) {
        this._fileVersion = fileVersion;
        if (this._fileVersion == null) {
            this._approved = false;
            this._draft = false;
            this._officeDoc = false;
            this._pending = false;
        }
    }

    public FileVersion getFileVersion() {
        return this._fileVersion;
    }

    public boolean isApproved() {
        if (this._approved == null) {
            this._approved = this._fileVersion.isApproved();
        }
        return this._approved;
    }

    public boolean isDLFileVersion() {
        return this._fileVersion.getModel() instanceof DLFileVersion;
    }

    public boolean isDraft() {
        if (this._draft == null) {
            this._draft = this._fileVersion.isDraft();
        }
        return this._draft;
    }

    public boolean isMsOffice() {
        if (this._officeDoc == null) {
            this._officeDoc = DLUtil.isOfficeExtension((String)this._fileVersion.getExtension());
        }
        return this._officeDoc;
    }

    public boolean isPending() {
        if (this._pending == null) {
            this._pending = this._fileVersion.isPending();
        }
        return this._pending;
    }
}

