/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.util;

import com.liferay.document.library.kernel.service.DLAppLocalServiceUtil;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.Collections;
import java.util.List;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class IGUtil {
    public static void addPortletBreadcrumbEntries(Folder folder, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        String mvcRenderCommandName = ParamUtil.getString((HttpServletRequest)request, (String)"mvcRenderCommandName");
        PortletURL portletURL = renderResponse.createRenderURL();
        if (mvcRenderCommandName.equals("/document_library/select_folder")) {
            ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            portletURL.setParameter("mvcRenderCommandName", mvcRenderCommandName);
            portletURL.setWindowState(LiferayWindowState.POP_UP);
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)themeDisplay.translate("home"), (String)portletURL.toString());
        } else {
            portletURL.setParameter("mvcRenderCommandName", "/image_gallery_display/view");
        }
        long rootFolderId = IGUtil.getRootFolderId(request);
        List ancestorFolders = Collections.emptyList();
        if (folder != null && folder.getFolderId() != rootFolderId) {
            ancestorFolders = folder.getAncestors();
            int indexOfRootFolder = -1;
            for (int i = 0; i < ancestorFolders.size(); ++i) {
                Folder ancestorFolder = (Folder)ancestorFolders.get(i);
                if (rootFolderId != ancestorFolder.getFolderId()) continue;
                indexOfRootFolder = i;
            }
            if (indexOfRootFolder > -1) {
                ancestorFolders = ancestorFolders.subList(0, indexOfRootFolder);
            }
        }
        Collections.reverse(ancestorFolders);
        for (Folder ancestorFolder : ancestorFolders) {
            portletURL.setParameter("folderId", String.valueOf(ancestorFolder.getFolderId()));
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)ancestorFolder.getName(), (String)portletURL.toString());
        }
        portletURL.setParameter("folderId", String.valueOf(folder.getFolderId()));
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)folder.getName(), (String)portletURL.toString());
    }

    public static void addPortletBreadcrumbEntries(long folderId, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        if (folderId == 0L) {
            return;
        }
        Folder folder = DLAppLocalServiceUtil.getFolder((long)folderId);
        IGUtil.addPortletBreadcrumbEntries(folder, request, renderResponse);
    }

    protected static long getRootFolderId(HttpServletRequest request) throws Exception {
        PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.getPortletPreferences((HttpServletRequest)request, (String)PortalUtil.getPortletId((HttpServletRequest)request));
        return GetterUtil.getLong((String)portletPreferences.getValue("rootFolderId", String.valueOf(0L)));
    }
}

