/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.portlet.action;

import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.exportimport.changeset.Changeset;
import com.liferay.exportimport.changeset.portlet.action.ExportImportChangesetMVCActionCommand;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.ParamUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_document_library_web_portlet_DLAdminPortlet", "mvc.command.name=/document_library/publish_file_entry"}, service={MVCActionCommand.class})
public class PublishFileEntryMVCActionCommand
extends BaseMVCActionCommand {
    private static final Log _log = LogFactoryUtil.getLog(PublishFileEntryMVCActionCommand.class);
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private ExportImportChangesetMVCActionCommand _exportImportChangesetMVCActionCommand;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long fileEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"fileEntryId");
        Changeset.Builder builder = Changeset.create();
        Changeset changeset = builder.addStagedModel(() -> this._fetchFileEntry(fileEntryId)).build();
        this._exportImportChangesetMVCActionCommand.processPublishAction(actionRequest, actionResponse, changeset);
    }

    private FileEntry _fetchFileEntry(long fileEntryId) {
        try {
            return this._dlAppLocalService.getFileEntry(fileEntryId);
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to get file entry " + fileEntryId), (Throwable)pe);
            }
            return null;
        }
    }
}

