/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.portlet.action;

import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.kernel.service.DLFolderLocalService;
import com.liferay.document.library.repository.authorization.capability.AuthorizationCapability;
import com.liferay.document.library.web.internal.portlet.action.GetFolderMVCRenderCommand;
import com.liferay.document.library.web.internal.portlet.toolbar.contributor.DLPortletToolbarContributorRegistry;
import com.liferay.document.library.web.internal.util.DLTrashUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCRenderCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCRenderConstants;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.RepositoryProviderUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_document_library_web_portlet_DLPortlet", "javax.portlet.name=com_liferay_document_library_web_portlet_DLAdminPortlet", "mvc.command.name=/", "mvc.command.name=/document_library/view", "mvc.command.name=/document_library/view_folder"}, service={MVCRenderCommand.class})
public class DLViewMVCRenderCommand
extends GetFolderMVCRenderCommand {
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private DLFolderLocalService _dlFolderLocalService;
    @Reference
    private DLPortletToolbarContributorRegistry _dlPortletToolbarContributorRegistry;
    @Reference
    private DLTrashUtil _dlTrashUtil;

    @Override
    public String render(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException {
        renderRequest.setAttribute("DOCUMENT_LIBRARY_PORTLET_TOOLBAR_CONTRIBUTOR", (Object)this._dlPortletToolbarContributorRegistry.getDLPortletToolbarContributor());
        try {
            if (this.pingFolderRepository(renderRequest, renderResponse)) {
                return MVCRenderConstants.MVC_PATH_VALUE_SKIP_DISPATCH;
            }
        }
        catch (Exception e) {
            SessionErrors.add((PortletRequest)renderRequest, (String)"repositoryPingFailed", (Object)e);
            return "/document_library/error.jsp";
        }
        return super.render(renderRequest, renderResponse);
    }

    @Override
    protected DLTrashUtil getDLTrashUtil() {
        return this._dlTrashUtil;
    }

    @Override
    protected String getPath() {
        return "/document_library/view.jsp";
    }

    protected boolean pingFolderRepository(RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        String mvcRenderCommandName = ParamUtil.getString((PortletRequest)renderRequest, (String)"mvcRenderCommandName");
        if (!mvcRenderCommandName.equals("/document_library/view_folder")) {
            return false;
        }
        long folderId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"folderId");
        if (folderId == 0L) {
            return false;
        }
        DLFolder dlFolder = this._dlFolderLocalService.fetchDLFolder(folderId);
        if (dlFolder == null || !dlFolder.isMountPoint()) {
            return false;
        }
        Repository repository = RepositoryProviderUtil.getRepository((long)dlFolder.getRepositoryId());
        if (repository.isCapabilityProvided(AuthorizationCapability.class)) {
            AuthorizationCapability authorizationCapability = (AuthorizationCapability)repository.getCapability(AuthorizationCapability.class);
            authorizationCapability.authorize((PortletRequest)renderRequest, (PortletResponse)renderResponse);
            return authorizationCapability.hasCustomRedirectFlow((PortletRequest)renderRequest, (PortletResponse)renderResponse);
        }
        this._dlAppService.getFileEntriesCount(dlFolder.getRepositoryId(), dlFolder.getFolderId());
        return false;
    }
}

