/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.portlet.action;

import com.liferay.document.library.kernel.document.conversion.DocumentConversionUtil;
import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.portal.kernel.diff.DiffUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCRenderCommand;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_document_library_web_portlet_DLPortlet", "javax.portlet.name=com_liferay_document_library_web_portlet_DLAdminPortlet", "javax.portlet.name=com_liferay_document_library_web_portlet_IGDisplayPortlet", "mvc.command.name=/document_library/compare_versions"}, service={MVCRenderCommand.class})
public class CompareVersionsMVCRenderCommand
implements MVCRenderCommand {
    private DLAppLocalService _dlAppLocalService;
    private DLAppService _dlAppService;

    public String render(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException {
        try {
            this.compareVersions(renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchFileEntryException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e.getClass());
                return "/document_library/error.jsp";
            }
            throw new PortletException((Throwable)e);
        }
        return "/document_library/compare_versions.jsp";
    }

    protected void compareVersions(RenderRequest renderRequest) throws Exception {
        long sourceFileVersionId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"sourceFileVersionId");
        long targetFileVersionId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"targetFileVersionId");
        FileVersion sourceFileVersion = this._dlAppService.getFileVersion(sourceFileVersionId);
        InputStream sourceIs = sourceFileVersion.getContentStream(false);
        String sourceExtension = sourceFileVersion.getExtension();
        if (sourceExtension.equals("css") || sourceExtension.equals("htm") || sourceExtension.equals("html") || sourceExtension.equals("js") || sourceExtension.equals("txt") || sourceExtension.equals("xml")) {
            String sourceContent = HtmlUtil.escape((String)StringUtil.read((InputStream)sourceIs));
            sourceIs = new UnsyncByteArrayInputStream(sourceContent.getBytes("UTF-8"));
        }
        FileVersion targetFileVersion = this._dlAppLocalService.getFileVersion(targetFileVersionId);
        InputStream targetIs = targetFileVersion.getContentStream(false);
        String targetExtension = targetFileVersion.getExtension();
        if (targetExtension.equals("css") || targetExtension.equals("htm") || targetExtension.equals("html") || targetExtension.equals("js") || targetExtension.equals("txt") || targetExtension.equals("xml")) {
            String targetContent = HtmlUtil.escape((String)StringUtil.read((InputStream)targetIs));
            targetIs = new UnsyncByteArrayInputStream(targetContent.getBytes("UTF-8"));
        }
        if (DocumentConversionUtil.isEnabled()) {
            if (DocumentConversionUtil.isConvertBeforeCompare((String)sourceExtension)) {
                String sourceTempFileId = DLUtil.getTempFileId((long)sourceFileVersion.getFileEntryId(), (String)sourceFileVersion.getVersion());
                sourceIs = new FileInputStream(DocumentConversionUtil.convert((String)sourceTempFileId, (InputStream)sourceIs, (String)sourceExtension, (String)"txt"));
            }
            if (DocumentConversionUtil.isConvertBeforeCompare((String)targetExtension)) {
                String targetTempFileId = DLUtil.getTempFileId((long)targetFileVersion.getFileEntryId(), (String)targetFileVersion.getVersion());
                targetIs = new FileInputStream(DocumentConversionUtil.convert((String)targetTempFileId, (InputStream)targetIs, (String)targetExtension, (String)"txt"));
            }
        }
        List[] diffResults = DiffUtil.diff((Reader)new InputStreamReader(sourceIs), (Reader)new InputStreamReader(targetIs));
        renderRequest.setAttribute("DIFF_RESULTS", (Object)diffResults);
        renderRequest.setAttribute("SOURCE_NAME", (Object)(sourceFileVersion.getTitle() + " " + sourceFileVersion.getVersion()));
        renderRequest.setAttribute("TARGET_NAME", (Object)(targetFileVersion.getTitle() + " " + targetFileVersion.getVersion()));
    }

    @Reference(unbind="-")
    protected void setDLAppLocalService(DLAppLocalService dlAppLocalService) {
        this._dlAppLocalService = dlAppLocalService;
    }

    @Reference(unbind="-")
    protected void setDLAppService(DLAppService dlAppService) {
        this._dlAppService = dlAppService;
    }
}

