/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.portlet.action;

import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.exception.NoSuchFolderException;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLAppServiceUtil;
import com.liferay.document.library.kernel.util.RawMetadataProcessorUtil;
import com.liferay.document.library.web.internal.security.permission.resource.DLPermission;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.RepositoryServiceUtil;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;

public class ActionUtil {
    private static final Log _log = LogFactoryUtil.getLog(ActionUtil.class);

    public static List<FileEntry> getFileEntries(HttpServletRequest request) throws PortalException {
        long[] fileEntryIds;
        ArrayList<FileEntry> fileEntries = new ArrayList<FileEntry>();
        for (long fileEntryId : fileEntryIds = ParamUtil.getLongValues((HttpServletRequest)request, (String)"rowIdsFileEntry")) {
            try {
                FileEntry fileEntry = DLAppServiceUtil.getFileEntry((long)fileEntryId);
                fileEntries.add(fileEntry);
            }
            catch (NoSuchFileEntryException nsfee) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)nsfee, (Throwable)nsfee);
            }
        }
        return fileEntries;
    }

    public static List<FileEntry> getFileEntries(PortletRequest portletRequest) throws PortalException {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        return ActionUtil.getFileEntries(request);
    }

    public static FileEntry getFileEntry(HttpServletRequest request) throws PortalException {
        long fileEntryId = ParamUtil.getLong((HttpServletRequest)request, (String)"fileEntryId");
        FileEntry fileEntry = null;
        if (fileEntryId > 0L) {
            fileEntry = DLAppServiceUtil.getFileEntry((long)fileEntryId);
        }
        if (fileEntry == null) {
            return null;
        }
        String cmd = ParamUtil.getString((HttpServletRequest)request, (String)"cmd");
        if (fileEntry.isInTrash() && !cmd.equals("move_from_trash")) {
            throw new NoSuchFileEntryException("{fileEntryId=" + fileEntryId + "}");
        }
        return fileEntry;
    }

    public static FileEntry getFileEntry(PortletRequest portletRequest) throws PortalException {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        return ActionUtil.getFileEntry(request);
    }

    public static FileShortcut getFileShortcut(HttpServletRequest request) throws PortalException {
        long fileShortcutId = ParamUtil.getLong((HttpServletRequest)request, (String)"fileShortcutId");
        FileShortcut fileShortcut = null;
        if (fileShortcutId > 0L) {
            fileShortcut = DLAppServiceUtil.getFileShortcut((long)fileShortcutId);
        }
        return fileShortcut;
    }

    public static FileShortcut getFileShortcut(PortletRequest portletRequest) throws PortalException {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        return ActionUtil.getFileShortcut(request);
    }

    public static List<FileShortcut> getFileShortcuts(HttpServletRequest request) throws PortalException {
        long[] fileShortcutIds = ParamUtil.getLongValues((HttpServletRequest)request, (String)"rowIdsDLFileShortcut");
        ArrayList<FileShortcut> fileShortcuts = new ArrayList<FileShortcut>();
        for (long fileShortcutId : fileShortcutIds) {
            if (fileShortcutId <= 0L) continue;
            fileShortcuts.add(DLAppServiceUtil.getFileShortcut((long)fileShortcutId));
        }
        return fileShortcuts;
    }

    public static List<FileShortcut> getFileShortcuts(PortletRequest portletRequest) throws PortalException {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        return ActionUtil.getFileShortcuts(request);
    }

    public static FileVersion getFileVersion(HttpServletRequest request, FileEntry fileEntry) throws PortalException {
        if (fileEntry == null) {
            return null;
        }
        FileVersion fileVersion = null;
        String version = ParamUtil.getString((HttpServletRequest)request, (String)"version");
        fileVersion = Validator.isNotNull((String)version) ? fileEntry.getFileVersion(version) : fileEntry.getFileVersion();
        if (RawMetadataProcessorUtil.isSupported((FileVersion)fileVersion)) {
            RawMetadataProcessorUtil.generateMetadata((FileVersion)fileVersion);
        }
        return fileVersion;
    }

    public static FileVersion getFileVersion(PortletRequest portletRequest, FileEntry fileEntry) throws PortalException {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        return ActionUtil.getFileVersion(request, fileEntry);
    }

    public static Folder getFolder(HttpServletRequest request) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long folderId = ParamUtil.getLong((HttpServletRequest)request, (String)"folderId");
        boolean ignoreRootFolder = ParamUtil.getBoolean((HttpServletRequest)request, (String)"ignoreRootFolder");
        if (folderId <= 0L && !ignoreRootFolder) {
            PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
            String portletId = portletDisplay.getId();
            PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.getPortletPreferences((HttpServletRequest)request, (String)portletId);
            folderId = GetterUtil.getLong((String)portletPreferences.getValue("rootFolderId", null));
        }
        Folder folder = null;
        if (folderId > 0L) {
            DLFolder dlFolder;
            folder = DLAppServiceUtil.getFolder((long)folderId);
            if (folder.getModel() instanceof DLFolder && (dlFolder = (DLFolder)folder.getModel()).isInTrash()) {
                throw new NoSuchFolderException("{folderId=" + folderId + "}");
            }
        } else {
            DLPermission.check(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), "VIEW");
        }
        return folder;
    }

    public static Folder getFolder(PortletRequest portletRequest) throws PortalException {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        return ActionUtil.getFolder(request);
    }

    public static List<Folder> getFolders(HttpServletRequest request) throws PortalException {
        long[] folderIds = ParamUtil.getLongValues((HttpServletRequest)request, (String)"rowIdsFolder");
        ArrayList<Folder> folders = new ArrayList<Folder>();
        for (long folderId : folderIds) {
            try {
                Folder folder = DLAppServiceUtil.getFolder((long)folderId);
                folders.add(folder);
            }
            catch (NoSuchFolderException nsfe) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)nsfe, (Throwable)nsfe);
            }
        }
        return folders;
    }

    public static List<Folder> getFolders(PortletRequest portletRequest) throws PortalException {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        return ActionUtil.getFolders(request);
    }

    public static Repository getRepository(HttpServletRequest request) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long repositoryId = ParamUtil.getLong((HttpServletRequest)request, (String)"repositoryId");
        Repository repository = null;
        if (repositoryId > 0L) {
            repository = RepositoryServiceUtil.getRepository((long)repositoryId);
        } else {
            DLPermission.check(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), "VIEW");
        }
        return repository;
    }

    public static Repository getRepository(PortletRequest portletRequest) throws PortalException {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        return ActionUtil.getRepository(request);
    }
}

