/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.lar;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.model.DLFileShortcut;
import com.liferay.document.library.kernel.model.DLFileShortcutConstants;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.model.DLFolderConstants;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.kernel.service.DLFileEntryTypeLocalService;
import com.liferay.document.library.web.internal.lar.DLPortletDataHandler;
import com.liferay.exportimport.kernel.lar.BasePortletDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportDateUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataHandler;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerControl;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.exportimport.kernel.staging.Staging;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.exportimport.staged.model.repository.StagedModelRepositoryRegistryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.model.RepositoryEntry;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.util.PropsValues;
import java.util.List;
import javax.portlet.PortletPreferences;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_document_library_web_portlet_DLAdminPortlet"}, service={PortletDataHandler.class})
public class DLAdminPortletDataHandler
extends BasePortletDataHandler {
    public static final String[] CLASS_NAMES = new String[]{DLFileEntryConstants.getClassName(), DLFileEntryType.class.getName(), DLFileShortcutConstants.getClassName(), DLFolderConstants.getClassName(), Repository.class.getName(), RepositoryEntry.class.getName()};
    public static final String NAMESPACE = "document_library";
    public static final String SCHEMA_VERSION = "1.0.0";
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private DLFileEntryTypeLocalService _dlFileEntryTypeLocalService;
    @Reference
    private Staging _staging;

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public String getSchemaVersion() {
        return SCHEMA_VERSION;
    }

    public String getServiceName() {
        return "com.liferay.document.library";
    }

    public boolean isSupportsDataStrategyMirrorWithOverwriting() {
        return true;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this.setDataLocalized(true);
        this.setDeletionSystemEventStagedModelTypes(new StagedModelType[]{new StagedModelType(DLFileEntryType.class), new StagedModelType(DLFileShortcut.class), new StagedModelType(DLFileEntryConstants.getClassName()), new StagedModelType(DLFolderConstants.getClassName()), new StagedModelType(Repository.class.getName(), "referrer-class-name-all")});
        this.setExportControls(new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(NAMESPACE, "repositories", true, false, null, Repository.class.getName(), "referrer-class-name-all"), new PortletDataHandlerBoolean(NAMESPACE, "folders", true, false, null, DLFolderConstants.getClassName()), new PortletDataHandlerBoolean(NAMESPACE, "documents", true, false, new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(NAMESPACE, "previews-and-thumbnails")}, DLFileEntryConstants.getClassName()), new PortletDataHandlerBoolean(NAMESPACE, "document-types", true, false, null, DLFileEntryType.class.getName()), new PortletDataHandlerBoolean(NAMESPACE, "shortcuts", true, false, null, DLFileShortcutConstants.getClassName())});
        this.setPublishToLiveByDefault(PropsValues.DL_PUBLISH_TO_LIVE_BY_DEFAULT);
        this.setRank(90);
        this.setStagingControls(this.getExportControls());
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        if (portletDataContext.addPrimaryKey(DLPortletDataHandler.class, "deleteData")) {
            return portletPreferences;
        }
        this._dlAppLocalService.deleteAll(portletDataContext.getScopeGroupId());
        this._dlFileEntryTypeLocalService.deleteFileEntryTypes(portletDataContext.getScopeGroupId());
        if (portletPreferences == null) {
            return portletPreferences;
        }
        portletPreferences.setValue("enable-comment-ratings", "");
        portletPreferences.setValue("fileEntriesPerPage", "");
        portletPreferences.setValue("fileEntryColumns", "");
        portletPreferences.setValue("folderColumns", "");
        portletPreferences.setValue("foldersPerPage", "");
        portletPreferences.setValue("rootFolderId", "");
        portletPreferences.setValue("showFoldersSearch", "");
        portletPreferences.setValue("showSubfolders", "");
        return portletPreferences;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        StagedModelRepository stagedModelRepository;
        portletDataContext.addPortletPermissions("com.liferay.document.library");
        Element rootElement = this.addExportDataRootElement(portletDataContext);
        rootElement.addAttribute("group-id", String.valueOf(portletDataContext.getScopeGroupId()));
        if (portletDataContext.getBooleanParameter(NAMESPACE, "folders")) {
            stagedModelRepository = StagedModelRepositoryRegistryUtil.getStagedModelRepository((String)DLFolder.class.getName());
            ExportActionableDynamicQuery folderActionableDynamicQuery = stagedModelRepository.getExportActionableDynamicQuery(portletDataContext);
            folderActionableDynamicQuery.performActions();
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "documents")) {
            stagedModelRepository = StagedModelRepositoryRegistryUtil.getStagedModelRepository((String)DLFileEntry.class.getName());
            ExportActionableDynamicQuery fileEntryActionableDynamicQuery = stagedModelRepository.getExportActionableDynamicQuery(portletDataContext);
            fileEntryActionableDynamicQuery.performActions();
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "document-types")) {
            stagedModelRepository = StagedModelRepositoryRegistryUtil.getStagedModelRepository((String)DLFileEntryType.class.getName());
            ExportActionableDynamicQuery fileEntryTypeActionableDynamicQuery = stagedModelRepository.getExportActionableDynamicQuery(portletDataContext);
            fileEntryTypeActionableDynamicQuery.performActions();
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "repositories")) {
            stagedModelRepository = StagedModelRepositoryRegistryUtil.getStagedModelRepository((String)Repository.class.getName());
            ExportActionableDynamicQuery repositoryActionableDynamicQuery = stagedModelRepository.getExportActionableDynamicQuery(portletDataContext);
            repositoryActionableDynamicQuery.performActions();
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "shortcuts")) {
            stagedModelRepository = StagedModelRepositoryRegistryUtil.getStagedModelRepository((String)DLFileShortcut.class.getName());
            ExportActionableDynamicQuery fileShortcutActionableDynamicQuery = stagedModelRepository.getExportActionableDynamicQuery(portletDataContext);
            fileShortcutActionableDynamicQuery.performActions();
        }
        return this.getExportDataRootElementString(rootElement);
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        portletDataContext.importPortletPermissions("com.liferay.document.library");
        if (portletDataContext.getBooleanParameter(NAMESPACE, "folders")) {
            Element foldersElement = portletDataContext.getImportDataGroupElement(DLFolder.class);
            List folderElements = foldersElement.elements();
            for (Element folderElement : folderElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)folderElement);
            }
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "documents")) {
            Element fileEntriesElement = portletDataContext.getImportDataGroupElement(DLFileEntry.class);
            List fileEntryElements = fileEntriesElement.elements();
            for (Element fileEntryElement : fileEntryElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)fileEntryElement);
            }
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "document-types")) {
            Element fileEntryTypesElement = portletDataContext.getImportDataGroupElement(DLFileEntryType.class);
            List fileEntryTypeElements = fileEntryTypesElement.elements();
            for (Element fileEntryTypeElement : fileEntryTypeElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)fileEntryTypeElement);
            }
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "repositories")) {
            Element repositoriesElement = portletDataContext.getImportDataGroupElement(Repository.class);
            List repositoryElements = repositoriesElement.elements();
            for (Element repositoryElement : repositoryElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)repositoryElement);
            }
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "shortcuts")) {
            Element fileShortcutsElement = portletDataContext.getImportDataGroupElement(DLFileShortcut.class);
            List fileShortcutElements = fileShortcutsElement.elements();
            for (Element fileShortcutElement : fileShortcutElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)fileShortcutElement);
            }
        }
        return portletPreferences;
    }

    protected void doPrepareManifestSummary(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws Exception {
        if (ExportImportDateUtil.isRangeFromLastPublishDate((PortletDataContext)portletDataContext)) {
            this._staging.populateLastPublishDateCounts(portletDataContext, new StagedModelType[]{new StagedModelType(DLFileEntry.class.getName()), new StagedModelType(DLFileEntryType.class.getName()), new StagedModelType(DLFileShortcut.class.getName()), new StagedModelType(DLFolder.class.getName()), new StagedModelType(Repository.class.getName())});
            return;
        }
        StagedModelRepository fileShortcutStagedModelRepository = StagedModelRepositoryRegistryUtil.getStagedModelRepository((String)DLFileShortcut.class.getName());
        ExportActionableDynamicQuery dlFileShortcutActionableDynamicQuery = fileShortcutStagedModelRepository.getExportActionableDynamicQuery(portletDataContext);
        dlFileShortcutActionableDynamicQuery.performCount();
        StagedModelRepository fileEntryStagedModelRepository = StagedModelRepositoryRegistryUtil.getStagedModelRepository((String)DLFileEntry.class.getName());
        ExportActionableDynamicQuery fileEntryActionableDynamicQuery = fileEntryStagedModelRepository.getExportActionableDynamicQuery(portletDataContext);
        fileEntryActionableDynamicQuery.performCount();
        StagedModelRepository dlFileEntryTypeStagedModelRepository = StagedModelRepositoryRegistryUtil.getStagedModelRepository((String)DLFileEntryType.class.getName());
        ExportActionableDynamicQuery fileEntryTypeActionableDynamicQuery = dlFileEntryTypeStagedModelRepository.getExportActionableDynamicQuery(portletDataContext);
        fileEntryTypeActionableDynamicQuery.performCount();
        StagedModelRepository folderStagedModelRepository = StagedModelRepositoryRegistryUtil.getStagedModelRepository((String)DLFolder.class.getName());
        ExportActionableDynamicQuery folderActionableDynamicQuery = folderStagedModelRepository.getExportActionableDynamicQuery(portletDataContext);
        folderActionableDynamicQuery.performCount();
        StagedModelRepository repositoryStagedModelRepository = StagedModelRepositoryRegistryUtil.getStagedModelRepository((String)Repository.class.getName());
        ExportActionableDynamicQuery repositoryActionableDynamicQuery = repositoryStagedModelRepository.getExportActionableDynamicQuery(portletDataContext);
        repositoryActionableDynamicQuery.performCount();
    }
}

