/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.display.context;

import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.service.DLAppServiceUtil;
import com.liferay.document.library.kernel.service.DLFileEntryTypeLocalServiceUtil;
import com.liferay.document.library.portlet.toolbar.contributor.DLPortletToolbarContributor;
import com.liferay.document.library.web.internal.display.context.DLAdminDisplayContext;
import com.liferay.document.library.web.internal.display.context.logic.DLPortletInstanceSettingsHelper;
import com.liferay.document.library.web.internal.display.context.util.DLRequestHelper;
import com.liferay.document.library.web.internal.settings.DLPortletInstanceSettings;
import com.liferay.document.library.web.internal.util.DLTrashUtil;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.CreationMenu;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.SafeConsumer;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.ViewTypeItemList;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.servlet.taglib.ui.Menu;
import com.liferay.portal.kernel.servlet.taglib.ui.URLMenuItem;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.staging.StagingGroupHelper;
import com.liferay.staging.StagingGroupHelperUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class DLAdminManagementToolbarDisplayContext {
    private final PortletURL _currentURLObj;
    private final DLAdminDisplayContext _dlAdminDisplayContext;
    private final DLPortletInstanceSettingsHelper _dlPortletInstanceSettingsHelper;
    private final DLRequestHelper _dlRequestHelper;
    private final DLTrashUtil _dlTrashUtil;
    private final LiferayPortletRequest _liferayPortletRequest;
    private final LiferayPortletResponse _liferayPortletResponse;
    private final HttpServletRequest _request;
    private final ThemeDisplay _themeDisplay;

    public DLAdminManagementToolbarDisplayContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, HttpServletRequest request, DLAdminDisplayContext dlAdminDisplayContext) {
        this._liferayPortletRequest = liferayPortletRequest;
        this._liferayPortletResponse = liferayPortletResponse;
        this._request = request;
        this._dlAdminDisplayContext = dlAdminDisplayContext;
        this._currentURLObj = PortletURLUtil.getCurrent((LiferayPortletRequest)liferayPortletRequest, (LiferayPortletResponse)liferayPortletResponse);
        this._dlRequestHelper = new DLRequestHelper(this._request);
        this._dlPortletInstanceSettingsHelper = new DLPortletInstanceSettingsHelper(this._dlRequestHelper);
        this._dlTrashUtil = (DLTrashUtil)this._request.getAttribute("DOCUMENT_LIBRARY_TRASH_UTIL");
        this._themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public List<DropdownItem> getActionDropdownItems() {
        User user = this._themeDisplay.getUser();
        if (!this._dlPortletInstanceSettingsHelper.isShowActions() || user.isDefaultUser()) {
            return null;
        }
        return new DropdownItemList(){
            {
                boolean stagedActions = false;
                Group scopeGroup = DLAdminManagementToolbarDisplayContext.this._themeDisplay.getScopeGroup();
                StagingGroupHelper stagingGroupHelper = StagingGroupHelperUtil.getStagingGroupHelper();
                if (!stagingGroupHelper.isLiveGroup(scopeGroup) || !stagingGroupHelper.isStagedPortlet(scopeGroup, "com_liferay_document_library_web_portlet_DLPortlet")) {
                    stagedActions = true;
                }
                if (stagedActions) {
                    this.add(SafeConsumer.ignore(dropdownItem -> {
                        dropdownItem.putData("action", "download");
                        dropdownItem.setIcon("download");
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)DLAdminManagementToolbarDisplayContext.this._request, (String)"download"));
                        dropdownItem.setQuickAction(true);
                    }));
                    this.add(SafeConsumer.ignore(dropdownItem -> {
                        dropdownItem.putData("action", "move");
                        dropdownItem.setIcon("change");
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)DLAdminManagementToolbarDisplayContext.this._request, (String)"move"));
                        dropdownItem.setQuickAction(true);
                    }));
                }
                this.add(SafeConsumer.ignore(dropdownItem -> {
                    dropdownItem.putData("action", "deleteEntries");
                    if (DLAdminManagementToolbarDisplayContext.this._dlTrashUtil.isTrashEnabled(scopeGroup.getGroupId(), DLAdminManagementToolbarDisplayContext.this._getRepositoryId())) {
                        dropdownItem.setIcon("trash");
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)DLAdminManagementToolbarDisplayContext.this._request, (String)"move-to-recycle-bin"));
                    } else {
                        dropdownItem.setIcon("times");
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)DLAdminManagementToolbarDisplayContext.this._request, (String)"delete"));
                    }
                    dropdownItem.setQuickAction(true);
                }));
                if (stagedActions) {
                    this.add(SafeConsumer.ignore(dropdownItem -> {
                        dropdownItem.putData("action", "checkin");
                        dropdownItem.setIcon("unlock");
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)DLAdminManagementToolbarDisplayContext.this._request, (String)"checkin"));
                        dropdownItem.setQuickAction(false);
                    }));
                    this.add(SafeConsumer.ignore(dropdownItem -> {
                        dropdownItem.putData("action", "checkout");
                        dropdownItem.setIcon("lock");
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)DLAdminManagementToolbarDisplayContext.this._request, (String)"checkout[document]"));
                        dropdownItem.setQuickAction(false);
                    }));
                }
            }
        };
    }

    public String getClearResultsURL() {
        PortletURL clearResultsURL = this._liferayPortletResponse.createRenderURL();
        clearResultsURL.setParameter("mvcRenderCommandName", "/document_library/view");
        clearResultsURL.setParameter("folderId", String.valueOf(this._getFolderId()));
        return clearResultsURL.toString();
    }

    public CreationMenu getCreationMenu() {
        String portletName = this._liferayPortletRequest.getPortletName();
        if (!portletName.equals("com_liferay_document_library_web_portlet_DLAdminPortlet")) {
            return null;
        }
        DLPortletToolbarContributor dlPortletToolbarContributor = (DLPortletToolbarContributor)this._request.getAttribute("DOCUMENT_LIBRARY_PORTLET_TOOLBAR_CONTRIBUTOR");
        List menus = dlPortletToolbarContributor.getPortletTitleMenus((PortletRequest)this._liferayPortletRequest, (PortletResponse)this._liferayPortletResponse);
        if (menus.isEmpty()) {
            return null;
        }
        CreationMenu creationMenu = new CreationMenu();
        for (Menu menu : menus) {
            List urlMenuItems = menu.getMenuItems();
            for (URLMenuItem urlMenuItem : urlMenuItems) {
                creationMenu.addDropdownItem(dropdownItem -> {
                    dropdownItem.setHref((Object)urlMenuItem.getURL());
                    dropdownItem.setLabel(urlMenuItem.getLabel());
                });
            }
        }
        return creationMenu;
    }

    public List<DropdownItem> getFilterDropdownItems() {
        if (this._isSearch()) {
            return null;
        }
        return new DropdownItemList(){
            {
                this.addGroup(SafeConsumer.ignore(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(DLAdminManagementToolbarDisplayContext.this._getFilterNavigationDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)DLAdminManagementToolbarDisplayContext.this._request, (String)"filter-by-navigation"));
                }));
                if (!DLAdminManagementToolbarDisplayContext.this._isNavigationRecent()) {
                    this.addGroup(dropdownGroupItem -> {
                        dropdownGroupItem.setDropdownItems(DLAdminManagementToolbarDisplayContext.this._getOrderByDropdownItems());
                        dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)DLAdminManagementToolbarDisplayContext.this._request, (String)"order-by"));
                    });
                }
            }
        };
    }

    public PortletURL getSearchURL() {
        PortletURL searchURL = this._liferayPortletResponse.createRenderURL();
        searchURL.setParameter("mvcRenderCommandName", "/document_library/search");
        long repositoryId = this._getRepositoryId();
        searchURL.setParameter("repositoryId", String.valueOf(repositoryId));
        long searchRepositoryId = ParamUtil.getLong((HttpServletRequest)this._request, (String)"searchRepositoryId", (long)repositoryId);
        searchURL.setParameter("searchRepositoryId", String.valueOf(searchRepositoryId));
        long folderId = this._getFolderId();
        searchURL.setParameter("folderId", String.valueOf(folderId));
        long searchFolderId = ParamUtil.getLong((HttpServletRequest)this._request, (String)"searchFolderId", (long)folderId);
        searchURL.setParameter("searchFolderId", String.valueOf(searchFolderId));
        searchURL.setParameter("showSearchInfo", Boolean.TRUE.toString());
        return searchURL;
    }

    public String getSortingOrder() {
        if (this._isSearch()) {
            return null;
        }
        return this._dlAdminDisplayContext.getOrderByType();
    }

    public PortletURL getSortingURL() {
        if (this._isSearch()) {
            return null;
        }
        PortletURL sortingURL = this._getCurrentSortingURL();
        sortingURL.setParameter("orderByType", Objects.equals(this._getOrderByType(), "asc") ? "desc" : "asc");
        return sortingURL;
    }

    public int getTotalItems() {
        SearchContainer searchContainer = this._dlAdminDisplayContext.getSearchContainer();
        return searchContainer.getTotal();
    }

    public ViewTypeItemList getViewTypes() {
        if (this._isSearch()) {
            return null;
        }
        String navigation = ParamUtil.getString((HttpServletRequest)this._request, (String)"navigation", (String)"home");
        int curEntry = ParamUtil.getInteger((HttpServletRequest)this._request, (String)"curEntry");
        int deltaEntry = ParamUtil.getInteger((HttpServletRequest)this._request, (String)"deltaEntry");
        long folderId = this._getFolderId();
        long fileEntryTypeId = this._getFileEntryTypeId();
        String keywords = ParamUtil.getString((HttpServletRequest)this._request, (String)"keywords");
        PortletURL displayStyleURL = this._liferayPortletResponse.createRenderURL();
        String mvcRenderCommandName = "/document_library/search";
        if (Validator.isNull((String)keywords)) {
            mvcRenderCommandName = folderId == 0L ? "/document_library/view" : "/document_library/view_folder";
        }
        displayStyleURL.setParameter("mvcRenderCommandName", mvcRenderCommandName);
        displayStyleURL.setParameter("navigation", HtmlUtil.escapeJS((String)navigation));
        if (curEntry > 0) {
            displayStyleURL.setParameter("curEntry", String.valueOf(curEntry));
        }
        if (deltaEntry > 0) {
            displayStyleURL.setParameter("deltaEntry", String.valueOf(deltaEntry));
        }
        displayStyleURL.setParameter("folderId", String.valueOf(folderId));
        if (fileEntryTypeId != -1L) {
            displayStyleURL.setParameter("fileEntryTypeId", String.valueOf(fileEntryTypeId));
        }
        return new ViewTypeItemList(displayStyleURL, this._getDisplayStyle()){
            {
                if (ArrayUtil.contains((Object[])DLAdminManagementToolbarDisplayContext.this._getDisplayViews(), (Object)"icon")) {
                    this.addCardViewTypeItem();
                }
                if (ArrayUtil.contains((Object[])DLAdminManagementToolbarDisplayContext.this._getDisplayViews(), (Object)"descriptive")) {
                    this.addListViewTypeItem();
                }
                if (ArrayUtil.contains((Object[])DLAdminManagementToolbarDisplayContext.this._getDisplayViews(), (Object)"list")) {
                    this.addTableViewTypeItem();
                }
            }
        };
    }

    public boolean isDisabled() {
        try {
            int count = DLAppServiceUtil.getFoldersAndFileEntriesAndFileShortcutsCount((long)this._getRepositoryId(), (long)this._getFolderId(), (int)-1, (boolean)true);
            return count <= 0;
        }
        catch (PortalException pe) {
            throw new SystemException((Throwable)pe);
        }
    }

    public boolean isSelectable() {
        return true;
    }

    public boolean isShowSearch() {
        return this._dlPortletInstanceSettingsHelper.isShowSearch();
    }

    private PortletURL _getCurrentSortingURL() {
        int deltaEntry = ParamUtil.getInteger((HttpServletRequest)this._request, (String)"deltaEntry");
        PortletURL sortingURL = this._liferayPortletResponse.createRenderURL();
        long folderId = this._getFolderId();
        if (folderId == 0L) {
            sortingURL.setParameter("mvcRenderCommandName", "/document_library/view");
        } else {
            sortingURL.setParameter("mvcRenderCommandName", "/document_library/view_folder");
        }
        sortingURL.setParameter("navigation", this._getNavigation());
        if (deltaEntry > 0) {
            sortingURL.setParameter("deltaEntry", String.valueOf(deltaEntry));
        }
        sortingURL.setParameter("folderId", String.valueOf(folderId));
        long fileEntryTypeId = this._getFileEntryTypeId();
        sortingURL.setParameter("fileEntryTypeId", String.valueOf(fileEntryTypeId));
        return sortingURL;
    }

    private String _getDisplayStyle() {
        return this._dlAdminDisplayContext.getDisplayStyle();
    }

    private String[] _getDisplayViews() {
        DLPortletInstanceSettings dlPortletInstanceSettings = this._dlRequestHelper.getDLPortletInstanceSettings();
        return dlPortletInstanceSettings.getDisplayViews();
    }

    private long _getFileEntryTypeId() {
        return ParamUtil.getLong((HttpServletRequest)this._request, (String)"fileEntryTypeId", (long)-1L);
    }

    private List<DropdownItem> _getFilterNavigationDropdownItems() {
        final long fileEntryTypeId = this._getFileEntryTypeId();
        final String navigation = ParamUtil.getString((HttpServletRequest)this._request, (String)"navigation", (String)"home");
        return new DropdownItemList(){
            {
                this.add(SafeConsumer.ignore(dropdownItem -> {
                    dropdownItem.setActive(navigation.equals("home") && fileEntryTypeId == -1L);
                    PortletURL viewAllDocumentsURL = PortletURLUtil.clone((PortletURL)DLAdminManagementToolbarDisplayContext.this._currentURLObj, (LiferayPortletResponse)DLAdminManagementToolbarDisplayContext.this._liferayPortletResponse);
                    viewAllDocumentsURL.setParameter("mvcRenderCommandName", "/document_library/view");
                    viewAllDocumentsURL.setParameter("navigation", "home");
                    viewAllDocumentsURL.setParameter("browseBy", (String)null);
                    viewAllDocumentsURL.setParameter("fileEntryTypeId", (String)null);
                    dropdownItem.setHref((Object)viewAllDocumentsURL);
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)DLAdminManagementToolbarDisplayContext.this._request, (String)"all"));
                }));
                this.add(SafeConsumer.ignore(dropdownItem -> {
                    dropdownItem.setActive(navigation.equals("recent"));
                    PortletURL viewRecentDocumentsURL = PortletURLUtil.clone((PortletURL)DLAdminManagementToolbarDisplayContext.this._currentURLObj, (LiferayPortletResponse)DLAdminManagementToolbarDisplayContext.this._liferayPortletResponse);
                    viewRecentDocumentsURL.setParameter("mvcRenderCommandName", "/document_library/view");
                    viewRecentDocumentsURL.setParameter("navigation", "recent");
                    dropdownItem.setHref((Object)viewRecentDocumentsURL);
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)DLAdminManagementToolbarDisplayContext.this._request, (String)"recent"));
                }));
                if (DLAdminManagementToolbarDisplayContext.this._themeDisplay.isSignedIn()) {
                    this.add(SafeConsumer.ignore(dropdownItem -> {
                        dropdownItem.setActive(navigation.equals("mine"));
                        PortletURL viewMyDocumentsURL = PortletURLUtil.clone((PortletURL)DLAdminManagementToolbarDisplayContext.this._currentURLObj, (LiferayPortletResponse)DLAdminManagementToolbarDisplayContext.this._liferayPortletResponse);
                        viewMyDocumentsURL.setParameter("mvcRenderCommandName", "/document_library/view");
                        viewMyDocumentsURL.setParameter("navigation", "mine");
                        dropdownItem.setHref((Object)viewMyDocumentsURL);
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)DLAdminManagementToolbarDisplayContext.this._request, (String)"mine"));
                    }));
                }
                this.add(SafeConsumer.ignore(dropdownItem -> {
                    dropdownItem.setActive(fileEntryTypeId != -1L);
                    dropdownItem.putData("action", "openDocumentTypesSelector");
                    String label = LanguageUtil.get((HttpServletRequest)DLAdminManagementToolbarDisplayContext.this._request, (String)"document-types");
                    if (fileEntryTypeId != -1L) {
                        String fileEntryTypeName = LanguageUtil.get((HttpServletRequest)DLAdminManagementToolbarDisplayContext.this._request, (String)"basic-document");
                        if (fileEntryTypeId != 0L) {
                            DLFileEntryType fileEntryType = DLFileEntryTypeLocalServiceUtil.getFileEntryType((long)fileEntryTypeId);
                            fileEntryTypeName = fileEntryType.getName(DLAdminManagementToolbarDisplayContext.this._request.getLocale());
                        }
                        label = String.format("%s: %s", label, fileEntryTypeName);
                    }
                    dropdownItem.setLabel(label);
                }));
            }
        };
    }

    private long _getFolderId() {
        if (this._isSearch()) {
            return ParamUtil.getLong((HttpServletRequest)this._request, (String)"folderId");
        }
        return this._dlAdminDisplayContext.getFolderId();
    }

    private String _getNavigation() {
        return ParamUtil.getString((HttpServletRequest)this._request, (String)"navigation", (String)"home");
    }

    private String _getOrderByCol() {
        return this._dlAdminDisplayContext.getOrderByCol();
    }

    private List<DropdownItem> _getOrderByDropdownItems() {
        final HashMap<String, String> orderColumns = new HashMap<String, String>();
        orderColumns.put("creationDate", "create-date");
        if (this._getFileEntryTypeId() == -1L) {
            orderColumns.put("downloads", "downloads");
        }
        orderColumns.put("modifiedDate", "modified-date");
        orderColumns.put("size", "size");
        orderColumns.put("title", "title");
        return new DropdownItemList(){
            {
                for (Map.Entry orderByColEntry : orderColumns.entrySet()) {
                    String orderByCol = (String)orderByColEntry.getKey();
                    this.add(SafeConsumer.ignore(dropdownItem -> {
                        dropdownItem.setActive(orderByCol.equals(DLAdminManagementToolbarDisplayContext.this._getOrderByCol()));
                        dropdownItem.setHref(DLAdminManagementToolbarDisplayContext.this._getCurrentSortingURL(), new Object[]{"orderByCol", orderByCol});
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)DLAdminManagementToolbarDisplayContext.this._request, (String)((String)orderByColEntry.getValue())));
                    }));
                }
            }
        };
    }

    private String _getOrderByType() {
        return this._dlAdminDisplayContext.getOrderByType();
    }

    private long _getRepositoryId() {
        return this._dlAdminDisplayContext.getRepositoryId();
    }

    private boolean _isNavigationRecent() {
        return Objects.equals(this._getNavigation(), "recent");
    }

    private boolean _isSearch() {
        return this._dlAdminDisplayContext.isSearch();
    }
}

