/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.portlet.configuration.icon;

import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.document.library.web.internal.display.context.logic.UIItemsBuilder;
import com.liferay.document.library.web.internal.portlet.action.ActionUtil;
import com.liferay.document.library.web.internal.util.DLTrashUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.configuration.icon.BasePortletConfigurationIcon;
import com.liferay.portal.kernel.portlet.configuration.icon.PortletConfigurationIcon;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.util.PropsValues;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_document_library_web_portlet_DLAdminPortlet", "path=/document_library/view_file_entry"}, service={PortletConfigurationIcon.class})
public class OpenInMSOfficeFileEntryPortletConfigurationIcon
extends BasePortletConfigurationIcon {
    @Reference
    private DLTrashUtil _dlTrashUtil;
    @Reference
    private Portal _portal;

    public String getMessage(PortletRequest portletRequest) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((Locale)themeDisplay.getLocale(), OpenInMSOfficeFileEntryPortletConfigurationIcon.class);
        return LanguageUtil.get((ResourceBundle)resourceBundle, (String)"open-in-ms-office");
    }

    public String getOnClick(PortletRequest portletRequest, PortletResponse portletResponse) {
        StringBundler sb = new StringBundler(4);
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        try {
            FileEntry fileEntry = ActionUtil.getFileEntry(portletRequest);
            String webDavURL = DLUtil.getWebDavURL((ThemeDisplay)themeDisplay, (Folder)fileEntry.getFolder(), (FileEntry)fileEntry, (boolean)PropsValues.DL_FILE_ENTRY_OPEN_IN_MS_OFFICE_MANUAL_CHECK_IN_REQUIRED);
            PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
            sb.append(portletDisplay.getNamespace());
            sb.append("openDocument('");
            sb.append(webDavURL);
            sb.append("');");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    public String getURL(PortletRequest portletRequest, PortletResponse portletResponse) {
        return "javascript:;";
    }

    public double getWeight() {
        return 107.0;
    }

    public boolean isShow(PortletRequest portletRequest) {
        try {
            HttpServletRequest request = this._portal.getHttpServletRequest(portletRequest);
            FileEntry fileEntry = ActionUtil.getFileEntry(portletRequest);
            FileVersion fileVersion = ActionUtil.getFileVersion(portletRequest, fileEntry);
            ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((Locale)themeDisplay.getLocale(), OpenInMSOfficeFileEntryPortletConfigurationIcon.class);
            UIItemsBuilder uiItemsBuilder = new UIItemsBuilder(request, fileVersion, resourceBundle, this._dlTrashUtil);
            return uiItemsBuilder.isOpenInMsOfficeActionAvailable();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isToolTip() {
        return false;
    }

    public boolean isUseDialog() {
        return true;
    }
}

